Include trusted "assignment.g".
Include trusted "unitprop.g".
Include trusted "init.g".
Include trusted "conflict.g".

%=============================================================================
% backtracking
%=============================================================================

Inductive backtrack_t : Fun(nv:word)(F:formula).type :=
  backtrack_return : Fun(spec nv:word)(spec F:formula)
											  (#unique as:<AssignState nv F>)
											  (#unique ds:<DecisionState nv>)
												.#unique <backtrack_t nv F>
.

Define backtrack :=
  fun backtrack(nv:word)(spec F:formula)
               (#unique as:<AssignState nv F>)
							 (#unique ds:<DecisionState nv>)
               (dl:word)  % new decision level
              : #unique <backtrack_t nv F>.
  match as with assign_state _ _ nv_ub pa why dls hist hist_cur hist_end =>
  abbrev nv' = (inc_nv nv nv_ub) in
  match (ltword word0 hist_end) by q1 _ with
    ff =>
			let as' = (assign_state nv F nv_ub pa why dls hist word0 word0) in
			(backtrack_return nv F as' ds)
  | tt =>
      let hist_end' = (word_dec_safe hist_end q1) in
      let histi = (inspect_unique <uwarray ulit nv> hist) in
      match (ltword hist_end' nv) by q2 _ with ff => abort <backtrack_t nv F> | tt =>
			let l = (uwarray_get ulit nv histi hist_end' q2) in
			let vv = (ulit_vnum l) in
			match (leword vv nv) by q3' _ with ff => abort <backtrack_t nv F> | tt =>
			abbrev q3 = [leword_nv_implies_ltword_inc_nv nv nv_ub vv q3'] in
			let dlsi = (inspect_unique <uwarray word nv'> dls) in
			let vl = (uwarray_get word nv' dlsi vv q3) in
			match (ltword dl vl) with
				ff => % don't cancel it
					do
						(consume_unique_owned <uwarray ulit nv> histi)
						(consume_unique_owned <uwarray word nv'> dlsi)
						let as' = (assign_state nv F nv_ub pa why dls hist hist_end hist_end) in
						(backtrack_return nv F as' ds)
					end
			| tt => % cancel it and continue
					let pa' = (uwarray_set assignment nv' pa vv UN q3) in
					do
						(consume_unique_owned <uwarray ulit nv> histi)
						(consume_unique_owned <uwarray word nv'> dlsi)
						let as' = (assign_state nv F nv_ub pa' why dls hist hist_cur hist_end') in
						let ds' = (insertVarOrder nv ds vv q3') in
						(backtrack nv F as' ds' dl)
					end
			end
			end end % [assert]
  end
  end.


%=============================================================================
% solve_impl
%=============================================================================

Inductive AnswerImpl : Fun(nv:word)(F:formula).type :=
  sat_impl : Fun(spec nv:word)(spec F:formula)
								(#unique as:<AssignState nv F>)
							 .#unique <AnswerImpl nv F>
| unsat_impl : Fun(spec nv:word)(spec F:formula)
                  (nv_ub:{ (ltword nv var_upper_bound) = tt })
                  (#unique as:<AssignState nv F>)
									(#unique ds:<DecisionState nv>)
                  (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
                  (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
                  (cc:<aclause nv F>)
								 .#unique <AnswerImpl nv F>
.

Define solve_main :=
  fun solve_main(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
                (spec F:formula)
								(#unique as:<AssignState nv F>)   % current assignment & history
								(#unique ds:<DecisionState nv>)
								(#unique ws:<WatchState nv F>)    % watched-literals state
                (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
                (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
								(dl:word)
               : #unique <AnswerImpl nv F>.
	match (propagate nv F as ws dl) with
		propagate_continue _ _ as ws => % need decision
		  match (decideLit nv F as ds) by q1 ign with
			  decide_nothing _ _ _ ds' => % no more vars => SAT
					do
					  (consume_unique <DecisionState nv> ds')
					  (consume_unique <WatchState nv F> ws)
					  (consume_unique <uwarray assignment (inc_nv nv nv_ub)> vt)
						(sat_impl nv F as)
					end
			| decide_something _ _ _ ds' l p1 => % continue with dl+1
					match (ltword dl nv) by q2 ign with
					  ff => % decision level is bounded by the number of variables
							abort <AnswerImpl nv F>
					| tt =>
							abbrev q1' = hypjoin (decideLit nv as ds) (decide_something ds' l) by q1 end in
              abbrev p2 = [ltword_implies_ltword_word_max dl nv q2] in
							let dl' = (word_inc_safe dl p2) in
							let as' = (assign nv F as l (nothing <aclause nv F>) dl' p1) in
							(solve_main nv nv_ub F as' ds' ws vt vt_eq dl')
					end
		  end

	| propagate_conflict _ _ as ws cc =>
			match (ltword word0 dl) by q_dl ign with
			  ff => % conflict at level 0 => UNSAT
          do
          (consume_unique <WatchState nv F> ws)
          (unsat_impl nv F nv_ub as ds vt vt_eq cc)
          end

			| tt => % continue with backjump
          let cci = (inspect <aclause nv F> cc) in
					let ds = (decayActivity nv ds) in
					match (derive nv nv_ub F as dl ds vt vt_eq cci) with derive_return _ _ ds' vt' vt'_eq _ cc' uip dl' =>
					match (backtrack nv F as ds' dl') with backtrack_return _ _ as' ds'' =>
					let ws' = % add the learned clause if it's not unit
						match (ltword word0 dl') with
							ff => ws
						| tt => (addWatchedClause nv F as' ws (inc <aclause nv F> cc'))
						end
					in
					let uip' = (to_ulit (inspect lit uip)) in
					match (ltword word0 (ulit_vnum uip')) with ff => abort <AnswerImpl nv F> | tt =>
					match (leword (ulit_vnum uip') nv) by q2 _ with ff => abort <AnswerImpl nv F> | tt =>
					match (unassigned nv F as' (ulit_vnum uip') q2) by q3 _ with ff => abort <AnswerImpl nv F> | tt =>
					abbrev q3' = hypjoin (unassigned as' (ulit_vnum uip')) tt by q3 end in
					let as'' = (assign nv F as' uip' (something <aclause nv F> cc') dl' q3') in
					do
					(consume_unowned lit uip)
          (consume_unowned <aclause nv F> cc)
					(solve_main nv nv_ub F as'' ds'' ws' vt' vt'_eq dl')
					end
					end end end end end
			end
	end.


%=============================================================================
% evalutaing formula under an interpretation (model checking)
%=============================================================================

Define lit_eval :=
  fun(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
     (!#unique_owned pa:<uwarray assignment (inc_nv nv nv_ub)>)
     (^#owned l:lit)
  : bool.
  abbrev nv' = (inc_nv nv nv_ub) in
  let v = (lit_vnum (clone_owned lit l)) in
  match (ltword v nv') by q1 _ with
    ff => ff % out of bounds (considered falsified)
  | tt => 
      let val = (uwarray_get assignment nv' pa v q1) in
      match val with
        UN => ff
      | TT => (lit_sign l)
      | FF => (not (lit_sign l))
      end
  end.
  
Define cl_eval := fun cl_eval
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned pa:<uwarray assignment (inc_nv nv nv_ub)>)
  (^#owned c:clause)
	: bool.
  match c with
    nil _ => ff
  | cons _ l c' =>
      match (lit_eval nv nv_ub pa l) with
        ff => (cl_eval nv nv_ub pa c')
      | tt => tt
      end
  end.

Define form_eval := fun form_eval
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (!#unique_owned pa:<uwarray assignment (inc_nv nv nv_ub)>)
  (^#owned f:formula)
	: bool.
  match f with
    nil _ => tt
  | cons _ c f' =>
      match (cl_eval nv nv_ub pa c) with
        ff => ff
      | tt => (form_eval nv nv_ub pa f')
      end
  end.


%=============================================================================
% entry point of actual implementation
%=============================================================================

Define check_model := fun
  (nv:word)
  (^f:formula)
  (^#unique as:<AssignState nv f>)
  .
  match as with assign_state _ _ nv_ub pa _ _ _ _ _ =>
  let pai = (inspect_unique <uwarray assignment (inc_nv nv nv_ub)> pa) in
  let fi = (inspect formula f) in
  match (form_eval nv nv_ub pai fi) by q1 _ with
    ff => abort <answer f>
  | tt =>
      let rval = (sat f) in
      do
      (consume_unique_owned <uwarray assignment (inc_nv nv nv_ub)> pai)
      (consume_unique <uwarray assignment (inc_nv nv nv_ub)> pa)
      (consume_unowned formula f)
      rval
      end
  end
  end.

Define check_empty_clause :=
  fun(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
     (spec F:formula)
		 (!#unique as:<AssignState nv F>)
		 (#unique ds:<DecisionState nv>)
     (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
     (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
		 (^#owned cc:<aclause nv F>)
	  : <answer F>.
	match (derive nv nv_ub F as word0 ds vt vt_eq cc) with derive_return _ _ _ _ _ _ cc' _ _ =>
	match !cc' with mk_aclause n la _ _ lb c cp c_eq =>
	abbrev p1 = [array_in_bounds_implies_ltword_word0 nv n la lb] in
	let x = (uwarray_get ulit n la word0 p1) in
	match (eq_ulit x ulit_null) by q1 ign with
		ff => % conflicts at this level should result in the empty clause!
			abort <answer F>
	| tt =>
			% need p2 : { c = nil }
			abbrev p2_1 = hypjoin (eq_ulit (uwarray_get la word0) ulit_null) tt
											by q1 x_eq end in
			abbrev p2 = [aclause_empty nv n la lb c c_eq p2_1] in
			abbrev cp' = cast cp by cong <pf F *> p2 in
			do
				(consume_unique_owned <uwarray ulit n> la)
				(consume_unowned <aclause nv F> cc')
				(unsat F cp')
			end
	end
	end end.

Define solve_impl :=
  fun(nv:word)(F:formula).
	match (ltword nv var_upper_bound) by nv_ub _ with ff => abort <answer F> | tt =>
	match (initState nv nv_ub F) with
		init_ok _ _ _ as ds ws vt vt_eq =>
			match (solve_main nv nv_ub F as ds ws vt vt_eq word0) with
				sat_impl _ _ as =>
					% the current assignment should satisfy the formula
					% run-time check here because doing so does not cost much
					(check_model nv F as)
			
			| unsat_impl _ _ _ as ds vt vt_eq cc =>
					% The empty clause should be derived.
					% It could be proven statically, but it's checked at run-time for now.
					let cci = (inspect <aclause nv F> cc) in
					let rval = (check_empty_clause nv nv_ub F as ds vt vt_eq cci) in
					do
						(consume_unowned formula F)
						(consume_unique <AssignState nv F> as)
						(consume_unowned <aclause nv F> cc)
						rval
					end
			end

	| init_unsat _ _ p =>
			do
			(consume_unowned formula F)
			(unsat F p)
			end
	end
	end
