%=============================================================================
% resolution.g : single resolution
%=============================================================================
Include trusted "pf_util2.g".
Include trusted "cnf-lemma2.g".
Include trusted "assignment.g".
Include trusted "assignment-util.g".

%=============================================================================
% cl_set_at_prev_levels
%=============================================================================

Define spec cl_set_at_prev_levels := fun cl_set_at_prev_levels
  (spec nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (dls:<uwarray word (inc_nv nv nv_ub)>)
  (c:clause)
  (u:{ (cl_valid nv c) = tt })
  : bool.
  abbrev nv' = (inc_nv nv nv_ub) in
  match c with
    nil _ => tt
  | cons _ l c' =>
    abbrev v = (lit_vnum l) in
    abbrev p1_1 = hypjoin (cl_valid nv (cons l c')) tt by u c_eq end in
    abbrev p1 = [cl_valid_implies_lit_valid_head nv l c' p1_1] in
    abbrev p2 = [lit_valid_implies_ltword_inc_nv nv nv_ub l p1] in
    abbrev u' = [cl_valid_implies_cl_valid_tail nv l c' p1_1] in 
    abbrev vl = (uwarray_get word nv' dls v p2) in
    match (ltword vl dl) with
      ff => ff
    | tt => (cl_set_at_prev_levels nv nv_ub dl dls c' u')
    end
  end

Define cl_set_at_prev_levels_lem1 : Forall
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (dls:<uwarray word (inc_nv nv nv_ub)>)
  (c:clause)
  (l:lit)
	(u1:{ (cl_valid nv c) = tt })
  (u2:{ (cl_set_at_prev_levels dl dls c) = tt })
  (r:{ (ltword (uwarray_get dls (lit_vnum l)) dl) = ff }) % set at current level
  .{ (cl_has c l) = ff }
  := foralli
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (dls:<uwarray word (inc_nv nv nv_ub)>)
	.
	induction(c:clause) return Forall
		(l:lit)
		(u1:{ (cl_valid nv c) = tt })
		(u2:{ (cl_set_at_prev_levels dl dls c) = tt })
		(r:{ (ltword (uwarray_get dls (lit_vnum l)) dl) = ff }) % set at current level
		.{ (cl_has c l) = ff }
	with
	| nil _ => foralli
		(l:lit)
		(u1:{ (cl_valid nv c) = tt })
		(u2:{ (cl_set_at_prev_levels dl dls c) = tt })
		(r:{ (ltword (uwarray_get dls (lit_vnum l)) dl) = ff }) % set at current level
		.
		hypjoin (cl_has c l) ff by c_eq end
	| cons _ x c' => foralli
		(l:lit)
		(u1:{ (cl_valid nv c) = tt })
		(u2:{ (cl_set_at_prev_levels dl dls c) = tt })
		(r:{ (ltword (uwarray_get dls (lit_vnum l)) dl) = ff }) % set at current level
		.
		cabbrev nv' = (inc_nv nv nv_ub)
		cabbrev v = (lit_vnum x) in
		cabbrev p1_1 = hypjoin (cl_valid nv (cons x c')) tt by u1 c_eq end in
		cabbrev p1 = [cl_valid_implies_lit_valid_head nv x c' p1_1] in
		cabbrev p2 = [lit_valid_implies_ltword_inc_nv nv nv_ub x p1] in
		cabbrev u1' = [cl_valid_implies_cl_valid_tail nv x c' p1_1] in 
		cabbrev vl = (uwarray_get word nv' dls v p2)
		case (ltword vl dl) by q2 _ with
		| ff => % contra
			contra
			trans symm u2
			trans hypjoin (cl_set_at_prev_levels dl dls c) ff by q2 c_eq end
						clash ff tt
			{ (cl_has c l) = ff }
		| tt =>
			case (eq_lit l x) by q1 _ with
			| ff =>
				cabbrev u2' = hypjoin (cl_set_at_prev_levels dl dls c') tt by u2 q2 c_eq end
				cabbrev ih = [c_IH c' l u1' u2' r]
				hypjoin (cl_has c l) ff by ih c_eq q1 end
			| tt =>	% contra
				cabbrev p3 = [eq_lit_eq l x q1]
				contra
				trans symm q2
				trans hypjoin (ltword vl dl) ff by r p3 end
				      clash ff tt
				{ (cl_has c l) = ff }
			end
		end
	end


%=============================================================================
% assignment-related lemmas adapted for resolution
%=============================================================================

Define all_lits_are_assigned_implies_the_rest : Forall
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
	(l:lit)
	(c:clause)
	(u:{ (lit_valid nv l) = tt })
	(r:{ (all_lits_are_assigned vt (cons l c)) = tt })
	.{ (all_lits_are_assigned vt c) = tt }
	:= foralli
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt:<uwarray assignment (inc_nv nv nv_ub)>)
	(l:lit)
	(c:clause)
	(u:{ (lit_valid nv l) = tt })
	(r:{ (all_lits_are_assigned vt (cons l c)) = tt })
	.
	abbrev p2 = [lit_valid_implies_ltword_inc_nv nv nv_ub l u] in
	cabbrev a = (uwarray_get assignment (inc_nv nv nv_ub) vt (lit_vnum l) p2)
	case (is_equal_assignment a (lit_sign l)) by q1 _ with
	| ff => contra
		trans symm r
		trans hypjoin (all_lits_are_assigned vt (cons l c)) ff by q1 end
		      clash ff tt
		{ (all_lits_are_assigned vt c) = tt }
	| tt =>
		hypjoin (all_lits_are_assigned vt c) tt by r q1 end
	end

Define all_lits_are_assigned_lem1' :
  Forall(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
        (vt vt':<uwarray assignment (inc_nv nv nv_ub)>)
        (c1 c2:clause)
        (l:lit)
        (u1:{ (all_lits_are_assigned vt (append c2 c1)) = tt })
				(u2:{ (lit_valid nv l) = tt })
				(u3:{ (cl_valid nv c1) = tt })
				(u4:{ (cl_valid nv c2) = tt })
				(u5:{ (is_assigned (uwarray_get vt (lit_vnum l))) = ff })
        (vt'_eq:{ vt' = (uwarray_set vt (lit_vnum l) (lit_assignment l)) })
    .{ (all_lits_are_assigned vt' (append c2 (cons l c1))) = tt }
  := foralli
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt vt':<uwarray assignment (inc_nv nv nv_ub)>)
	(c1 c2:clause)
	(l:lit)
	(u1:{ (all_lits_are_assigned vt (append c2 c1)) = tt })
	(u2:{ (lit_valid nv l) = tt })
	(u3:{ (cl_valid nv c1) = tt })
	(u4:{ (cl_valid nv c2) = tt })
	(u5:{ (is_assigned (uwarray_get vt (lit_vnum l))) = ff })
	(vt'_eq:{ vt' = (uwarray_set vt (lit_vnum l) (lit_assignment l)) })
	.
	[
	induction(c:clause) return Forall
		(r1:{ (all_lits_are_assigned vt (append c c1)) = tt })
		(r2:{ (cl_valid nv c) = tt })
		.{ (all_lits_are_assigned vt' (append c (cons l c1))) = tt }
	with
	| nil _ => foralli
		(r1:{ (all_lits_are_assigned vt (append c c1)) = tt })
		(r2:{ (cl_valid nv c) = tt })
		.
		cabbrev r1' = hypjoin (all_lits_are_assigned vt c1) tt by r1 c_eq end
		cabbrev p1 = [all_lits_are_assigned_lem1 nv nv_ub vt vt' l u5 vt'_eq c1 r1' u3]
		hypjoin (all_lits_are_assigned vt' (append c (cons l c1))) tt by p1 c_eq end
	| cons _ x c' => foralli
		(r1:{ (all_lits_are_assigned vt (append c c1)) = tt })
		(r2:{ (cl_valid nv c) = tt })
		.
		cabbrev p1 = [cl_valid_implies_lit_valid_head2 nv c x c' r2 c_eq] in
		cabbrev r2' = [cl_valid_implies_cl_valid_tail2 nv c x c' r2 c_eq] in
		cabbrev d = (append lit c c1)
		cabbrev d' = (append lit c' c1)
		cabbrev p2 = hypjoin (append c c1) (cons x (append c' c1)) by c_eq end
		cabbrev p3 = hypjoin (all_lits_are_assigned vt (cons x (append c' c1))) tt by r1 p2 end
		cabbrev p4 = [all_lits_are_assigned_implies_the_rest nv nv_ub vt x d' p1 p3]
		cabbrev ih = [c_IH c' p4 r2']
		cabbrev p5 = [all_lits_are_assigned_implies_head_is_equal_assignment nv nv_ub vt x d' p1 p3]
		
		cabbrev nv' = (inc_nv nv nv_ub)
		cabbrev a = (lit_assignment l)
		cabbrev p1' = [lit_valid_implies_ltword_inc_nv nv nv_ub x p1]
		cabbrev p6 = [lit_valid_implies_ltword_inc_nv nv nv_ub l u2]
		
		cabbrev v = (lit_vnum l)
		cabbrev a' = (uwarray_get assignment nv' vt' (lit_vnum x) p1')
		% want: (is_equal_assignment a' (lit_sign x)) = tt
		abbrev p7 =
			case (eq_lit x l) by q2 _ with
			| ff =>
				case (eqword (lit_vnum x) v) by q1 _ with
				| ff =>
					% need: (lit_vnum x) != (lit_vnum l)
					abbrev p11 = [eqword_neq (lit_vnum x) v q1] in
					abbrev p12 = [uwarray_set_get_distinct assignment nv' vt (lit_vnum x) v (lit_assignment l) p1' p6 p11] in
					hypjoin (is_equal_assignment a' (lit_sign x)) tt by p12 vt'_eq p5 end
				| tt =>
					abbrev p11 = [eqword_eq (lit_vnum x) v q1] in
					cabbrev a = (uwarray_get assignment nv' vt (lit_vnum x) p1')
					abbrev u5' = hypjoin (is_assigned a) ff by u5 p11 end
					contra
					trans symm [unassigned_implies_not_equal_assignment a (lit_sign x) u5']
					trans hypjoin (is_equal_assignment a (lit_sign x)) tt by p5 end
								clash tt ff
					{ (is_equal_assignment a' (lit_sign x)) = tt }
				end
			| tt =>
				cabbrev p11 = [eq_lit_eq x l q2]
				abbrev p1 = [uwarray_set_implies_ltword assignment nv' vt vt' v (lit_assignment l) vt'_eq] in
				abbrev p2 = [uwarray_set_get assignment nv' vt v (lit_assignment l) p1] in
				abbrev p3 = [lit_assignment_is_equal_assignment l] in
				abbrev p4 = hypjoin (is_equal_assignment (uwarray_get vt' v) (lit_sign l)) tt by vt'_eq p2 p3 end in
				hypjoin (is_equal_assignment a' (lit_sign x)) tt by p11 p4 end
			end
		hypjoin (all_lits_are_assigned vt' (append c (cons l c1))) tt by c_eq ih p7 end
	end
	c2 u1 u4]

Define cl_has_all_vars_add' : Forall
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt vt':<uwarray assignment (inc_nv nv nv_ub)>)
  (c1 c2:clause)(l:lit)
  (u:{ (cl_has_all_vars (append c2 c1) vt) = tt })
  (vt'_eq:{ vt' = (uwarray_set vt (lit_vnum l) (lit_assignment l)) })
  .{ (cl_has_all_vars (append c2 (cons l c1)) vt') = tt }
  := foralli
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(vt vt':<uwarray assignment (inc_nv nv nv_ub)>)
  (c1 c2:clause)(l:lit)
  (u:{ (cl_has_all_vars (append c2 c1) vt) = tt })
  (vt'_eq:{ vt' = (uwarray_set vt (lit_vnum l) (lit_assignment l)) })
	.
	cabbrev nv' = (inc_nv nv nv_ub)
	cabbrev c = (append lit c2 c1)
	cabbrev c' = (append lit c2 (cons lit l c1))
	cabbrev p5_1 = [le_to_nat_inc_nv_var_upper_bound nv nv_ub]
	cabbrev p =
		foralli(i:word)(r:{ (ltword i nv') = tt }).
		% goal: (check_var c' (vec_get vt' (to_nat i)) i) = tt
		cabbrev p1 = hypjoin (lt (to_nat i) (to_nat nv')) tt by r end
		cabbrev p2_1 = [uwarray_set_implies_ltword assignment nv' vt vt' (lit_vnum l) (lit_assignment l) vt'_eq]
		cabbrev p2 = hypjoin (lt (word_to_nat (lit_vnum l)) (word_to_nat nv')) tt by p2_1 end
		cabbrev p5_2 = hypjoin (lt (to_nat i) (to_nat nv')) tt by r end
		% p5: (check_var c (vec_get vt (to_nat i)) i) = t
		cabbrev p5 = [cl_has_all_vars_lem2 c (word_to_nat nv') p5_1 vt u i p5_2]
		cabbrev p7 = [cl_subsume_append_cons4 c2 c1 l]
		cabbrev p8 = [ltword_inc_nv_implies_word_msb_ff nv nv_ub i r]
		case (eqword (lit_vnum l) i) by q1 _ with
		| ff =>
			cabbrev p3_1 = [eqword_ff_neq (lit_vnum l) i q1]
			cabbrev p3 = symm [word_neq_to_nat_neq (lit_vnum l) i p3_1]

			% p4: (uwarray_get vt' i) = (uwarray_get vt i)
			cabbrev p4_1 = [vec_update_get_distinct assignment (word_to_nat nv') vt (word_to_nat i) (word_to_nat (lit_vnum l)) (lit_assignment l)
												p1 p2 p3]
			cabbrev p4 = hypjoin (uwarray_get vt' i) (uwarray_get vt i) by p4_1 vt'_eq end
			
			cabbrev a = (vec_get assignment (word_to_nat nv') vt' (word_to_nat i) p5_2)
			case a with
			| UN => hypjoin (check_var c' (vec_get vt' (to_nat i)) i) tt by a_eq end
			| TT =>
				% need: (cl_has c' (pos i)) = tt
				cabbrev p6 = hypjoin (cl_has c (pos i)) tt by p4 p5 a_eq end
				cabbrev p9 = [cl_subsume_implies_cl_has c c' p7 (pos i p8) p6]
				hypjoin (check_var c' a i) tt by p9 a_eq end
			| FF =>
				cabbrev p6 = hypjoin (cl_has c (neg i)) tt by p4 p5 a_eq end
				cabbrev p9 = [cl_subsume_implies_cl_has c c' p7 (neg i p8) p6]
				hypjoin (check_var c' a i) tt by p9 a_eq end
			end
		| tt =>
			cabbrev p3 = [eqword_eq (lit_vnum l) i q1]
			cabbrev a = (lit_assignment l)
			% p4: (uwarray_get vt' i) = a
			cabbrev p4_1 = [uwarray_set_get assignment nv' vt (lit_vnum l) (lit_assignment l) p2_1]
			cabbrev p4 = hypjoin (uwarray_get vt' i) a by p4_1 vt'_eq p3 end
			cabbrev p10_1 = hypjoin (cl_has (cons l c1) l) tt by [eq_lit_refl l] end
			cabbrev p10 = [cl_has_tt_append_front l (cons lit l c1) c2 p10_1]
			case a with
			| UN => contra
				transs
					hypjoin ff (is_assigned (lit_assignment l)) by a_eq end
					[lit_assignment_is_assigned l]
					clash tt ff
				end
				{ (check_var c' (vec_get vt' (to_nat i)) i) = tt }
			| TT =>
				% need: (pos i) = l
				cabbrev p6_1 = [lit_assignment_TT_pos_lit_vnum l a_eq]
				cabbrev p6 = hypjoin (pos i) l by p6_1 p3 end
				hypjoin (check_var c' (vec_get vt' (to_nat i)) i) tt by p4 a_eq p6 p10 end
			| FF =>
				cabbrev p6_1 = [lit_assignment_FF_neg_lit_vnum l a_eq]
				cabbrev p6 = hypjoin (neg i) l by p6_1 p3 end
				hypjoin (check_var c' (vec_get vt' (to_nat i)) i) tt by p4 a_eq p6 p10 end
			end
		end
	cabbrev p' = foralli(i:word)(r:{ (lt (to_nat i) (to_nat nv')) = tt }).
		cabbrev r' = hypjoin (ltword i nv') tt by r end
		[p i r']
	[forall_check_var_implies_cl_has_all_vars c' (word_to_nat nv') p5_1 vt' p']

Define _res_lem1 : Forall
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (dls:<uwarray word (inc_nv nv nv_ub)>)
  (vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (c1:clause)       % lits set below the current level
  (c2:clause)  % lits set at the current level
	(u1:{ (cl_valid nv c1) = tt })
  (u3:{ (cl_has_all_vars (append c2 c1) vt) = tt })
  (u5:{ (cl_set_at_prev_levels dl dls c1) = tt })
  (l:ulit)
  (r2:{ (ltword (uwarray_get dls (ulit_vnum l)) dl) = ff }) % l is set at current level
  (r3:{ (uwarray_get vt (ulit_vnum l)) = (ulit_assignment (unegated l)) })   % c has -l
  .{ (cl_has c2 (negated (to_lit l))) = tt }
  := foralli
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (dls:<uwarray word (inc_nv nv nv_ub)>)
  (vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (c1:clause)       % lits set below the current level
  (c2:clause)  % lits set at the current level
	(u1:{ (cl_valid nv c1) = tt })
  (u3:{ (cl_has_all_vars (append c2 c1) vt) = tt })
  (u5:{ (cl_set_at_prev_levels dl dls c1) = tt })
  (l:ulit)
  (r2:{ (ltword (uwarray_get dls (ulit_vnum l)) dl) = ff }) % l is set at current level
  (r3:{ (uwarray_get vt (ulit_vnum l)) = (ulit_assignment (unegated l)) })   % c has -l
	.
	cabbrev c = (append lit c2 c1)
	cabbrev l' = (to_lit l)
	cabbrev neg_l' = (negated l')
	cabbrev p1 = [unegated_ulit_assignment_eq_negated_lit_assignment l]
	cabbrev p2 = [lit_vnum_eq_to_lit_vnum_negated_lit l']
	cabbrev r2' = hypjoin (ltword (uwarray_get dls (lit_vnum neg_l')) dl) ff by r2 p2 end
	cabbrev r3' = hypjoin (uwarray_get vt (lit_vnum neg_l')) (lit_assignment neg_l') by r3 p1 p2 end
	
	% p3: (cl_has c neg_l') = tt
	cabbrev p3 = [cl_has_all_vars_lem3 c nv nv_ub vt neg_l' u3 r3']
	% p4: (cl_has c1 neg_l') = ff
	cabbrev p4 = [cl_set_at_prev_levels_lem1 nv nv_ub dl dls c1 neg_l' u1 u5 r2']
	
	cabbrev p5 = trans symm [cl_has_append_or c2 c1 neg_l'] p3
	cabbrev p6 = [or_def2ff (cl_has c2 neg_l')]
	hypjoin (cl_has c2 neg_l') tt by p4 p5 p6 end

Define _res_lem2_h : Forall
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (vt vt':<uwarray assignment (inc_nv nv nv_ub)>)
  (c:clause)
	(u1:{ (cl_valid nv c) = tt })
  (u4:{ (all_lits_are_assigned vt c) = tt })
  (l:ulit)
	(r1:{ (uwarray_get vt (ulit_vnum l)) = (ulit_assignment (unegated l)) })
  (vt'_eq:{ vt' = (uwarray_set vt (ulit_vnum l) UN) })
  .{ (all_lits_are_assigned vt' (cl_erase c (negated (to_lit l)))) = tt }
  := foralli
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (vt vt':<uwarray assignment (inc_nv nv nv_ub)>)
  (c:clause)
	(u1:{ (cl_valid nv c) = tt })
  (u4:{ (all_lits_are_assigned vt c) = tt })
  (l:ulit)
	(r1:{ (uwarray_get vt (ulit_vnum l)) = (ulit_assignment (unegated l)) })
  (vt'_eq:{ vt' = (uwarray_set vt (ulit_vnum l) UN) })
	.
	cabbrev nv' = (inc_nv nv nv_ub)
	cabbrev neg_l = (negated (to_lit l))
	cabbrev c' = (cl_erase c neg_l)
	cabbrev p2 = [uwarray_set_implies_ltword assignment nv' vt vt' (ulit_vnum l) UN vt'_eq]

	cabbrev p =
		foralli(x:lit)(r:{ (cl_has c' x) = tt }).
		% subgoal: (is_equal_assignment (uwarray_get vt' (lit_vnum x)) (lit_sign x)) = tt
		cabbrev u1' = [cl_erase_lem1 nv c u1 neg_l]
		cabbrev p1_1 = [cl_valid_implies_all_lit_valid nv x c' u1' r]
		cabbrev p1 = [lit_valid_implies_ltword_inc_nv nv nv_ub x p1_1]
		cabbrev a = (uwarray_get assignment nv' vt (lit_vnum x) p1)
		cabbrev a' = (uwarray_get assignment nv' vt' (lit_vnum x) p1)
		
		% r': (cl_has c x) = tt
		cabbrev r' = [cl_erase_has_implies_cl_has c neg_l x r]
		% p5: (is_equal_assignment (uwarray_get vt (lit_vnum x)) (lit_sign x)) = tt
		cabbrev p3 = [ulit_vnum_eq_to_lit_negated_lit_vnum l]
		cabbrev p5 = [all_lits_are_assigned_implies_any_is_equal_assignment nv nv_ub vt c u1 u4 x r']
		% p9: (is_equal_assignment (lit_assignment neg_l) (lit_sign neg_l)) = tt
		cabbrev p9 = [lit_assignment_is_equal_assignment neg_l]
		cabbrev p10 = [unegated_ulit_assignment_eq_negated_lit_assignment l]
		case (eq_lit neg_l x) by q2 _ with
		| ff =>
			case (eqword (ulit_vnum l) (lit_vnum x)) by q1 _ with
			| ff =>
				cabbrev p3 = symm [eqword_ff_neq (ulit_vnum l) (lit_vnum x) q1]
				cabbrev p4 = [uwarray_set_get_distinct assignment nv' vt (lit_vnum x) (ulit_vnum l) UN p1 p2 p3]
				hypjoin (is_equal_assignment (uwarray_get vt' (lit_vnum x)) (lit_sign x)) tt by p4 p5 vt'_eq end
			| tt =>	% contra
				% r1: (uwarray_get vt (ulit_vnum l)) = (ulit_assignment (unegated l))
				cabbrev p4 = [eqword_eq (ulit_vnum l) (lit_vnum x) q1]
				cabbrev p6 = hypjoin (lit_vnum neg_l) (lit_vnum x) by p3 p4 end
				cabbrev p7 = [eq_lit_ff_lit_vnum_eq_implies_lit_sign_neq neg_l x q2 p6]
				cabbrev p8 = [is_equal_assignment_lem1 a (lit_sign x) (lit_sign neg_l) p5 symm p7]
				cabbrev p11 = hypjoin (lit_assignment neg_l) a by r1 p4 p6 p10 end
				contra
				trans symm p8
				trans hypjoin (is_equal_assignment a (lit_sign neg_l)) tt by p11 p9 end
							clash tt ff
				{ (is_equal_assignment a' (lit_sign x)) = tt }
			end
			
		| tt =>	% contra
			cabbrev p4 = [eq_lit_eq neg_l x q2]
			cabbrev p6 = [cl_erase_has_ff c neg_l]
			cabbrev p7 = hypjoin (cl_has c' x) ff by p4 p6 end
			contra
			trans symm r
			trans p7
						clash ff tt
			{ (is_equal_assignment a' (lit_sign x)) = tt }
		end
	[forall_lits_are_assigned nv nv_ub vt' c' p]
	

Define _res_lem2 : Forall
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (dls:<uwarray word (inc_nv nv nv_ub)>)
  (vt vt':<uwarray assignment (inc_nv nv nv_ub)>)
  (c1:clause)       % lits set below the current level
  (c2:clause)  % lits set at the current level
	(u1:{ (cl_valid nv c1) = tt })
	(u2:{ (cl_valid nv c2) = tt })
  (u4:{ (all_lits_are_assigned vt (append c2 c1)) = tt })
  (u5:{ (cl_set_at_prev_levels dl dls c1) = tt })
  (l:ulit)
	(r1:{ (uwarray_get vt (ulit_vnum l)) = (ulit_assignment (unegated l)) })
  (r2:{ (ltword (uwarray_get dls (ulit_vnum l)) dl) = ff }) % l is set at current level
  (vt'_eq:{ vt' = (uwarray_set vt (ulit_vnum l) UN) })
  .{ (all_lits_are_assigned vt' (append (cl_erase c2 (negated (to_lit l))) c1)) = tt }
  := foralli
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (dls:<uwarray word (inc_nv nv nv_ub)>)
  (vt vt':<uwarray assignment (inc_nv nv nv_ub)>)
  (c1:clause)       % lits set below the current level
  (c2:clause)  % lits set at the current level
	(u1:{ (cl_valid nv c1) = tt })
	(u2:{ (cl_valid nv c2) = tt })
  (u4:{ (all_lits_are_assigned vt (append c2 c1)) = tt })
  (u5:{ (cl_set_at_prev_levels dl dls c1) = tt })
  (l:ulit)
	(r1:{ (uwarray_get vt (ulit_vnum l)) = (ulit_assignment (unegated l)) })
  (r2:{ (ltword (uwarray_get dls (ulit_vnum l)) dl) = ff }) % l is set at current level
  (vt'_eq:{ vt' = (uwarray_set vt (ulit_vnum l) UN) })
	.
	cabbrev neg_l = (negated (to_lit l))
	% goal: (all_lits_are_assigned vt' (append (cl_erase c2 neg_l) c1)) = tt
	% want: (append (cl_erase c2 neg_l) c1) = (cl_erase (append c2 c1) neg_l)
	cabbrev p2 = [lit_vnum_eq_to_lit_vnum_negated_lit (to_lit l)]
	cabbrev r2' = hypjoin (ltword (uwarray_get dls (lit_vnum neg_l)) dl) ff by r2 p2 end
	% p4: (cl_has c1 neg_l) = ff
	cabbrev p4 = [cl_set_at_prev_levels_lem1 nv nv_ub dl dls c1 neg_l u1 u5 r2']
	% p5: (cl_erase c1 neg_l) = c1
	cabbrev p5 = [cl_has_ff_implies_cl_erase_eq c1 neg_l p4]
	cabbrev p6 = [cl_erase_append c2 c1 neg_l]
	cabbrev p7 = hypjoin (cl_erase (append c2 c1) neg_l) (append (cl_erase c2 neg_l) c1) by p5 p6 end
	
	cabbrev p8_1 = [cl_valid_append nv c2 c1 u2 u1]
	cabbrev p8 = [_res_lem2_h nv nv_ub vt vt' (append lit c2 c1) p8_1 u4 l r1 vt'_eq]
	trans cong (all_lits_are_assigned vt' *) symm p7
				p8

Define _res_lem4 : Forall
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (dls:<uwarray word (inc_nv nv nv_ub)>)
  (vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (c1:clause)       % lits set below the current level
  (c2:clause)  % lits set at the current level
	(u1:{ (cl_valid nv c1) = tt })
  (u5:{ (cl_set_at_prev_levels dl dls c1) = tt })
  (l:lit)
  (r2:{ (ltword (uwarray_get dls (lit_vnum l)) dl) = ff }) % l is set at current level
  .{ (cl_erase (append c2 c1) l) = (append (cl_erase c2 l) c1) }
  := foralli
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (dls:<uwarray word (inc_nv nv nv_ub)>)
  (vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (c1:clause)       % lits set below the current level
  (c2:clause)  % lits set at the current level
	(u1:{ (cl_valid nv c1) = tt })
  (u5:{ (cl_set_at_prev_levels dl dls c1) = tt })
  (l:lit)
  (r2:{ (ltword (uwarray_get dls (lit_vnum l)) dl) = ff }) % l is set at current level
	.
	% p4: (cl_has c1 l) = ff
	cabbrev p4 = [cl_set_at_prev_levels_lem1 nv nv_ub dl dls c1 l u1 u5 r2]
	cabbrev p5 = [cl_has_ff_implies_cl_erase_eq c1 l p4]
	cabbrev p6 = [cl_erase_append c2 c1 l]
	hypjoin (cl_erase (append c2 c1) l) (append (cl_erase c2 l) c1) by p6 p5 end

Define _res_lem3 : Forall
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (dls:<uwarray word (inc_nv nv nv_ub)>)
  (vt vt':<uwarray assignment (inc_nv nv nv_ub)>)
  (c1:clause)       % lits set below the current level
  (c2:clause)  % lits set at the current level
	(u1:{ (cl_valid nv c1) = tt })
  (u3:{ (cl_has_all_vars (append c2 c1) vt) = tt })
  (u5:{ (cl_set_at_prev_levels dl dls c1) = tt })
  (l:ulit)
	(r1:{ (uwarray_get vt (ulit_vnum l)) = (ulit_assignment (unegated l)) })
  (r2:{ (ltword (uwarray_get dls (ulit_vnum l)) dl) = ff }) % l is set at current level
  (vt'_eq:{ vt' = (uwarray_set vt (ulit_vnum l) UN) })
  .{ (cl_has_all_vars (append (cl_erase c2 (negated (to_lit l))) c1) vt') = tt }
  := foralli
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (dls:<uwarray word (inc_nv nv nv_ub)>)
  (vt vt':<uwarray assignment (inc_nv nv nv_ub)>)
  (c1:clause)       % lits set below the current level
  (c2:clause)  % lits set at the current level
	(u1:{ (cl_valid nv c1) = tt })
  (u3:{ (cl_has_all_vars (append c2 c1) vt) = tt })
  (u5:{ (cl_set_at_prev_levels dl dls c1) = tt })
  (l:ulit)
	(r1:{ (uwarray_get vt (ulit_vnum l)) = (ulit_assignment (unegated l)) })
  (r2:{ (ltword (uwarray_get dls (ulit_vnum l)) dl) = ff }) % l is set at current level
  (vt'_eq:{ vt' = (uwarray_set vt (ulit_vnum l) UN) })
	.
	cabbrev nv' = (inc_nv nv nv_ub)
	cabbrev neg_l = (negated (to_lit l))
	cabbrev c = (append lit c2 c1)
	cabbrev c' = (cl_erase c neg_l)
	% subgoal: (cl_erase c neg_l) = (append (cl_erase c2 neg_l) c1)
	cabbrev p1 = [ulit_vnum_eq_to_lit_negated_lit_vnum l]
	cabbrev r2' = hypjoin (ltword (uwarray_get dls (lit_vnum neg_l)) dl) ff by r2 p1 end
	cabbrev g1 = [_res_lem4 nv nv_ub dl dls vt c1 c2 u1 u5 neg_l r2']
	
	% subgoal: Forall(i:word)...{ (check_var c' (uwarray_get vt' i) i) = tt }
	cabbrev g2 =
		cabbrev p4 = [uwarray_set_implies_ltword assignment nv' vt vt' (ulit_vnum l) UN vt'_eq]
		foralli(i:word)(u2:{ (ltword i nv') = tt}).
		case (eqword i (ulit_vnum l)) by q1 _ with
		| ff =>
			cabbrev p2 = [eqword_neq i (ulit_vnum l) q1]	% i != (ulit_vnum l)
			cabbrev p5_1 = [uwarray_set_get_distinct assignment nv' vt i (ulit_vnum l) UN u2 p4 p2]
			cabbrev p5 = hypjoin (uwarray_get vt i) (uwarray_get vt' i) by p5_1 vt'_eq end
			
			cabbrev p3 = [cl_has_all_vars_elim c nv nv_ub vt u3 i u2]
			cabbrev p6 = [ltword_inc_nv_implies_word_msb_ff nv nv_ub i u2]
			cabbrev a = (uwarray_get assignment nv' vt i u2)
			case a by q2 _ with
			| UN => hypjoin (check_var c' (uwarray_get vt' i) i) tt by q2 p5 end
			| TT =>
				cabbrev l' = (pos i p6)
				% have: (cl_has c l') = tt
				cabbrev p8 = hypjoin (cl_has c l') tt by p3 q2 end
				
				% need: (eq_lit (pos i) (neg_l)) = ff
				cabbrev p7_1 = [pos_lit_vnum i p6]	% (lit_vnum l') = i
				cabbrev p7_2 = transs p7_1 p2 p1 end
				cabbrev p7 = [distinct_lit_vnum_implies_eq_lit_ff l' neg_l p7_2]
				
				cabbrev p9 = [cl_has_implies_erase_lit_has_lit c l' neg_l p8 p7]
				hypjoin (check_var c' (uwarray_get vt' i) i) tt by q2 p5 p9 end 
			| FF =>
				cabbrev l' = (neg i p6)
				% have: (cl_has c l') = tt
				cabbrev p8 = hypjoin (cl_has c l') tt by p3 q2 end
				
				% need: (eq_lit (neg i) (neg_l)) = ff
				cabbrev p7_1 = [neg_lit_vnum i p6]	% (lit_vnum l') = i
				cabbrev p7_2 = transs p7_1 p2 p1 end
				cabbrev p7 = [distinct_lit_vnum_implies_eq_lit_ff l' neg_l p7_2]
				
				cabbrev p9 = [cl_has_implies_erase_lit_has_lit c l' neg_l p8 p7]
				hypjoin (check_var c' (uwarray_get vt' i) i) tt by q2 p5 p9 end 
			end
		| tt =>
			cabbrev p2 = [eqword_eq i (ulit_vnum l) q1]	% i = (ulit_vnum l)
			cabbrev p3_1 = [uwarray_set_get assignment nv' vt (ulit_vnum l) UN p4]
			cabbrev p3 = hypjoin (uwarray_get vt' i) UN by p2 p3_1 vt'_eq end
			hypjoin (check_var c' (uwarray_get vt' i) i) tt by p3 end 
		end

	cabbrev g3 = [cl_has_all_vars_intro c' nv nv_ub vt' g2]
	hypjoin (cl_has_all_vars (append (cl_erase c2 neg_l) c1) vt') tt by g1 g3 end
	

%=============================================================================
% ResState
%=============================================================================

% ResState: intermediate states of single resolution step
Inductive ResState : Fun(nv nv':word)(dl:word)(dls:<uwarray word nv'>)(d1 d2:clause).type :=
  res_state : Fun(spec nv nv':word)
                 (spec dl:word)
                 (spec dls:<uwarray word nv'>)
                 (#unique vt:<uwarray assignment nv'>)
                 (spec d1:clause)
                 (spec d2:clause)
                 (c1:clause)       % lits set below the current level
                 (spec c2:clause)  % lits set at the current level
                 (c2l:nat)
                 (p1:{ (cl_subsume d1 (append c2 c1)) = tt })
                 (p2:{ (cl_subsume d2 (append c2 c1)) = tt })
                 (u1:{ c2l = (length c2) })
                 (u2:{ (all_lits_are_assigned vt (append c2 c1)) = tt })
                 (u3:{ (cl_has_all_vars (append c2 c1) vt) = tt })
                 (u4:{ (cl_unique c2) = tt })
                 (u5:{ (cl_set_at_prev_levels dl dls c1) = tt })
                 (u6:{ (cl_valid nv c1) = tt })
                 (u7:{ (cl_valid nv c2) = tt })
                .#unique <ResState nv nv' dl dls d1 d2>


%=============================================================================
% init_res function
%=============================================================================

Define _init_res_lem1 := cl_subsume_init_res_lem1

Define init_res_h := fun init_res_h
  (spec nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (!#unique_owned dls:<uwarray word (inc_nv nv nv_ub)>)
  (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (c1:clause)
  (spec c2:clause)
  (c2l:nat)
  (u1:{ c2l = (length c2) })
  (u2:{ (all_lits_are_assigned vt (append c2 c1)) = tt })
  (u3:{ (cl_has_all_vars (append c2 c1) vt) = tt })
  (u4:{ (cl_unique c2) = tt })
  (u5:{ (cl_set_at_prev_levels dl dls c1) = tt })
  (u6:{ (cl_valid nv c1) = tt })
  (u7:{ (cl_valid nv c2) = tt })
  (spec n:word)(!#unique_owned la:<uwarray ulit n>)
  (spec c:clause)
  (i:word)
  (r1:{ (array_in_bounds nv (vec_nth_tail la (to_nat i))) = tt })
  (r2:{ (cl_subsume c (append (append c2 c1) (to_cl (vec_nth_tail la (to_nat i))))) = tt })
  : #unique <ResState nv (inc_nv nv nv_ub) dl dls c (nil lit)>.
  abbrev nv' = (inc_nv nv nv_ub) in
  cabbrev p1 = [nth_tail_in_bounds_implies_ltword nv n la i r1]
  let x = (uwarray_get ulit n la i p1) in
  match (eqword x ulit_null) by q1 _ with
    ff =>
      let v = (ulit_vnum x) in
      abbrev p2_1 = [nth_tail_in_bounds_leword_nth2 nv n la i x v r1 x_eq v_eq] in
      abbrev p2 = [leword_nv_implies_ltword_inc_nv nv nv_ub v p2_1] in
      let vti = (inspect_unique <uwarray assignment (inc_nv nv nv_ub)> vt) in
      let a = (uwarray_get assignment nv' vti v p2) in
      match (not (is_assigned a)) by q2 _ with
        ff => % the same var occurred twice (not possible)
          % to elimitate this check, we need an invariant that
          % every clause (after init) has no tautology and no repetition.
          abort <ResState nv nv' dl dls c (nil lit)>
      | tt =>
      do
      (consume_unique_owned <uwarray assignment (inc_nv nv nv_ub)> vti)
      let vt' = (uwarray_set assignment nv' vt v (ulit_assignment x) p2) in
      let v_dl = (uwarray_get word nv' dls v p2) in

      abbrev i_ok = [ltword_implies_ltword_word_max i n p1] in
      let i' = (word_inc_safe i i_ok) in

      abbrev q2' = [not_tt (is_assigned a) q2] in
			cabbrev q2'' = hypjoin (is_assigned (uwarray_get vt (lit_vnum (to_lit x)))) ff by q2' a_eq v_eq vti_eq end
      abbrev p3_1 = [is_assigned_ff a q2'] in  % a = UN
      abbrev p3 = hypjoin (uwarray_get vt (lit_vnum (to_lit x))) UN by p3_1 v_eq a_eq vti_eq end in
      abbrev p4 = hypjoin vt' (uwarray_set vt (lit_vnum (to_lit x)) (lit_assignment (to_lit x))) by v_eq vt'_eq end in
      abbrev r1' = [nth_tail_in_bounds_the_rest nv n la i i' x r1 i'_eq x_eq q1] in
			cabbrev x_val_2 = hypjoin (eq_ulit (vec_get la (to_nat i)) ulit_null) ff by q1 x_eq end
      abbrev x_val_1 = [vec_nth_tail_array_in_bounds_implies_lit_valid_nth nv (word_to_nat n) la (word_to_nat i) r1 x_val_2] in
      abbrev x_val = hypjoin (lit_valid nv (to_lit x)) tt by x_val_1 x_eq end in
      
      abbrev d1 = (append lit c2 c1) in
      
      match (ltword v_dl dl) by q3 _ with
        ff => % current level
          abbrev c2' = (cons lit (to_lit x) c2) in
          let c2l' = (S c2l) in
          abbrev u1' = hypjoin c2l' (length c2') by c2l'_eq u1 end in
					abbrev p5_1 = [cl_valid_append nv c2 c1 u7 u6] in
          abbrev p5 = [all_lits_are_assigned_lem1 nv nv_ub vt vt' (to_lit x) q2'' p4 (append lit c2 c1) u2 p5_1] in
          abbrev u2' = hypjoin (all_lits_are_assigned vt' (append c2' c1)) tt by vt'_eq v_eq u2 p5 end in
          abbrev p6 = [cl_has_all_vars_add nv nv_ub vt vt' (append lit c2 c1) (to_lit x) u3 p4] in
          abbrev u3' = hypjoin (cl_has_all_vars (append c2' c1) vt') tt by p6 end in
          
          abbrev u4_1 = [all_lits_are_assigned_lem2 nv nv_ub vt (append lit c2 c1) (to_lit x) p5_1 u2 p3] in
          abbrev u4_2 = [member_or_append lit eq_lit eq_lit_total (to_lit x) c2 c1] in
          abbrev u4_3 = hypjoin (or (cl_has c2 (to_lit x)) (cl_has c1 (to_lit x))) ff by u4_1 u4_2 end in
          abbrev u4_4 = [or_ff (cl_has c2 (to_lit x)) (cl_has c1 (to_lit x)) u4_3] in
          abbrev u4' = hypjoin (cl_unique (cons (to_lit x) c2)) tt by u4 u4_4 end in
          abbrev u7' = hypjoin (cl_valid nv (cons (to_lit x) c2)) tt by u7 x_val end in
          
          abbrev r2_1 = [cl_subsume_append_cons5 c2 c1 (to_lit x)] in
          abbrev r2_2 = [cl_has_append_cons3 c2 c1 (to_lit x)] in
          abbrev d1' = (append lit (cons lit (to_lit x) c2) c1) in
          abbrev x_eq' = hypjoin x (vec_get la (word_to_nat i)) by x_eq end in
          abbrev p7_1 = [to_cl_nth_tail_eq_cons_to_cl (word_to_nat n) la (word_to_nat i) x x_eq' q1] in
          abbrev p7 = trans symm cong (cl_subsume c (append (append c2 c1) *)) p7_1
                            r2 in
          abbrev p8_1 = [word_inc_safe_word_to_nat i i_ok] in
          abbrev p8 = hypjoin (to_nat i') (S (to_nat i)) by i'_eq p8_1 end in
          abbrev r2'_1 = [_init_res_lem1 c d1 d1' (word_to_nat n) la (word_to_nat i) (to_lit x) p7 r2_1 r2_2] in
          abbrev r2' = trans cong (cl_subsume c (append (append (cons lit (to_lit x) c2) c1) (to_cl (vec_nth_tail la *)))) p8
                            r2'_1 in
      
          (init_res_h nv nv_ub dl dls vt' c1 c2' c2l' u1' u2' u3' u4' u5 u6 u7' n la c i' r1' r2')
      | tt => % previous level
          let c1' = (cons lit (to_lit x) c1) in
          abbrev p5 = [all_lits_are_assigned_lem1' nv nv_ub vt vt' c1 c2 (to_lit x) u2 x_val u6 u7 q2'' p4] in
          abbrev u2' = hypjoin (all_lits_are_assigned vt' (append c2 c1')) tt by vt'_eq v_eq c1'_eq p5 end in
          abbrev p6 = [cl_has_all_vars_add' nv nv_ub vt vt' c1 c2 (to_lit x) u3 p4] in
          abbrev u3' = hypjoin (cl_has_all_vars (append c2 c1') vt') tt by c1'_eq p6 end in
          
          abbrev u5_1 = hypjoin v_dl (uwarray_get dls (lit_vnum (to_lit x))) by v_dl_eq v_eq end in
          %abbrev u5_2 = hypjoin (ltword v_dl dl) tt by q3 v_eq v_dl_eq end in
          abbrev u5' = hypjoin (cl_set_at_prev_levels dl dls c1') tt by u5 u5_1 c1'_eq q3 end in
          abbrev u6' = hypjoin (cl_valid nv c1') tt by u6 x_val c1'_eq end in
          
          abbrev r2_1 = [cl_subsume_append_cons4 c2 c1 (to_lit x)] in
          abbrev r2_2 = [cl_has_append_cons2 c2 c1 (to_lit x)] in
          abbrev d1' = (append lit c2 (cons lit (to_lit x) c1)) in
          abbrev x_eq' = hypjoin x (vec_get la (word_to_nat i)) by x_eq end in
          abbrev p7_1 = [to_cl_nth_tail_eq_cons_to_cl (word_to_nat n) la (word_to_nat i) x x_eq' q1] in
          abbrev p7 = trans symm cong (cl_subsume c (append (append c2 c1) *)) p7_1
                            r2 in
          abbrev p8_1 = [word_inc_safe_word_to_nat i i_ok] in
          abbrev p8 = hypjoin (to_nat i') (S (to_nat i)) by i'_eq p8_1 end in
          abbrev r2'_1 = [_init_res_lem1 c d1 d1' (word_to_nat n) la (word_to_nat i) (to_lit x) p7 r2_1 r2_2] in
          abbrev r2' = trans cong (cl_subsume c (append (append c2 c1') (to_cl (vec_nth_tail la *)))) p8
                       trans cong (cl_subsume c (append (append c2 *) (to_cl (vec_nth_tail la (S (to_nat i)))))) c1'_eq
                             r2'_1 in
          
          (init_res_h nv nv_ub dl dls vt' c1' c2 c2l u1 u2' u3' u4 u5' u6' u7 n la c i' r1' r2')
      end
      end % do
      end % (not (is_assigned a))

  | tt =>
      abbrev x_eq' = hypjoin x (vec_get la (word_to_nat i)) by x_eq end in
      abbrev p2 = [to_cl_nth_tail_eq_nil (word_to_nat n) la (word_to_nat i) x x_eq' q1] in
      abbrev p3 = [append_nil lit (append lit c2 c1)] in
      abbrev s1 = hypjoin (cl_subsume c (append c2 c1)) tt by p2 p3 r2 end in
      abbrev s2 = join (cl_subsume nil (append c2 c1)) tt in
      (res_state nv (inc_nv nv nv_ub) dl dls vt c (nil lit) c1 c2 c2l s1 s2 u1 u2 u3 u4 u5 u6 u7)
  end

Define init_res :=
  fun(spec nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
     (dl:word)
     (!#unique_owned dls:<uwarray word (inc_nv nv nv_ub)>)
     (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
     (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
     (spec n:word)(!#unique_owned l:<uwarray ulit n>) % conflicting clause to split
     (u:{ (array_in_bounds nv l) = tt })
     (spec c:clause)(c_eq:{ c = (to_cl l) })
    : #unique <ResState nv (inc_nv nv nv_ub) dl dls c (nil lit)>.
  abbrev u1 = join Z (length nil) in
  abbrev u2 = join (all_lits_are_assigned vt (append nil nil)) tt in
  abbrev u3_1 = [cl_has_all_vars_empty nv nv_ub vt vt_eq] in
  abbrev u3 = hypjoin (cl_has_all_vars (append nil nil) vt) tt by u3_1 end in
  abbrev u4 = join (cl_unique nil) tt in
  abbrev u5 = join (cl_set_at_prev_levels dl dls nil) tt in
  abbrev u6 = join (cl_valid nv nil) tt in
  abbrev r1 = hypjoin (array_in_bounds nv (vec_nth_tail l (to_nat 0x0))) tt by u end in
  abbrev r2_1 = [cl_subsume_refl c] in
  abbrev r2 = hypjoin (cl_subsume c (append (append nil nil) (to_cl (vec_nth_tail l (to_nat 0x0))))) tt by c_eq r2_1 end in
  (init_res_h nv nv_ub dl dls vt (nil lit) (nil lit) Z u1 u2 u3 u4 u5 u6 u6 n l c 0x0 r1 r2)


%=============================================================================
% append_filter: append lits in an array-clause to a list-clause
%                except for the specified literal
%=============================================================================

Define append_filter_lem1 := cl_subsume_append_filter_lem1
Define append_filter_lem2 := cl_subsume_append_filter_lem2

Define append_filter_h := fun append_filter_h
  (spec nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (!#unique_owned dls:<uwarray word (inc_nv nv nv_ub)>)
  (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (c1:clause)       % lits set below the current level
  (spec c2:clause)  % lits set at the current level
  (c2l:nat)
  (u1:{ c2l = (length c2) })
  (u2:{ (all_lits_are_assigned vt (append c2 c1)) = tt })
  (u3:{ (cl_has_all_vars (append c2 c1) vt) = tt })
  (u4:{ (cl_unique c2) = tt })
  (u5:{ (cl_set_at_prev_levels dl dls c1) = tt })
  (u6:{ (cl_valid nv c1) = tt })
  (u7:{ (cl_valid nv c2) = tt })
  (spec cc':clause)  % supposed to be (cl_erase cc (negated l))
  (spec c':clause)  % supposed to be (cl_erase (to_cl ac) l)
  (spec n:word)(!#unique_owned ac:<uwarray ulit n>)
  (l:ulit)
  (i:word)
  (r1:{ (array_in_bounds nv (vec_nth_tail ac (to_nat i))) = tt })
  (r2:{ (cl_subsume cc' (append c2 c1)) = tt }) % means it keeps previous lits
  (r3:{ (cl_subsume c' (append (append c2 c1) (cl_erase (to_cl (vec_nth_tail ac (to_nat i))) (to_lit l)))) = tt })
  : #unique <ResState nv (inc_nv nv nv_ub) dl dls cc' c'>.
  abbrev nv' = (inc_nv nv nv_ub) in
  cabbrev p1 = [nth_tail_in_bounds_implies_ltword nv n ac i r1]
  let x = (uwarray_get ulit n ac i p1) in
  match (eq_ulit x ulit_null) by q1 _ with
    ff => % x is not null => add x into the conflict clause
      let v = (ulit_vnum x) in
      let vti = (inspect_unique <uwarray assignment (inc_nv nv nv_ub)> vt) in
      abbrev p2_1 = [nth_tail_in_bounds_leword_nth2 nv n ac i x v r1 x_eq v_eq] in
      abbrev p2 = [leword_nv_implies_ltword_inc_nv nv nv_ub v p2_1] in
      let a = (uwarray_get assignment nv' vti v p2) in
      abbrev a_eq = hypjoin a (uwarray_get vt v) by a_eq vti_eq end in
      % [assert] no x and (negated x) are in the same clause
      match (is_compat_assignment a (ulit_sign x)) by q5 _ with
        ff => % negated lit is alreay assigned (not possible) => it means we got a tautalogy
          % to elimitate this check, we need an invariant that
          % every lits other than l are falsified in both cc and ac
          abort <ResState nv nv' dl dls cc' c'>
      | tt =>

      abbrev i_ok = [ltword_implies_ltword_word_max i n p1] in
      let i' = (word_inc_safe i i_ok) in
      abbrev d1 = (append lit c2 c1) in
      abbrev r1' = [nth_tail_in_bounds_the_rest nv n ac i i' x r1 i'_eq x_eq q1] in
      
      do
      (consume_unique_owned <uwarray assignment (inc_nv nv nv_ub)> vti)
      match (eq_ulit l x) by q4 _ with
        ff =>
          match (not (is_assigned a)) by q2 _ with
            ff => % x is alreay assigned
              % want: (cl_has d1 (to_lit x)) = tt
              abbrev q2'_1 = hypjoin (not (not (is_assigned a))) tt by q2 end in
              abbrev q2'_2 = [not_not (is_assigned a)] in
              abbrev q2' = hypjoin (is_assigned a) tt by q2'_1 q2'_2 end in

              abbrev x_eq' = hypjoin x (vec_get ac (to_nat i)) by x_eq end in
              abbrev p7_1 = [to_cl_nth_tail_eq_cons_to_cl (word_to_nat n) ac (word_to_nat i) x x_eq' q1] in
              abbrev p7 = trans symm cong (cl_subsume c' (append d1 (cl_erase * (to_lit l)))) p7_1
                                r3 in
              abbrev p8_1 = [word_inc_safe_word_to_nat i i_ok] in
              abbrev p8 = hypjoin (to_nat i') (S (to_nat i)) by i'_eq p8_1 end in
              abbrev q5'_1 = [ulit_sign_to_lit_sign x] in
              abbrev q5' = hypjoin (is_compat_assignment a (lit_sign (to_lit x))) tt by q5 q5'_1 end in
              abbrev p9_1 = [is_compat_assignment_lem1 a (to_lit x) q2' q5'] in
              abbrev p9 = hypjoin (uwarray_get vt (lit_vnum (to_lit x))) (lit_assignment (to_lit x)) by v_eq a_eq p9_1 end in
              abbrev r3'_1_1 = [cl_subsume_refl d1] in
              abbrev r3'_1_2 = [cl_has_all_vars_lem3 d1 nv nv_ub vt (to_lit x) u3 p9] in
              abbrev r3'_1 = [append_filter_lem1 c' d1 d1 (word_to_nat n) ac (word_to_nat i) (to_lit l) (to_lit x) p7 r3'_1_1 r3'_1_2] in
              abbrev r3' = trans cong (cl_subsume c' (append d1 (cl_erase (to_cl (vec_nth_tail ac *)) (to_lit l)))) p8
                                r3'_1 in
              (append_filter_h nv nv_ub dl dls vt c1 c2 c2l u1 u2 u3 u4 u5 u6 u7 cc' c' n ac l i' r1' r2 r3')
              
          | tt => % x is not assigned yet
              let vt' = (uwarray_set assignment nv' vt v (ulit_assignment x) p2) in
              let v_dl = (uwarray_get word nv' dls v p2) in

              abbrev q2' = [not_tt (is_assigned a) q2] in
							cabbrev q2'' = hypjoin (is_assigned (uwarray_get vt (lit_vnum (to_lit x)))) ff by q2' a_eq vti_eq v_eq end
              abbrev p3_1 = [is_assigned_ff a q2'] in  % a = UN
              abbrev p3 = hypjoin (uwarray_get vt (lit_vnum (to_lit x))) UN by a_eq p3_1 v_eq end in
              abbrev p4 = hypjoin vt' (uwarray_set vt (lit_vnum (to_lit x)) (lit_assignment (to_lit x))) by v_eq vt'_eq end in
							cabbrev x_val_2 = hypjoin (eq_ulit (vec_get ac (to_nat i)) ulit_null) ff by q1 x_eq end
              abbrev x_val_1 = [vec_nth_tail_array_in_bounds_implies_lit_valid_nth nv (word_to_nat n) ac (word_to_nat i) r1 x_val_2] in
              abbrev x_val = hypjoin (lit_valid nv (to_lit x)) tt by x_val_1 x_eq end in
              
              match (ltword v_dl dl) by q3 _ with
                ff => % current level
                  abbrev c2' = (cons lit (to_lit x) c2) in
                  let c2l' = (S c2l) in
                  abbrev u1' = hypjoin c2l' (length c2') by c2l'_eq u1 end in
									abbrev p5_1 = [cl_valid_append nv c2 c1 u7 u6] in
                  abbrev p5 = [all_lits_are_assigned_lem1 nv nv_ub vt vt' (to_lit x) q2'' p4 (append lit c2 c1) u2 p5_1] in
                  abbrev u2' = hypjoin (all_lits_are_assigned vt' (append c2' c1)) tt by vt'_eq v_eq p5 end in
                  abbrev p6 = [cl_has_all_vars_add nv nv_ub vt vt' (append lit c2 c1) (to_lit x) u3 p4] in
                  abbrev u3' = hypjoin (cl_has_all_vars (append c2' c1) vt') tt by p6 end in
                  
                  abbrev u4_1 = [all_lits_are_assigned_lem2 nv nv_ub vt (append lit c2 c1) (to_lit x) p5_1 u2 p3] in
                  abbrev u4_2 = [member_or_append lit eq_lit eq_lit_total (to_lit x) c2 c1] in
                  abbrev u4_3 = hypjoin (or (cl_has c2 (to_lit x)) (cl_has c1 (to_lit x))) ff by u4_1 u4_2 end in
                  abbrev u4_4 = [or_ff (cl_has c2 (to_lit x)) (cl_has c1 (to_lit x)) u4_3] in
                  abbrev u4' = hypjoin (cl_unique (cons (to_lit x) c2)) tt by u4 u4_4 end in
                  abbrev u7' = hypjoin (cl_valid nv (cons (to_lit x) c2)) tt by u7 x_val end in
                  
                  abbrev r2' = [cl_subsume_append_implies_cons2 cc' c2 c1 (to_lit x) r2] in
                  
                  abbrev r3_1 = [cl_subsume_append_cons5 c2 c1 (to_lit x)] in
                  abbrev r3_2 = [cl_has_append_cons3 c2 c1 (to_lit x)] in
                  abbrev d1' = (append lit (cons lit (to_lit x) c2) c1) in
                  abbrev p1'_1 = hypjoin (lt (word_to_nat i) (word_to_nat n)) tt by p1 end in
                  abbrev p1' = [lt_implies_le (word_to_nat i) (word_to_nat n) p1'_1] in
                  abbrev x_eq' = hypjoin x (vec_get ac (word_to_nat i)) by x_eq end in
                  abbrev p7_1 = [to_cl_nth_tail_eq_cons_to_cl (word_to_nat n) ac (word_to_nat i) x x_eq' q1] in
                  abbrev p7 = trans symm cong (cl_subsume c' (append d1 (cl_erase * (to_lit l)))) p7_1
                                    r3 in
                  abbrev p8_1 = [word_inc_safe_word_to_nat i i_ok] in
                  abbrev p8 = hypjoin (to_nat i') (S (to_nat i)) by i'_eq p8_1 end in
                  abbrev r3'_1 = [append_filter_lem1 c' d1 d1' (word_to_nat n) ac (word_to_nat i) (to_lit l) (to_lit x) p7 r3_1 r3_2] in
                  abbrev r3' = trans cong (cl_subsume c' (append (append (cons lit (to_lit x) c2) c1) (cl_erase (to_cl (vec_nth_tail ac *)) (to_lit l)))) p8
                                    r3'_1 in
              
                  (append_filter_h nv nv_ub dl dls vt' c1 c2' c2l' u1' u2' u3' u4' u5 u6 u7' cc' c' n ac l i' r1' r2' r3')
              | tt => % previous level
                  let c1' = (cons lit (to_lit x) c1) in
									abbrev p5 = [all_lits_are_assigned_lem1' nv nv_ub vt vt' c1 c2 (to_lit x) u2 x_val u6 u7 q2'' p4] in
                  abbrev u2' = hypjoin (all_lits_are_assigned vt' (append c2 c1')) tt by vt'_eq v_eq c1'_eq p5 end in
                  abbrev p6 = [cl_has_all_vars_add' nv nv_ub vt vt' c1 c2 (to_lit x) u3 p4] in
                  abbrev u3' = hypjoin (cl_has_all_vars (append c2 c1') vt') tt by c1'_eq p6 end in
                  
                  abbrev u5_1 = hypjoin v_dl (uwarray_get dls (lit_vnum (to_lit x))) by v_dl_eq v_eq end in
                  abbrev u5' = hypjoin (cl_set_at_prev_levels dl dls c1') tt by u5 u5_1 c1'_eq q3 end in
                  abbrev u6' = hypjoin (cl_valid nv c1') tt by u6 x_val c1'_eq end in
                  
                  abbrev r2' = trans cong (cl_subsume cc' (append c2 *)) c1'_eq
                                     [cl_subsume_append_implies_cons1 cc' c2 c1 (to_lit x) r2] in

                  abbrev r3_1 = [cl_subsume_append_cons4 c2 c1 (to_lit x)] in
                  abbrev r3_2 = [cl_has_append_cons2 c2 c1 (to_lit x)] in
                  abbrev d1' = (append lit c2 (cons lit (to_lit x) c1)) in
                  abbrev x_eq' = hypjoin x (vec_get ac (word_to_nat i)) by x_eq end in
                  abbrev p7_1 = [to_cl_nth_tail_eq_cons_to_cl (word_to_nat n) ac (word_to_nat i) x x_eq' q1] in
                  abbrev p7 = trans symm cong (cl_subsume c' (append d1 (cl_erase * (to_lit l)))) p7_1
                                    r3 in
                  abbrev p8_1 = [word_inc_safe_word_to_nat i i_ok] in
                  abbrev p8 = hypjoin (to_nat i') (S (to_nat i)) by i'_eq p8_1 end in
                  abbrev r3'_1 = [append_filter_lem1 c' d1 d1' (word_to_nat n) ac (word_to_nat i) (to_lit l) (to_lit x) p7 r3_1 r3_2] in
                  abbrev r3' = trans cong (cl_subsume c' (append (append c2 c1') (cl_erase (to_cl (vec_nth_tail ac *)) (to_lit l)))) p8
                               trans cong (cl_subsume c' (append (append c2 *) (cl_erase (to_cl (vec_nth_tail ac (S (to_nat i)))) (to_lit l)))) c1'_eq
                                    r3'_1 in

                  (append_filter_h nv nv_ub dl dls vt' c1' c2 c2l u1 u2' u3' u4 u5' u6' u7 cc' c' n ac l i' r1' r2' r3')
              end % (ltword v_dl dl)
          end % (not (is_assigned a))

      | tt => % don't append l as if l was erased from ac
          abbrev q4' = [eq_ulit_eq l x q4] in
          abbrev l_eq' = hypjoin l (vec_get ac (word_to_nat i)) by x_eq q4' end in
          abbrev q1' = hypjoin (eq_ulit l ulit_null) ff by x_eq l_eq' q1 end in
          abbrev p7_1 = [to_cl_nth_tail_eq_cons_to_cl (word_to_nat n) ac (word_to_nat i) l l_eq' q1'] in
          abbrev p7 = trans symm cong (cl_subsume c' (append d1 (cl_erase * (to_lit l)))) p7_1
                            r3 in
          abbrev p8_1 = [word_inc_safe_word_to_nat i i_ok] in
          abbrev p8 = hypjoin (to_nat i') (S (to_nat i)) by i'_eq p8_1 end in
          abbrev r3'_1 = [append_filter_lem2 c' d1 (word_to_nat n) ac (word_to_nat i) (to_lit l) p7] in
          abbrev r3' = trans cong (cl_subsume c' (append d1 (cl_erase (to_cl (vec_nth_tail ac *)) (to_lit l)))) p8
                            r3'_1 in
          (append_filter_h nv nv_ub dl dls vt c1 c2 c2l u1 u2 u3 u4 u5 u6 u7 cc' c' n ac l i' r1' r2 r3')
      end % eq_ulit
      end % do
      end % is_compat_assignment
  
  | tt => % done
      abbrev x_eq' = hypjoin x (vec_get ac (word_to_nat i)) by x_eq end in
      abbrev p2_1 = [to_cl_nth_tail_eq_nil (word_to_nat n) ac (word_to_nat i) x x_eq' q1] in
      abbrev p2 = hypjoin (cl_erase (to_cl (vec_nth_tail ac (to_nat i))) (to_lit l)) nil by p2_1 end in
      abbrev p3 = [append_nil lit (append lit c2 c1)] in
      abbrev r3' = hypjoin (cl_subsume c' (append c2 c1)) tt by p2 p3 r3 end in
      (res_state nv (inc_nv nv nv_ub) dl dls vt cc' c' c1 c2 c2l r2 r3' u1 u2 u3 u4 u5 u6 u7)
  end

Define append_filter := fun
  (spec nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (!#unique_owned dls:<uwarray word (inc_nv nv nv_ub)>)
  (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (c1:clause)       % lits set below the current level
  (spec c2:clause)  % lits set at the current level
  (c2l:nat)
  (u1:{ c2l = (length c2) })
  (u2:{ (all_lits_are_assigned vt (append c2 c1)) = tt })
  (u3:{ (cl_has_all_vars (append c2 c1) vt) = tt })
  (u4:{ (cl_unique c2) = tt })
  (u5:{ (cl_set_at_prev_levels dl dls c1) = tt })
  (u6:{ (cl_valid nv c1) = tt })
  (u7:{ (cl_valid nv c2) = tt })
  (spec cc':clause)  % supposed to be (cl_erase cc (negated (to_lit l)))
  (spec c:clause)  % supposed to be (to_cl ac)
  (spec n:word)(!#unique_owned ac:<uwarray ulit n>)
  (l:ulit)
  (c_eq:{ c = (to_cl ac) })
  (r1:{ (array_in_bounds nv ac) = tt })
  (r2:{ (cl_subsume cc' (append c2 c1)) = tt }) % means it keeps previous lits
  : #unique <ResState nv (inc_nv nv nv_ub) dl dls cc' (cl_erase c (to_lit l))>.
  abbrev r1' = hypjoin (array_in_bounds nv (vec_nth_tail ac (to_nat 0x0))) tt by r1 end in
  abbrev p1 = hypjoin (le (to_nat 0x0) (to_nat n)) tt by [leZ (word_to_nat n)] end in
  abbrev c' = (cl_erase c (to_lit l)) in
  abbrev d1 = (append lit c2 c1) in
  abbrev d2 = (cl_erase (to_cl (vec_nth_tail ac (to_nat 0x0))) (to_lit l)) in
  abbrev r3_1 = [cl_subsume_refl c'] in
  abbrev r3_2 = [cl_subsume_tt_subsume_append_front c' c' d1 r3_1] in
  abbrev r3_3 = hypjoin c' d2 by c_eq end in
  abbrev r3 = hypjoin (cl_subsume c' (append d1 d2)) tt by r3_2 r3_3 end in
  (append_filter_h nv nv_ub dl dls vt c1 c2 c2l u1 u2 u3 u4 u5 u6 u7 cc' c' n ac l 0x0 r1' r2 r3)


%=============================================================================
% resolve function
%=============================================================================

Define resolve := fun
  (spec nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (dl:word)
  (!#unique_owned dls:<uwarray word (inc_nv nv nv_ub)>)
  (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (c1:clause)       % lits set below the current level
  (spec c2:clause)  % lits set at the current level
  (c2l:nat)
  (u1:{ c2l = (length c2) })
  (u2:{ (all_lits_are_assigned vt (append c2 c1)) = tt })
  (u3:{ (cl_has_all_vars (append c2 c1) vt) = tt })
  (u4:{ (cl_unique c2) = tt })
  (u5:{ (cl_set_at_prev_levels dl dls c1) = tt })
  (u6:{ (cl_valid nv c1) = tt })
  (u7:{ (cl_valid nv c2) = tt })
  (spec n:word)(!#unique_owned ac:<uwarray ulit n>)
  (l:ulit)
  (spec c:clause)
  (c_eq:{ c = (to_cl ac) })
  (r1:{ (lt Z c2l) = tt })
  (r2:{ (ltword (uwarray_get dls (ulit_vnum l)) dl) = ff }) % l is set at current level
  (r3:{ (uwarray_get vt (ulit_vnum l)) = (ulit_assignment (unegated l)) })   % c1++c2 has -l
  (r4:{ (array_in_bounds nv ac) = tt })
  : #unique <ResState nv (inc_nv nv nv_ub) dl dls
              (cl_erase (append lit c2 c1) (negated (to_lit l)))
              (cl_erase c (to_lit l))>.
  abbrev nv' = (inc_nv nv nv_ub) in
  abbrev neg_l = (negated (to_lit l)) in
  abbrev d1 = (append lit c2 c1) in
  abbrev d2 = c in
  abbrev d1' = (cl_erase d1 (negated (to_lit l))) in
  abbrev d2' = (cl_erase d2 (to_lit l)) in
  
  % Step 1: erase (negated l)
  abbrev v = (ulit_vnum l) in
  abbrev p1 = [uwarray_get_implies_ltword assignment nv' vt v (ulit_assignment (unegated l)) symm r3] in
  let vt' = (uwarray_set assignment nv' vt v UN p1) in
  abbrev c2' = (cl_erase c2 neg_l) in
  match c2l with
    Z => impossible
           trans symm r1
           trans hypjoin (lt Z c2l) ff by c2l_eq end
                 clash ff tt
          <ResState nv (inc_nv nv nv_ub) dl dls d1' d2'>
  | S c2l' =>
    
  % Step 2: (append c' (cl_erase (to_cl ac) l))
  abbrev u1'_1 = [_res_lem1 nv nv_ub dl dls vt c1 c2 u6 u3 u5 l r2 r3] in
  abbrev u1'_2 = [cl_unique_erase_lit_length c2 neg_l u4 u1'_1] in
  abbrev u1'_3 = hypjoin (S c2l') (S (length c2')) by c2l_eq u1 u1'_2 end in
  abbrev u1' = inj (S *) u1'_3 in
  abbrev u2' = [_res_lem2 nv nv_ub dl dls vt vt' c1 c2 u6 u7 u2 u5 l r3 r2 vt'_eq] in
  abbrev u3' = [_res_lem3 nv nv_ub dl dls vt vt' c1 c2 u6 u3 u5 l r3 r2 vt'_eq] in
  abbrev u4' = [cl_unique_implies_unique_erase c2 neg_l u4] in
  abbrev u7' = [cl_erase_lem1 nv c2 u7 neg_l] in
  abbrev d2_eq = c_eq in
  % goal: (cl_subsume d1' (append c2' c1)) = tt
  % need: (cl_erase (append c2 c1) neg_l) = (append (cl_erase c2 neg_l) c1)
  % need: (cl_subsume (cl_erase d1 neg_l) (cl_erase d2 neg_l)) = tt
  abbrev r2'_1 = [ulit_vnum_eq_to_lit_negated_lit_vnum l] in
  abbrev r2' = hypjoin (ltword (uwarray_get dls (lit_vnum neg_l)) dl) ff by r2 r2'_1 end in
  abbrev r5_1 = [_res_lem4 nv nv_ub dl dls vt' c1 c2 u6 u5 neg_l r2'] in
  abbrev r5_2 = [cl_subsume_refl d1'] in
  abbrev r5 = trans cong (cl_subsume d1' *) symm r5_1
                    r5_2 in 
  (append_filter nv nv_ub dl dls vt' c1 c2' c2l' u1' u2' u3' u4' u5 u6 u7' d1' d2 n ac l d2_eq r4 r5)
  end
