%==============================================================================
%  CNF file parser
%==============================================================================
Include trusted "pf.g".

%==============================================================================
% parsing utilities
%==============================================================================

Define skip_spaces :=
	fun skip_spaces(#unique io:<pb_stdio_t tt>):#unique <pb_stdio_t tt>.
	let c = (pb_cur_char io) in
	match (is_whitespace c) with
		ff => io
	|	tt => (skip_spaces (pb_next_char io))
  end.

Define read_word :=
	fun read_word(#unique io:<pb_stdio_t tt>):#unique pb_readstring_t.
	let c = (pb_cur_char io) in
	match (or (eqchar c '\0') (is_whitespace c)) with
		ff =>
      match (read_word (pb_next_char io)) with mk_pb_readstring io s' =>
      (mk_pb_readstring io (stringc c s'))
      end
	|	tt => (mk_pb_readstring io (inc string stringn))
  end.
  
% get the next maximal non-whitespace sequence of characters,
% possibly empty (EOF).
Define pb_get_chars :=
	fun pb_get_chars(#unique io:<pb_stdio_t tt>):#unique pb_readstring_t.
	let io = (pb_get_char2 io) in
  let io = (skip_spaces io) in
  (read_word io).

Define p_string_to_word :=
	fun (s : string):word .
	match s with
		unil _ => abort word
	|	ucons _ c s' =>
    let sign = (not (eqchar c '-')) in
    match sign with
      ff =>
        (string_num_to_word s')
    |	tt =>
        let w = (string_num_to_word (ucons char c s')) in
        match (eqword w word0) with % don't treat "0" to be positive
          ff => (word_plus w 0x80000000)
        | tt => word0
        end
    end
	end.


%==============================================================================
% read the header and return the # of vars and clauses
%==============================================================================
Inductive pb_readheader_t : type :=
	mk_pb_readheader : Fun(#unique pb_stdio : <pb_stdio_t tt>)(vnum:word)(cnum:word) . #unique pb_readheader_t.

Define remove_comment :=
	fun remove_comment(#unique pb_stdio : <pb_stdio_t tt>): #unique <pb_stdio_t tt>.
	match (pb_get_chars pb_stdio) with
		mk_pb_readstring pb_stdio s =>
		match s with
			unil _ => pb_stdio
		|	ucons _ c s' =>
				match (eqchar c 'c') with
					ff => (pb_pushback2 pb_stdio (ucons char c s'))
				|	tt =>
						let pb_stdio = (pb_consume_to_eol pb_stdio) in
						do
							(dec string s')
							(remove_comment pb_stdio)
						end
				end
		end
	end.

Define read_header :=
	fun (#unique pb_stdio : <pb_stdio_t tt>): #unique pb_readheader_t.
	let pb_stdio = (remove_comment pb_stdio) in
	match (pb_get_chars pb_stdio) with mk_pb_readstring pb_stdio s =>
  do
    (dec string s)  % s is supposed to be "p"
		match (pb_get_chars pb_stdio) with mk_pb_readstring pb_stdio s =>
    do
      (dec string s) % s is supposed to be "cnf"
      match (pb_get_chars pb_stdio) with mk_pb_readstring pb_stdio s =>
      let vnum = (string_num_to_word s) in
      match (pb_get_chars pb_stdio) with mk_pb_readstring pb_stdio s =>
        let cnum = (string_num_to_word s) in
        (mk_pb_readheader (pb_consume_to_eol pb_stdio) vnum cnum)
      end end
		end end
	end end.


%==============================================================================
% parse formula
%==============================================================================
Inductive pb_clause_t : type :=
	mk_pb_clause : Fun(#unique pb_stdio : <pb_stdio_t tt>)(c:clause) . #unique pb_clause_t.
Inductive pb_formula_t : type :=
	mk_pb_formula : Fun(#unique pb_stdio : <pb_stdio_t tt>)(f:formula) . #unique pb_formula_t.

Define parse_clause :=
	fun parse_clause(#unique pb_stdio : <pb_stdio_t tt>)(c:clause):#unique pb_clause_t.
	match (pb_get_chars pb_stdio) with mk_pb_readstring pb_stdio s =>
  let w = (p_string_to_word s) in
  match (eqword w 0x0) with
		ff =>
			match (parse_clause pb_stdio c) with mk_pb_clause pb_stdio c =>
      (mk_pb_clause pb_stdio (cons lit (boxWord w) c))
			end
	|	tt =>
			(mk_pb_clause pb_stdio c)
	end
	end.
  
Define parse_formula :=
	fun parse_formula(#unique pb_stdio : <pb_stdio_t tt>)(counter:word)(f:formula):#unique pb_formula_t.
	match (not (eqword counter 0x0)) with
		ff => (mk_pb_formula pb_stdio f)
	|	tt =>
		match (parse_clause pb_stdio (nil lit)) with
			mk_pb_clause pb_stdio c =>
			(parse_formula pb_stdio (word_minus counter 0x1) (cons clause c f))
		end
	end.
  

%==============================================================================
% parse benchmark
%==============================================================================
Inductive pb_parser_t : type :=
	mk_pb_parser : Fun(#unique pb_stdio : <pb_stdio_t tt>)(vnum:word)(f:formula) . #unique pb_parser_t.

Define parse :=
	fun(#unique pb_stdio : <pb_stdio_t tt>) : #unique pb_parser_t.
	match (read_header pb_stdio) with mk_pb_readheader pb_stdio vnum cnum =>
  match (parse_formula pb_stdio cnum (nil clause)) with mk_pb_formula pb_stdio f =>
  (mk_pb_parser pb_stdio vnum f)
	end end.
