%=============================================================================
% main.g: The entry point of the whole program (trusted)
% - specifies the type of "solve" function to ensure its correctness
% - the body points to the actual implementation, which is to be verified.
% - the main function parses the formula and passes it to "solve" function
%=============================================================================
Include trusted "parser.g"
Include trusted "solver.g"

Define solve : Fun(nv:word)(F:formula).<answer F> := solve_impl

Define main :=
	match (parse pb_stdio) with mk_pb_parser io nv f =>
	let io =
		match (solve nv f) with
			sat _ => (pb_print_string io "SAT\n")
		| unsat _ _ => (pb_print_string io "UNSAT\n")
		end in
	(consume_unique <pb_stdio_t tt> io)
	end
