%=============================================================================
% arithmetic lemmas
%=============================================================================

%- unused
Define lt_plus_implies_lt_1 :
  Forall(a b c:nat)(u:{ (lt (plus a b) c) = tt })
  .{ (lt a c) = tt }
  :=
  foralli(a b c:nat)(u:{ (lt (plus a b) c) = tt })
  .
  abbrev p1 = [plus_implies_le a b] in
  [lelt_trans a (plus a b) c p1 u]
-%

Define lt_plus_implies_lt_2 :
  Forall(a b c:nat)(u:{ (lt (plus a b) c) = tt })
  .{ (lt b c) = tt }
  :=
  foralli(a b c:nat)(u:{ (lt (plus a b) c) = tt })
  .
  abbrev p1 = [plus_implies_le b a] in
  abbrev u' = hypjoin (lt (plus b a) c) tt by [plus_comm a b] u end in
  [lelt_trans b (plus b a) c p1 u']

Define le_plus_S_implies_lt :
  Forall(a b c:nat)(u:{ (le (plus (S a) b) c) = tt })
  .{ (lt b c) = tt }
  :=
  foralli(a b c:nat)(u:{ (le (plus (S a) b) c) = tt })
  .
  abbrev p1 = hypjoin (le (S (plus a b)) c) tt by u end in
  abbrev p2 = [le_S_lt (plus a b) c p1] in
  [lt_plus_implies_lt_2 a b c p2]

%- not used
Define lelt_trans_le : Forall(a b c:nat)(u:{ (le a b) = tt })(v:{ (lt b c) = tt })
											.{ (le a c) = tt }
	:=
	foralli(a b c:nat)(u:{ (le a b) = tt })(v:{ (lt b c) = tt }).
	abbrev p1 = [lelt_trans a b c u v] in
	[lt_implies_le a c p1]
-%

Define lt_trans_le : Forall(a b c:nat)(u:{ (lt a b) = tt })(v:{ (lt b c) = tt })
											.{ (le a c) = tt }
	:=
	foralli(a b c:nat)(u:{ (lt a b) = tt })(v:{ (lt b c) = tt }).
	abbrev p1 = [lt_trans a b c u v] in
	[lt_implies_le a c p1]

%- not used
Define lt_ff_implies_lt_S : Forall
  (a b:nat)(u:{ (lt a b) = ff })
  .{ (lt b (S a)) = tt }
  := foralli
  (a b:nat)(u:{ (lt a b) = ff })
  .
  abbrev p1 = [lt_ff_implies_le a b u] in
  abbrev p2 = [lt_S a] in
  [lelt_trans b a (S a) p1 p2]
-%

Define minus_lt_Z : Forall
	(a b:nat)(u:{ (lt b a) = tt }).{ (lt Z (minus a b)) = tt }
	:=
  induction(a: nat) return
    Forall(b: nat)(u:{ (lt b a) = tt }).{ (lt Z (minus a b)) = tt }
  with
    | Z =>
      foralli(b:nat)(u:{ (lt b a) = tt }).
      contra
        trans symm u
        trans hypjoin (lt b a) ff by [lt_Z b] a_eq end
              clash ff tt
        
        { (lt Z (minus a b)) = tt }
    | S a' =>
      foralli(b:nat)(u:{ (lt b a) = tt }).
      case b with
        | Z =>
          hypjoin (lt Z (minus a b)) tt by b_eq a_eq end
        | S b' =>
          abbrev b'_lt_a' = hypjoin (lt b' a') tt by a_eq b_eq [S_lt_S b' a'] u end in
          abbrev b'_le_a' = [lt_implies_le b' a' b'_lt_a'] in
          abbrev a'_not_lt_b' = [le_tt_implies_lt_ff b' a' b'_le_a'] in
          hypjoin (lt Z (minus a b)) tt by
            a_eq
            b_eq 
            [a_IH a' b' b'_lt_a'] 
            [minusS1 a' b' a'_not_lt_b'] 
            [minusS2 a' b' b'_lt_a']
          end
      end %b
  end. %a

Define minus_le_Z : Forall
	(a b:nat)(u:{ (le b a) = tt }).{ (le Z (minus a b)) = tt }
	:=
  foralli(a b: nat)(u:{ (le b a) = tt }).
  case (eqnat b a) by v ign with
    | ff =>
      abbrev b_lt_a = [eqnat_ff_implies_lt b a v u] in
      abbrev Z_lt_a_minus_b = [minus_lt_Z a b b_lt_a] in
      [lt_implies_le Z (minus a b) Z_lt_a_minus_b]      
    | tt =>
      abbrev b_eq_a = [eqnatEq b a v] in 
      abbrev a_minus_b_eq_Z = 
        trans cong (minus a *) b_eq_a
              [x_minus_x a]
      in
      trans cong (le Z *) a_minus_b_eq_Z
            [x_le_x Z]
  end.

Define minus_lt2 : Forall
	(a b:nat)(u1:{ (le b a) = tt })(u2:{ (lt Z b) = tt }).{ (lt (minus a b) a) = tt }
	:=
  foralli(a: nat).
  induction (b:nat) return
    Forall(u1:{ (le b a) = tt })(u2:{ (lt Z b) = tt }).{ (lt (minus a b) a) = tt }
  with
    | Z =>
      foralli(u1:{ (le b a) = tt })(u2:{ (lt Z b) = tt }).
      contra 
        trans symm b_eq
              [lt_implies_not_zero Z b u2]

        { (lt (minus a b) a) = tt }
    | S b' =>
      foralli(u1:{ (le b a) = tt })(u2:{ (lt Z b) = tt }).
      
      case a with
        | Z =>
          contra
            abbrev Z_lt_a = [ltle_trans Z b a u2 u1] in 
            trans [lt_implies_not_zero Z a Z_lt_a]
                  symm a_eq

            { (lt (minus a b) a) = tt }
        | S a' =>
          abbrev stripped = 
            hypjoin (minus a b) (minus a' b') by a_eq b_eq end
          in

          case b' with
            | Z =>
              abbrev a_minus_b_eq_a' =
                trans stripped
                trans cong (minus a' *) b'_eq
                      join (minus a' Z) a'
              in
              trans cong (lt * a) a_minus_b_eq_a'
              trans cong (lt a' *) a_eq 
                    [lt_S a']
            | S b'' =>
              abbrev z_lt_b' = hypjoin (lt Z b') tt by b'_eq end in
              abbrev b'_lt_b = 
                trans cong (lt b' *) b_eq
                      [lt_S b']
              in
              abbrev b'_lt_a = [ltle_trans b' b a b'_lt_b u1] in
              abbrev b'_le_a = [lt_implies_le b' a b'_lt_a] in
              abbrev x = (minus a (S b')) in
              abbrev Sx_lt_a = 
                trans cong (lt * a) 
                           symm [minusS2 a b' b'_lt_a] 
                      [b_IH b' b'_le_a z_lt_b']
              in
              abbrev x_lt_a = [lt_trans x (S x) a [lt_S x] Sx_lt_a] in

              trans cong (lt * a)
                         hypjoin (minus a b) x by b_eq end 
                    x_lt_a
          end % b'
      end % a
  end. %b

Define Z_lt_Sa :
  Forall(a: nat). { (lt Z (S a)) = tt }
  :=
  foralli(a: nat).
  join (lt Z (S a)) tt

% a - (a - b) = a - a + b = b
Define minus_minus : 
  Forall (a b:nat)(u:{ (le b a) = tt }).{ (minus a (minus a b)) = b }
  :=
  foralli(a:nat).
  induction(b:nat) return
    Forall(u:{ (le b a) = tt }). { (minus a (minus a b)) = b }
  with
    | Z =>
      foralli(u:{ (le b a) = tt }).
      abbrev minusAB_eq_A = 
          trans cong (minus a *) b_eq
                [minusZ a]
      in
      trans cong (minus a *) minusAB_eq_A
      trans [x_minus_x a]
            symm b_eq
    | S b' =>
      foralli(u:{ (le b a) = tt }).
      abbrev b'_lt_b = 
        trans cong (lt b' *) b_eq 
              [lt_S b']
      in
      abbrev b'_lt_a = [ltle_trans b' b a b'_lt_b u] in
      abbrev b'_le_a = [lt_implies_le b' a b'_lt_a] in
      %(minus a b') = (S (minus a b))
      abbrev p1 = 
        trans [minusS2 a b' b'_lt_a] 
              cong (S (minus a *)) symm b_eq
      in
      abbrev z_lt_b =
        trans cong (lt Z *) b_eq
              [Z_lt_Sa b']
      in
      abbrev a_minus_b_lt_a = [minus_lt2 a b u z_lt_b] in
      trans [minusS2 a (minus a b) a_minus_b_lt_a]  %(minus a (minus a b)) = (S (minus a (S (minus a b)))
      trans cong (S (minus a *)) symm p1            %(S (minus a (S (minus a b))) = (S (minus a (minus a b')))
      trans cong (S *) [b_IH b' b'_le_a]            %(S (minus a (minus a b'))) = (S b')
            symm b_eq                               %(S b') = b
    end.

Define minus_le2 : Forall(x y z:nat)(u:{ (minus x y) = z }).{ (le y x) = tt }
	:= foralli
	(x y z:nat)(u:{ (minus x y) = z })
	.
	case (le y x) by q1 _ with
	| ff =>
		cabbrev p1 = [le_ff_implies_lt y x q1] % (lt x y) = tt
		cabbrev p2 =
			[
			induction(x y:nat) return Forall(u:{ (lt x y) = tt }).{ (minus x y) = abort ! }
			with
			| Z => foralli
				(u:{ (lt x y) = tt })
				.
				contra
				trans symm u
				trans hypjoin (lt x y) ff by [lt_Z x] y_eq end
							clash ff tt
				{ (minus x y) = abort ! }
			| S y' => foralli
				(u:{ (lt x y) = tt })
				.
				case x with
				| Z =>
					hypjoin (minus x y) abort ! by x_eq y_eq end
				| S x' =>
					cabbrev u' = hypjoin (lt x' y') tt by u x_eq y_eq end
					cabbrev ih = [y_IH x' y' u']
					hypjoin (minus x y) abort ! by ih x_eq y_eq end
				end
			end
			x y p1]
		contra
		trans symm u
		trans p2
					aclash z
		{ (le y x) = tt }
		
	| tt => q1
	end

Define lt_minus_S : Forall	% could use minus_lt2
	(a b:nat)(u:{ (le (S b) a) = tt })
	.{ (lt (minus a (S b)) a) = tt }
	:=
	induction(a:nat) return Forall
		(b:nat)
		(u:{ (le (S b) a) = tt })
		.{ (lt (minus a (S b)) a) = tt }
	with
	| Z => foralli
		(b:nat)
		(u:{ (le (S b) a) = tt })
		.
		contra
		trans symm u
		trans hypjoin (le (S b) a) ff by a_eq end
					clash ff tt
		{ (lt (minus a (S b)) a) = tt }
	| S a' => foralli
		(b:nat)
		(u:{ (le (S b) a) = tt })
		.
		case b with
		| Z =>
			cabbrev p1 = hypjoin (lt a' a) tt by a_eq [lt_S a'] end
			cabbrev p2 = hypjoin (minus a (S b)) a' by a_eq b_eq end
			hypjoin (lt (minus a (S b)) a) tt by p1 p2 end
		| S b' =>
			cabbrev u' = hypjoin (le (S b') a') tt by u a_eq b_eq end
			cabbrev ih = [a_IH a' b' u']
			cabbrev p1 = hypjoin (minus a (S b)) (minus a' (S b')) by a_eq b_eq end
			cabbrev p2 = hypjoin (lt (minus a (S b)) a') tt by p1 ih end
			cabbrev p3 = [lt_S3 (minus a (S b)) a' p2]
			hypjoin (lt (minus a (S b)) a) tt by p3 a_eq end
		end
	end

Define a_minus_b_eq_a : Forall(a b:nat)(u:{ (minus a b) = a }).{ b = Z }
	:=
	induction(a b:nat) return Forall
		(u:{ (minus a b) = a })
		.{ b = Z }
	 with
	| Z => foralli
		(u:{ (minus a b) = a })
		.
		b_eq
	| S b' => foralli
		(u:{ (minus a b) = a })
		.
		cabbrev p1 = [minus_le2 a b a u] % (le b a) = tt
		cabbrev p2_1 = hypjoin (le (S b') a) tt by p1 b_eq end
		cabbrev p2 = [lt_minus_S a b' p2_1]	% (lt (minus a (S b')) a) = tt
		contra
		trans symm p2
		trans hypjoin (lt (minus a (S b')) a) ff by [x_lt_x a] u b_eq end
					clash ff tt
		{ b = Z }
	end


%=============================================================================
% vector lemmas
%=============================================================================

Define vec_get_abort :
  Forall(A:type)(n:nat)(v:<vec A n>)
        (i:nat)(u:{ (lt i n) = ff }).
    { (vec_get v i) = abort ! }
  :=
  foralli(A:type).
  induction(n:nat)(v:<vec A n>) return
    Forall(i:nat)(u:{ (lt i n) = ff }).{ (vec_get v i) = abort ! }
  with
    vecn _ =>
      foralli(i:nat)(u:{ (lt i n) = ff }).
      hypjoin (vec_get v i) abort ! by v_eq end
  | vecc _ n' a v' =>
      foralli(i:nat)(u:{ (lt i n) = ff }).
      abbrev n_eq = inj <vec ** *> v_Eq in
      case i with
        Z =>
          contra
          trans symm u
          trans hypjoin (lt i n) tt by i_eq n_eq end
                clash tt ff
          { (vec_get v i) = abort ! }
      | S i' =>
					abbrev u' = hypjoin (lt i' n') ff by u i_eq n_eq end in
					abbrev ih = [v_IH n' v' i' u'] in
					hypjoin (vec_get v i) abort ! by v_eq i_eq ih end
      end
  end

Define vec_update_abort :
  Forall(A:type)(a:A)(n:nat)(v:<vec A n>)
        (i:nat)(u:{ (lt i n) = ff }).
    { (vec_update v i a) = abort ! }
  :=
  foralli(A:type)(a:A).
  induction(n:nat)(v:<vec A n>) return
    Forall(i:nat)(u:{ (lt i n) = ff }).{ (vec_update v i a) = abort ! }
  with
    vecn _ =>
      foralli(i:nat)(u:{ (lt i n) = ff }).
      hypjoin (vec_update v i a) abort ! by v_eq end
  | vecc _ n' x v' =>
      foralli(i:nat)(u:{ (lt i n) = ff }).
      abbrev n_eq = inj <vec ** *> v_Eq in
      case i with
        Z =>
          contra
          trans symm u
          trans hypjoin (lt i n) tt by i_eq n_eq end
                clash tt ff
          { (vec_update v i a) = abort ! }
      | S i' =>
					abbrev u' = hypjoin (lt i' n') ff by u i_eq n_eq end in
					abbrev ih = [v_IH n' v' i' u'] in
					hypjoin (vec_update v i a) abort ! by v_eq i_eq ih end
      end
  end

Define vec_append_vecc_assoc : Forall
  (A:type)
	(n1:nat)(l1:<vec A n1>)
	(a:A)
	(n2:nat)(l2:<vec A n2>)
	.{ (vec_append l1 (vecc a l2)) = (vec_append (vec_append l1 (vecc a vecn)) l2) }
	:= foralli
	(A:type)
	(n1:nat)(l1:<vec A n1>)
	(a:A)
	(n2:nat)(l2:<vec A n2>)
	.
	abbrev p1 = join (vec_append l1 (vecc a l2)) (vec_append l1 (vec_append (vecc a vecn) l2)) in
	abbrev p2 = [vec_append_assoc A n1 l1 (S Z) n2 (vecc A Z a (vecn A)) l2] in
	trans p1 symm p2
	
Define vec_get_implies_lt :
  Forall(A:type)(n i:nat)(v:<vec A n>)(a:A)(u:{ a = (vec_get v i) })
    .{ (lt i n) = tt }
  :=
  foralli(A:type)(n i:nat)(v:<vec A n>)(a:A)(u:{ a = (vec_get v i) }).
  case (lt i n) by q1 _ with
    ff => contra
            trans u
            trans [vec_get_abort A n v i q1]
                  aclash a
            { (lt i n) = tt }
  | tt => q1
  end


%=============================================================================
% word lemmas
%=============================================================================

Define word_to_nat_Z_implies_word0 : Forall
  (w:word)
	(u:{ (to_nat w) = Z })
	.{ w = word0 }
	:= foralli
  (w:word)
	(u:{ (to_nat w) = Z })
	.
	case (eqword word0 w) by q1 _ with
	| ff =>
		% p1: { word0 != w }
		% p2: { (to_nat word0) != (to_nat w) }
		cabbrev p1 = [eqword_ff_neq word0 w q1]
		cabbrev p2 = [word_neq_to_nat_neq word0 w p1]
		contra
		transs
			join Z (to_nat word0)
		  p2
			u
		end
		{ w = word0 }
	| tt =>
	  symm [eqword_eq word0 w q1]
	end
	
Define ltword_word_inc2_implies_leword :=
  foralli(w w':word)(u:{ (ltword w (word_inc2 w')) = tt }).
  abbrev p1 = cinv (word_inc2 w')
  							trans cong (ltword w *) symm eval (word_inc2 w')
  										u
  	in
  existse p1
  foralli(x:word)(x_pf:{ (word_inc2 w') = x }).
  abbrev p2 = [word_inc2_word_to_nat w' x symm x_pf] in
  abbrev p3 = hypjoin (lt (to_nat w) (S (to_nat w'))) tt by u x_pf p2 end in
  trans [leword_to_le w w']
			  [lt_pred2 (word_to_nat w) (word_to_nat w') p3]

%- not used
Define word_inc2_implies_ltword_word_max :
  Forall(w w':word)(u:{ w' = (word_inc2 w) }).{ (ltword w word_max) = tt }
  :=
  foralli(w w':word)(u:{ w' = (word_inc2 w) }).
  abbrev p1 = [word_inc2_implies_ltword w w' u] in
  [ltleword_trans w w' word_max p1 [leword_word_max w']]

Define leword_word_inc2_implies_ltword :
  Forall(a b b':word)
        (u1:{ (leword a b) = tt })
        (u2:{ b' = (word_inc2 b) }).
    { (ltword a b') = tt }
  :=
  foralli(a b b':word)
         (u1:{ (leword a b) = tt })
         (u2:{ b' = (word_inc2 b) }).
  abbrev p1 = [word_inc2_implies_ltword b b' u2] in
  [leltword_trans a b b' u1 p1].

-%

Define ltword_word_inc2_implies_lewordb :
  Forall(a b:word)
        (a':word)
        (u1:{ (ltword a b) = tt })
        (u2:{ a' = (word_inc2 a) }).
    { (leword a' b) = tt }
  :=
  foralli(a b:word)
         (a':word)
         (u1:{ (ltword a b) = tt })
         (u2:{ a' = (word_inc2 a) }).
  abbrev u1' = hypjoin (lt (to_nat a) (to_nat b)) tt by u1 end in
  abbrev p1 = [word_inc2_word_to_nat a a' u2] in
  abbrev p2 = [lt_S_le (word_to_nat a) (word_to_nat b) u1'] in
  trans join (leword a' b) (le (to_nat a') (to_nat b))
  trans	cong (le * (to_nat b)) symm p1
  			p2

Define ltword_and_word_inc_safe_implies_leword : 
  Forall(x x' y:word)(u:{ (ltword x y) = tt })(r:{ x' = (word_inc_safe x) }).
    { (leword x' y) = tt } :=
  foralli(x x' y:word)(u:{ (ltword x y) = tt })(r:{ x' = (word_inc_safe x) }).
      [ltword_word_inc2_implies_lewordb x y x' u hypjoin x' (word_inc2 x) by r end].

Define leword_and_word_dec_safe_implies_ltword : Forall
  (x x' y:word)(u:{ (leword x y) = tt })(u2:{ x' = (word_dec_safe x) })
  .{ (ltword x' y) = tt }
  :=
  foralli(x x' y:word)(u:{ (leword x y) = tt })(u2:{ x' = (word_dec_safe x) }).
    case (bv_dec wordlen x) by u3 _ with
      mk_bv_dec_t _ nonzero r =>
        case nonzero with
          ff =>
          contra
            transs
              u2
              hypjoin (word_dec_safe x) abort ! by nonzero_eq u3 end
              aclash x'
            end
          { (ltword x' y) = tt }
        | tt => 
          trans
            join (ltword x' y) (lt (to_nat x') (to_nat y))
            [le_S_lt (to_nat wordlen x') (to_nat wordlen y)
              symm
              transs
                symm u
                join (leword x y) (le (to_nat x) (to_nat y))
                cong (le * (to_nat y))
                  symm trans
                    [to_nat_bv_inc wordlen x' x ff
                      trans
                        cong (bv_inc *) trans u2 hypjoin (word_dec_safe x) r by nonzero_eq u3 end
                        [bv_dec_inc wordlen x r trans u3 cong (mk_bv_dec_t * r) nonzero_eq]]
                    [condplusff (pow2 wordlen) (to_nat wordlen x)]
              end]
        end
    end.  

Define leword_and_word_dec_safe_implies_leword : 
  Forall(x x' y:word)(u:{ (leword x y) = tt })(u2:{ x' = (word_dec_safe x) }).
    { (leword x' y) = tt } :=
  foralli(x x' y:word)(u:{ (leword x y) = tt })(u2:{ x' = (word_dec_safe x) }).
    trans
      join (leword x' y) (le (to_nat x') (to_nat y))
      [lt_implies_le (to_nat wordlen x') (to_nat wordlen y)
         symm
         trans
           symm [leword_and_word_dec_safe_implies_ltword x x' y u u2]
           join (ltword x' y) (lt (to_nat x') (to_nat y))].

Define word_set_clear_msb :
  Forall(w:word).
    { (word_clear_msb (word_set_msb w)) = (word_clear_msb w) }
  :=
  foralli(w:word).
    transs join (word_clear_msb (word_set_msb w))
                (word_clear_bit 0x1f (word_set_bit 0x1f w))
           [word_set_clear w 0x1f join (lt (to_nat word0x1f) wordlen) tt]
           join (word_clear_bit 0x1f w)
                (word_clear_msb w)
    end
           
Define word_clear_clear :
  Forall(w:word)
        (i:word)
        (u:{ (lt (to_nat i) wordlen) = tt }).
    { (word_clear_bit i (word_clear_bit i w)) = (word_clear_bit i w) }
  :=
  foralli(w:word)(i:word)
         (u:{ (lt (to_nat i) wordlen) = tt }).
  abbrev p1 = [vec_update_twice bool wordlen w (word_to_nat i) ff ff u] in
  hypjoin (word_clear_bit i (word_clear_bit i w))
          (word_clear_bit i w)
    by p1 end
  .

Define word_clear_clear_msb :
  Forall(w:word).
    { (word_clear_msb (word_clear_msb w)) = (word_clear_msb w) }
  :=
  foralli(w:word).
    transs join (word_clear_msb (word_clear_msb w))
                (word_clear_bit 0x1f (word_clear_bit 0x1f w))
           [word_clear_clear w 0x1f join (lt (to_nat word0x1f) wordlen) tt]
           join (word_clear_bit 0x1f w)
                (word_clear_msb w)
    end

Define word_dec_safe_to_nat :
	Forall(w:word)(u:{ (ltword word0 w) = tt })
	.{ (S (to_nat (word_dec_safe w))) = (to_nat w) }
	:= 
  foralli(w:word)(u:{ (ltword word0 w) = tt }).
    case (bv_dec wordlen w) by u2 _ with
      mk_bv_dec_t _ nonzero ret =>
      case (bv_inc wordlen ret) by u3 _ with
        mk_bv_inc_t _ ret2 carry =>
         abbrev P = 
          trans symm u3
            [bv_dec_inc wordlen w ret 
             trans u2
               cong (mk_bv_dec_t * ret)
                 [neq_bv0_implies_bv_dec_nonzero 
                    wordlen w ret nonzero 
                    [ltword_wordneq w u]
                    u2]] in
        transs 
          cong (S (to_nat *))
            hypjoin (word_dec_safe w) ret by u2 [bv_dec_safe_nonzero w ret nonzero u u2] end
          [to_nat_bv_inc wordlen ret ret2 carry u3]
          cong (condplus * (pow2 wordlen) (to_nat ret2))
            inj (mk_bv_inc_t ** *) P 
          [condplusff (pow2 wordlen) (to_nat wordlen ret2)]
          cong (to_nat *) inj (mk_bv_inc_t * **) P
        end
      end
    end.

Define word_dec_inc_safe :
  Forall(w:word)(u:{ (ltword word0 w) = tt }).
    { (word_inc_safe (word_dec_safe w)) = w } := 
  foralli(w:word)(u:{ (ltword word0 w) = tt }).
    case (bv_dec wordlen w) by u2 _ with
      mk_bv_dec_t _ nonzero ret =>
        hypjoin (word_inc_safe (word_dec_safe w)) w 
        by u2
           [bv_dec_safe_nonzero w ret nonzero u u2]
           [bv_dec_inc wordlen w ret 
             trans u2
               cong (mk_bv_dec_t * ret)
                 [neq_bv0_implies_bv_dec_nonzero 
                    wordlen w ret nonzero 
                    [ltword_wordneq w u]
                    u2]]
        end
    end.


%=============================================================================
% uwarray lemmas
%=============================================================================

%-
Define uwarray_set_get' :
  Forall(A:type)(n:word)(l:<uwarray A n>)
        (m:word)(a b:A)
        (u:{ b = (uwarray_get (uwarray_set l m a) m) })
		.{ a = b }
  :=
  foralli(A:type)(n:word)(l:<uwarray A n>)
         (m:word)(a b:A)
         (u:{ b = (uwarray_get (uwarray_set l m a) m) })
  .
	case (ltword m n) by q1 _ with
		ff =>
			contra
			abbrev q1' = hypjoin (lt (word_to_nat m) (word_to_nat n)) ff by q1 end in
			abbrev p1 = [vec_update_abort A a (word_to_nat n) l (word_to_nat m) q1'] in
			trans u
			trans hypjoin (uwarray_get (uwarray_set l m a) m) abort ! by p1 end
						aclash b
			{ a = b }
	| tt =>
			symm
			trans u
						[uwarray_set_get A n l m a q1]
	end
-%

Define uwarray_get_implies_ltword :
  Forall(A:type)(n:word)(l:<uwarray A n>)(i:word)(a:A)(u:{ a = (uwarray_get l i) }).
    { (ltword i n) = tt }
  := foralli
	(A:type)(n:word)(l:<uwarray A n>)(i:word)(a:A)(u:{ a = (uwarray_get l i) })
	.
	case (ltword i n) by q1 _ with
		ff =>
			contra
			abbrev q1' = hypjoin (lt (word_to_nat i) (word_to_nat n)) ff by q1 end in
			abbrev p1 = [vec_get_abort A (word_to_nat n) l (word_to_nat i) q1'] in
			trans u
			trans hypjoin (uwarray_get l i) abort ! by p1 end
						aclash a
			{ (ltword i n) = tt }
	| tt =>
			q1
	end

Define uwarray_set_implies_ltword :
  Forall(A:type)(n:word)(l l':<uwarray A n>)(i:word)(a:A)(u:{ l' = (uwarray_set l i a) })
	.{ (ltword i n) = tt }
  :=
	foralli(A:type)(n:word)(l l':<uwarray A n>)(i:word)(a:A)(u:{ l' = (uwarray_set l i a) })
	.
	case (ltword i n) by q1 _ with
		ff =>
			contra
			abbrev q1' = hypjoin (lt (word_to_nat i) (word_to_nat n)) ff by q1 end in
			abbrev p1 = [vec_update_abort A a (word_to_nat n) l (word_to_nat i) q1'] in
			trans u
			trans hypjoin (uwarray_set l i a) abort ! by p1 end
						aclash l'
			{ (ltword i n) = tt }
	| tt =>
			q1
	end

%- impossible
Define all_uwarray_get_implies_eq_h : Forall
	(A:type)(n:word)(l l':<uwarray A n>)
	(u:Forall(m:word)(q:{ (ltword m n) = tt }).{ (uwarray_get l m) = (uwarray_get l' m) })
	(i:nat)
	(q:{ (lt i (to_nat n)) = tt })
	.{ (vec_get l i) = (vec_get l' i) }
	:=
	truei
-%

Define all_uwarray_get_implies_eq : Forall
	(A:type)(n:word)(l l':<uwarray A n>)
	(u:Forall(m:word)(q:{ (ltword m n) = tt }).{ (uwarray_get l m) = (uwarray_get l' m) })
	.{ l = l' }
  :=
	foralli(A:type)(n:word).
	[
	induction(j:nat) return Forall
		(n:word)(n_eq:{ (to_nat n) = j })
		(l l':<uwarray A n>)
		(u:Forall(m:word)(q:{ (ltword m n) = tt }).{ (uwarray_get l m) = (uwarray_get l' m) })
		.{ l = l' }
	with
	| Z => foralli
		(n:word)(n_eq:{ (to_nat n) = j })
		(l l':<uwarray A n>)
		(u:Forall(m:word)(q:{ (ltword m n) = tt }).{ (uwarray_get l m) = (uwarray_get l' m) })
		.
		cabbrev p1 = hypjoin (to_nat n) Z by j_eq n_eq end
		cabbrev l1 = cast l by cong <vec A *> p1
		cabbrev l2 = cast l' by cong <vec A *> p1
		cabbrev l_eq = [vec_sz_Z_vecn A l1]
		cabbrev l'_eq = [vec_sz_Z_vecn A l2]
		hypjoin l l' by l_eq l'_eq end
	| S j' => foralli
		(n:word)(n_eq:{ (to_nat n) = j })
		(l l':<uwarray A n>)
		(u:Forall(m:word)(q:{ (ltword m n) = tt }).{ (uwarray_get l m) = (uwarray_get l' m) })
		.
		cabbrev p1 = hypjoin (ltword word0 n) tt by n_eq j_eq end
		cabbrev n' = (word_dec_safe n p1)

		% p2: (to_nat n') = j'
		cabbrev p2_1 = [word_dec_safe_to_nat n p1]
		cabbrev p2_2 = transs p2_1 n_eq j_eq end
		cabbrev p2 = inj (S *) p2_2
		
		case l with
		| vecn _ =>
			% j_eq: j = (S j')
			% n_eq: (to_nat n) = j
			contra
			cabbrev p3 = inj <vec ** *> l_Eq	% (to_nat n) = Z
			cabbrev p4 = transs symm j_eq symm n_eq p3 end
			trans p4 clash Z (S j')
			{ l = l' }
		| vecc _ k1 a1 l1 =>
			case l' with
			| vecn _ =>
				contra
				cabbrev p3 = inj <vec ** *> l'_Eq	% (to_nat n) = Z
				cabbrev p4 = transs symm j_eq symm n_eq p3 end
				trans p4 clash Z (S j')
				{ l = l' }
			| vecc _ k2 a2 l2 =>
				% need: k1 = n'
				% have: (S k1) = (to_nat n) = (S (to_nat n'))
				cabbrev p3_1 = inj <vec ** *> l_Eq	% (to_nat n) = (S k1)
				cabbrev p3_2 = inj <vec ** *> l'_Eq	% (to_nat n) = (S k1)
				cabbrev p4 = hypjoin (S k1) (S (to_nat n')) by n_eq j_eq p2 p3_1 end
				cabbrev p5 = hypjoin (S k2) (S (to_nat n')) by n_eq j_eq p2 p3_2 end
				cabbrev k1_eq = inj (S *) p4	% k1 = (to_nat n')
				cabbrev k2_eq = inj (S *) p5
				cabbrev l1 = cast l1 by cong <vec A *> k1_eq
				cabbrev l2 = cast l2 by cong <vec A *> k2_eq
				
				cabbrev u' =
					foralli(m:word)(q:{ (ltword m n') = tt }).
					cabbrev p6 = [ltword_implies_ltword_word_max m n' q]
					cabbrev m' = (word_inc_safe m p6)
					cabbrev p7 = [word_inc_safe_word_to_nat m p6]	% (to_nat m') = (S (to_nat m))
					cabbrev p8 = hypjoin (uwarray_get l1 m) (uwarray_get l m') by p7 l_eq end
					cabbrev p8' = hypjoin (uwarray_get l2 m) (uwarray_get l' m') by p7 l'_eq end
					cabbrev q' = hypjoin (ltword m' n) tt by p7 n_eq j_eq p2 q end
					cabbrev u' = [u m' q']
					hypjoin (uwarray_get l1 m) (uwarray_get l2 m) by p8 p8' u' end
				
				% ih: l1 = l2
				cabbrev ih = [j_IH j' n' p2 l1 l2 u']
				
				cabbrev p6 = hypjoin (ltword word0 n) tt by n_eq j_eq end
				cabbrev p7 = [u word0 p6]
				hypjoin l l' by p7 ih l_eq l'_eq end
			end
		end
	end
	(word_to_nat n) n refl (to_nat n)]

Define all_uwarray_get_implies_new :
	Forall(A:type)(a:A)(n:word)(l:<uwarray A n>)
				(u:Forall(m:word)(q:{ (ltword m n) = tt }).{ (uwarray_get l m) = a })
			 .{ l = (uwarray_new n a) }
  :=
	foralli(A:type)(a:A)(n:word)(l:<uwarray A n>)
				 (u:Forall(m:word)(q:{ (ltword m n) = tt }).{ (uwarray_get l m) = a }).
	cabbrev l' = (uwarray_new A n a)
	cabbrev u' =
		foralli(m:word)(q:{ (ltword m n) = tt }).
		cabbrev q' = hypjoin (lt (to_nat m) (to_nat n)) tt by q end
		cabbrev p1 = [mkvec_implies_vec_get A a (word_to_nat n) l' (word_to_nat m) q']
		cabbrev p2 = [u m q]
		hypjoin (uwarray_get l m) (uwarray_get l' m) by p1 p2 end
	[all_uwarray_get_implies_eq A n l l' u']
