%=============================================================================
% init.g
% checks the original formula (to screen empty/tautology/unit clauses)
% - ignores tautology clauses
% - assigns lits in unit clauses, but do not propagate
% - returns UNSAT if there is the empty clause in the formula
% -               or two unit clauses conflict
% and builds the initial clause database in watch lists
%=============================================================================
Include trusted "assignment.g".
Include trusted "assignment-util.g".
Include trusted "decision.g".
Include trusted "unitprop.g".

%==============================================================================
% check clauses: classifies clauses in the original formula
%==============================================================================

Inductive check_clause_h_t : Fun(nv:word)(c:clause).type :=
  check_clause_tautalogy : Fun
    (spec nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
    (spec c:clause)
    (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
    (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
    .#unique <check_clause_h_t nv c>
    
| check_clause_ok : Fun
    (spec nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
    (spec c:clause)
    (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
    (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
    (c':clause) % duplicataion-free version of c
    (u1:{ (cl_subsume c c') = tt })
    (u2:{ (cl_valid nv c') = tt })
    .#unique <check_clause_h_t nv c>
.

Define check_clause_h := fun check_clause_h
  (nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
  (spec c:clause) % original clause
  (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
  (c1:clause) % done
  (^#owned c2:clause) % todo
  (u3:{ (cl_valid nv c1) = tt })
  (u4:{ (cl_valid nv c2) = tt })
  (u2:{ (cl_subsume c (append c1 c2)) = tt })
  (u1:{ (all_lits_are_assigned vt c1) = tt })
  (u5:{ (cl_has_all_vars c1 vt) = tt })
  : #unique <check_clause_h_t nv c>.
  match c2 with
    nil _ =>
      abbrev p1_1 = [append_nil lit c1] in
      abbrev p1 = hypjoin (cl_subsume c c1) tt by u2 c2_eq p1_1 end in
      let c1_i = (inspect clause c1) in
      abbrev u3' = hypjoin (cl_valid nv c1_i) tt by u3 c1_i_eq end in
      let vt' = (clear_vars nv nv_ub vt c1_i u3') in
      abbrev u5' = hypjoin (cl_has_all_vars c1_i vt) tt by u5 c1_i_eq end in
      abbrev p2_1 = [cl_has_all_vars_implies_clear_vars_like_new nv nv_ub vt c1_i u3' u5'] in
      abbrev p2 = hypjoin vt' (uwarray_new (inc_nv nv nv_ub) UN) by p2_1 vt'_eq end in
      (check_clause_ok nv nv_ub c vt' p2 c1 p1 u3)
  | cons _ l c2' =>
      abbrev nv' = (inc_nv nv nv_ub) in
      let vti = (inspect_unique <uwarray assignment nv'> vt) in
      let vn = (lit_vnum (clone_owned lit l)) in
      abbrev p1 = [cl_valid_implies_lit_valid_head2 nv c2 l c2' u4 c2_eq] in
      abbrev p2 = [lit_valid_implies_ltword_inc_nv nv nv_ub l p1] in
      abbrev p2' = hypjoin (ltword vn nv') tt by p2 vn_eq end in
      abbrev u4' = [cl_valid_implies_cl_valid_tail2 nv c2 l c2' u4 c2_eq] in
      let a = (uwarray_get assignment nv' vti vn p2') in
      do
      (consume_unique_owned <uwarray assignment nv'> vti)
      match (is_assigned a) by q1 _ with
        ff =>
          let vt' = (uwarray_set assignment nv' vt vn (lit_assignment (clone_owned lit l)) p2') in
          let c1' = (cons lit (owned_to_unowned lit l) c1) in
					cabbrev u = hypjoin (is_assigned (uwarray_get vt (lit_vnum l))) ff by a_eq vti_eq vn_eq q1 end
          abbrev vt'_eq' = hypjoin vt' (uwarray_set vt (lit_vnum l) (lit_assignment l)) by vn_eq vt'_eq end in
          abbrev p3_1 = [all_lits_are_assigned_lem1 nv nv_ub vt vt' l u vt'_eq' c1 u1 u3] in
          abbrev p3 = hypjoin (all_lits_are_assigned vt' c1') tt by c1'_eq vt'_eq p3_1 vn_eq end in
          abbrev u3' = hypjoin (cl_valid nv c1') tt by c1'_eq p1 u3 end in
          abbrev p4_1_1 = hypjoin (cl_subsume c (append c1 (cons l c2'))) tt by c2_eq u2 end in
          abbrev p4_1 = [cl_subsume_append_cons1 c c1 c2' l p4_1_1] in
          abbrev p4 = hypjoin (cl_subsume c (append c1' c2')) tt by c1'_eq u2 p4_1 end in
          abbrev p6_1 = [cl_has_all_vars_add nv nv_ub vt vt' c1 l u5 vt'_eq'] in
          abbrev p6 = hypjoin (cl_has_all_vars c1' vt') tt by c1'_eq p6_1 end in
          (check_clause_h nv nv_ub c vt' c1' c2' u3' u4' p4 p3 p6)
      | tt =>
          abbrev s = (lit_sign l) in
          match (is_compat_assignment a s) by q2 _ with
            ff =>
              let c1_i = (inspect clause c1) in
              abbrev u3' = hypjoin (cl_valid nv c1_i) tt by u3 c1_i_eq end in
              let vt' = (clear_vars nv nv_ub vt c1_i u3') in
              abbrev u5' = hypjoin (cl_has_all_vars c1_i vt) tt by u5 c1_i_eq end in
              abbrev p2_1 = [cl_has_all_vars_implies_clear_vars_like_new nv nv_ub vt c1_i u3' u5'] in
              abbrev p2 = hypjoin vt' (uwarray_new (inc_nv nv nv_ub) UN) by p2_1 vt'_eq end in
              do
              (consume_unowned clause c1)
              (consume_owned clause c2')
              (check_clause_tautalogy nv nv_ub c vt' p2)
              end
          | tt => % duplicated lits
              abbrev p3_1_1 = hypjoin (cl_subsume c (append c1 (cons l c2'))) tt by c2_eq u2 end in
              abbrev p3_1_2 = [is_compat_assignment_lem1 a l q1 q2] in
              abbrev p3_1_3 = hypjoin (uwarray_get vt (lit_vnum l)) (lit_assignment l) by vti_eq a_eq p3_1_2 vn_eq end in
              abbrev p3_1_4 = [cl_has_all_vars_lem3 c1 nv nv_ub vt l u5 p3_1_3] in
              abbrev p3_1 = [cl_subsume_append_cons2 c c1 c2' l p3_1_1 p3_1_4] in
              abbrev p3 = hypjoin (cl_subsume c (append c1 c2')) tt by p3_1 end in
              (check_clause_h nv nv_ub c vt c1 c2' u3 u4' p3 u1 u5)
          end
      end
      end
  end
  .

Inductive check_clause_t : Fun(nv:word)(c:clause).type :=
  clause_empty : Fun(spec nv:word)(spec c:clause)
                    (nv_ub:{ (ltword nv var_upper_bound) = tt })
                    (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
                    (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
                    (u:{ (cl_subsume c nil) = tt })
                   .#unique <check_clause_t nv c>
| clause_tautology : Fun(spec nv:word)(spec c:clause)
                    (nv_ub:{ (ltword nv var_upper_bound) = tt })
                    (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
                    (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
                   .#unique <check_clause_t nv c>
| clause_unit : Fun(spec nv:word)(spec c:clause)
                    (nv_ub:{ (ltword nv var_upper_bound) = tt })
                    (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
                    (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
                    (l:lit)
                    (u1:{ (cl_subsume c (cons l nil)) = tt })
                    (u2:{ (cl_valid nv (cons l nil)) = tt })
                   .#unique <check_clause_t nv c>
| clause_other : Fun(spec nv:word)(spec c:clause)
                    (nv_ub:{ (ltword nv var_upper_bound) = tt })
                    (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
                    (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
                    (c':clause)
                    (u1:{ (cl_subsume c c') = tt })
                    (u2:{ (cl_valid nv c') = tt })
                   .#unique <check_clause_t nv c>
    % c' is supposed to be duplicatation-free, but not proven.
.

Define check_clause :=
  fun(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
     (^#owned c:clause)
     (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
     (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
  : #unique <check_clause_t nv c>.
  abbrev p1 = join (all_lits_are_assigned vt nil) tt in
  abbrev p2 = hypjoin (cl_subsume c (append nil c)) tt by [cl_subsume_refl c] end in
  abbrev p3 = hypjoin (cl_valid nv nil) tt by end in
  match (cl_valid nv (clone_owned clause c)) by p4 _ with
    ff => abort <check_clause_t nv c>
  | tt =>
  abbrev p4' = hypjoin (cl_valid nv c) tt by p4 end in
  abbrev p5 = [cl_has_all_vars_empty nv nv_ub vt vt_eq] in
  match (check_clause_h nv nv_ub c vt (nil lit) c p3 p4' p2 p1 p5) with
    check_clause_tautalogy _ _ _ vt' vt'_eq =>
      (clause_tautology nv c nv_ub vt' vt'_eq)
  | check_clause_ok _ _ _ vt' vt'_eq c' u2 u3 =>
      match (inc clause c') by c'_eq _ with
        nil _ => % c subsumes nil
          abbrev p4 = hypjoin (cl_subsume c nil) tt by u2 c'_eq end in
          do
          (consume_unowned clause c')
          (clause_empty nv c nv_ub vt' vt'_eq p4)
          end
      | cons _ l c'' =>
          match c'' with
            nil _ => % c' is unit
              abbrev p4 = hypjoin (cl_subsume c (cons l nil)) tt by u2 c'_eq c''_eq end in
              abbrev p5 = hypjoin (cl_valid nv (cons l nil)) tt by u3 c'_eq c''_eq end in
              do
              (consume_unowned clause c')
              (clause_unit nv c nv_ub vt' vt'_eq l p4 p5)
              end
          | cons _ _ _ =>
              do
              (consume_unowned lit l)
              (clause_other nv c nv_ub vt' vt'_eq c' u2 u3)
              end
          end
      end
  end
  end.


%=============================================================================
% assign unit clauses and detect contradiction
%=============================================================================

Define check_unit_clause :=
  fun(spec nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
     (spec n:word)(!#unique_owned la:<uwarray ulit n>)
		 (u:{ (array_in_bounds nv la) = tt })
     (l:ulit).
  cabbrev p2 = [array_in_bounds_implies_ltword_word0 nv n la u]
  let x1 = (uwarray_get ulit n la word0 p2) in
  match (eq_ulit x1 ulit_null) by q1 _ with
    ff =>
      match (eq_ulit x1 l) with
        ff => ff
      | tt =>
          % goal: (ltword 0x1 n) = tt
					cabbrev p3 = [aclause_lem3 nv nv_ub n la u x1 x1_eq q1]
          let x2 = (uwarray_get ulit n la 0x1 p3) in
          (eq_ulit x2 ulit_null)
      end
      
  | tt => % empty clause
      ff
  end.

Define check_unit_clause_lem : Forall
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(n:word)(la:<uwarray ulit n>)
  (u:{ (array_in_bounds nv la) = tt })
	(l:ulit)
	(r:{ (check_unit_clause la l) = tt })
	(c:clause)
	(u2:{ c = (to_cl la) })
	.{ c = (cons (to_lit l) nil) }
	:= foralli
	(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
	(n:word)(la:<uwarray ulit n>)
  (u:{ (array_in_bounds nv la) = tt })
	(l:ulit)
	(r:{ (check_unit_clause la l) = tt })
	(c:clause)
	(u2:{ c = (to_cl la) })
	.
	case la with
	| vecn _ =>
		% p1: (word_to_nat n) = Z
		cabbrev p1 = inj <vec ulit *> la_Eq
		% p2: (ltword word0 n) = tt
		cabbrev p2 = [array_in_bounds_implies_ltword_word0 nv n la u]
		contra
		trans symm p2
		trans hypjoin (ltword word0 n) ff by p1 end
		      clash ff tt
		{ c = (cons (to_lit l) nil) }
	| vecc _ n' x la' =>
		cabbrev p3 = hypjoin (vec_get la (word_to_nat word0)) x by la_eq end
		case (eq_ulit x ulit_null) by q1 _ with
		| ff =>
			case (eq_ulit x l) by q2 _ with
			| ff =>
				contra
				trans symm r
				trans hypjoin (check_unit_clause la l) ff by q1 q2 p3 end
							clash ff tt
				{ c = (cons (to_lit l) nil) }
			| tt =>
				case la' with
				| vecn _ =>
					cabbrev x_eq = hypjoin x (uwarray_get la word0) by p3 end
					cabbrev p4 = [aclause_lem3 nv nv_ub n la u x x_eq q1]
					% (word_to_nat n) = (S n')
					% n'_eq: n' = Z
					cabbrev p5_1 = inj <vec ** *> la_Eq
					cabbrev p5_2 = inj <vec ** *> la'_Eq
					cabbrev p5 = hypjoin (word_to_nat n) (S Z) by p5_1 p5_2 end
					contra
					trans symm p4
					trans hypjoin (ltword 0x1 n) ff by p5 end
								clash ff tt
					{ c = (cons (to_lit l) nil) }
				| vecc _ n'' x2 la'' =>
					cabbrev p4 = hypjoin (vec_get la (word_to_nat 0x1)) x2 by la_eq la'_eq end
					case (eq_ulit x2 ulit_null) by q3 _ with
					| ff =>
						contra
						trans symm r
						trans hypjoin (check_unit_clause la l) ff by q1 q2 q3 p3 p4 end
									clash ff tt
						{ c = (cons (to_lit l) nil) }
					| tt =>
						cabbrev p5 = [eq_ulit_eq x l q2]
						trans u2
									hypjoin (to_cl la) (cons (to_lit l) nil) by la_eq q1 la'_eq q3 p5 end
					end
				end
			end
		| tt =>
			contra
			trans symm r
			trans hypjoin (check_unit_clause la l) ff by q1 p3 end
						clash ff tt
			{ c = (cons (to_lit l) nil) }
		end
	end

Define contra_unit_clauses :
  Forall(l:lit). { (is_resolvent nil (cons (negated l) nil) (cons l nil) l) = tt }
  :=
  foralli(l:lit).
  abbrev c1 = (cons (negated l) nil) in
  abbrev c2 = (cons l nil) in
  abbrev u = [eq_lit_refl l] in
  abbrev u' = [eq_lit_refl (negated l)] in

  abbrev p1 = hypjoin (cl_has c1 (negated l)) tt by u' end in
  abbrev p2 = hypjoin (cl_has c2 l) tt by u end in
  abbrev p3 = hypjoin (cl_subsume (cl_erase c1 (negated l)) nil) tt by u' end in
  abbrev p4 = hypjoin (cl_subsume (cl_erase c2 l) nil) tt by u end in
  hypjoin (is_resolvent nil c1 c2 l) tt by p1 p2 p3 p4 end
  .

Inductive assign_unit_t : Fun(nv:word)(F:formula).type :=
  assign_unit_ok		: Fun
		(spec nv:word)(spec F:formula)
		(#unique as:<AssignState nv F>)
		(#unique ws:<WatchState nv F>)
		.#unique <assign_unit_t nv F>
| assign_unit_unsat : Fun
		(spec nv:word)(spec F:formula)
		(#unique as:<AssignState nv F>)
		(#unique ws:<WatchState nv F>)
		(spec p:<pf F (nil lit)>)
		.#unique <assign_unit_t nv F>
.

Define assignUnitClause :=
  fun(nv:word)(spec F:formula)
     (#unique as:<AssignState nv F>)
     (#unique ws:<WatchState nv F>)
     (^#owned l:lit)
     (u:{ (lit_valid nv l) = tt})
     (spec p:<pf F (cons lit l (nil lit))>)
    : #unique <assign_unit_t nv F>.
  match as with assign_state _ _ nv_ub pa why dls hist h_c h_e =>
  let v = (lit_vnum (clone_owned lit l)) in
  abbrev p1_1 = [lit_valid_implies_leword_nv nv l u] in
  abbrev p1_2 = hypjoin (leword v nv) tt by v_eq p1_1 end in
  abbrev p1 = [leword_nv_implies_ltword_inc_nv nv nv_ub v p1_2] in
  let pa' = (inspect_unique <uwarray assignment (inc_nv nv nv_ub)> pa) in
  let a = (uwarray_get assignment (inc_nv nv nv_ub) pa' v p1) in
  match a by q1 _ with
    default => % assigned => check consistency
      let s = (lit_sign (clone_owned lit l)) in
      match (is_compat_assignment a s) with
        ff => % conflicting => unsat
          let why' = (inspect_unique <warray <option <aclause nv F>> (inc_nv nv nv_ub)> why) in
					let ac2_opt = (warray_get <option <aclause nv F>> (inc_nv nv nv_ub) why' v p1) in
					match ac2_opt with
						nothing _ => abort <assign_unit_t nv F>
					| something _ ac2 =>
          match ac2 with mk_aclause n2 a2 _ _ u1_2 c2 pf_c2 u2 =>
          let neg_l = (negated l) in
          abbrev neg_l' = (inspect lit neg_l) in
          match (check_unit_clause nv nv_ub n2 a2 u1_2 (to_ulit neg_l')) by q3 _ with
            ff => abort <assign_unit_t nv F>
          | tt =>
          abbrev c1 = (cons lit l (nil lit)) in
          abbrev p'_1 = [check_unit_clause_lem nv nv_ub n2 a2 u1_2 (to_ulit neg_l') q3 c2 u2] in
          abbrev p'_2 = [to_lit_to_ulit_lem neg_l] in
          abbrev p' = hypjoin c2 (cons (negated l) nil) by p'_1 p'_2 neg_l_eq end in
          abbrev p''_1 = [contra_unit_clauses l] in
          abbrev p''_2 = trans cong (is_resolvent nil * c1 l) p'
                               p''_1
          in
          abbrev p'' = (pf_res F (nil lit) c2 c1 l pf_c2 p p''_2) in
          do
            (consume_unowned lit neg_l)
            (consume_unique_owned <uwarray ulit n2> a2)
            (consume_owned <aclause nv F> ac2)
            (consume_owned <option <aclause nv F>> ac2_opt)
						(consume_unique_owned <uwarray assignment (inc_nv nv nv_ub)> pa')
            (consume_unique_owned <warray <option <aclause nv F>> (inc_nv nv nv_ub)> why')
						let as' = (assign_state nv F nv_ub pa why dls hist h_c h_e) in
            (assign_unit_unsat nv F as' ws p'')
          end end end end

      | tt => % the same clause => ignore
					do 
						 (consume_unique_owned <uwarray assignment (inc_nv nv nv_ub)> pa')
             let as' = (assign_state nv F nv_ub pa why dls hist h_c h_e) in
             (assign_unit_ok nv F as' ws)
          end
      end

  | UN => % unassigned => assign
      % need to construct <aclause> object for run-time check
      let c = (cons lit (inc_owned lit l) (nil lit)) in
      abbrev c' = (inspect clause c) in
      abbrev u' = hypjoin (cl_valid nv c') tt by u c_eq end in
      abbrev p'_1 = hypjoin (cons lit l (nil lit)) c' by c_eq end in
      abbrev p' = cast p by cong <pf F *> p'_1 in
			let ac = (build_aclause nv F c' p' u') in

      % This hypjoin takes too long. And it's too tidious to make a lemma
      % with so many individual assumptions.
      % So, I'll check at runtime for now.
      %abbrev p2 = hypjoin (unassigned as'' (ulit_vnum x)) tt
      %							by as_eq as''_eq pa'_eq p1_1 a_eq q1 v_eq end in
      
      match (unassigned2 nv nv_ub pa' v p1_2) by q2 _ with
        ff => abort <assign_unit_t nv F>
      | tt =>
      let as'' = (assign_state nv F nv_ub pa why dls hist h_c h_e) in
      abbrev p2 = hypjoin (unassigned as'' (ulit_vnum (to_ulit l))) tt by v_eq q2 pa'_eq as''_eq as_eq end in
      let as' = (assign nv F as'' (to_ulit l) (something <aclause nv F> ac) word0 p2) in
      do
      (consume_unowned clause c)
      (assign_unit_ok nv F as' ws)
      end end
  end
  end.


%=============================================================================
% initialize solve's state with the input formula
% - checking formula and adding clauses to WatchState
%=============================================================================

Inductive init_t : Fun(nv:word)(F:formula).type :=
  init_ok : Fun(spec nv:word)
               (nv_ub:{ (ltword nv var_upper_bound) = tt })
               (spec F:formula)
               (#unique as:<AssignState nv F>)
							 (#unique ds:<DecisionState nv>)
               (#unique ws:<WatchState nv F>)
               (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
               (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
              .#unique <init_t nv F>
| init_unsat : Fun(spec nv:word)
                  (spec F:formula)
                  (spec p:<pf F (nil lit)>)
                .#unique <init_t nv F>
.

Define addClause :=
  fun(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
     (spec F:formula)
     (#unique as:<AssignState nv F>)
		 (#unique ds:<DecisionState nv>)
     (#unique ws:<WatchState nv F>)
     (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
     (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
     (^#owned c:clause)
     (u:{ (member c F eq_clause) = tt })
    : #unique <init_t nv F>.
  abbrev nv_ub = [assign_state_implies_nv_ub nv F as] in
  match (check_clause nv nv_ub c vt vt_eq) with
    clause_empty _ _ _ vt' vt'_eq u' =>
      abbrev p_1 = (pf_asm F c u) in
			abbrev p = (pf_sub F (nil lit) c p_1 u') in
      do
      (consume_unique <AssignState nv F> as)
      (consume_unique <DecisionState nv> ds)
      (consume_unique <WatchState nv F> ws)
      (consume_unique <uwarray assignment (inc_nv nv nv_ub)> vt')
      (init_unsat nv F p)
      end

  | clause_tautology _ _ _ vt' vt'_eq =>
      (init_ok nv nv_ub F as ds ws vt' vt'_eq)

  | clause_unit _ _ _ vt' vt'_eq l u1 u2 =>
      abbrev l' = (inspect lit l) in
      abbrev c' = (cons lit l' (nil lit)) in
      abbrev u1' = hypjoin (cl_subsume c c') tt by u1 end in
      abbrev p1 = hypjoin (lit_valid nv l') tt by
                    [cl_valid_implies_lit_valid_head nv l (nil lit) u2] end in
      abbrev p2_1 = (pf_asm F c u) in
			abbrev p2 = (pf_sub F c' c p2_1 u1') in
      match (assignUnitClause nv F as ws l' p1 p2) with
        assign_unit_ok _ _ as' ws' => 
          do
          (consume_unowned lit l)
          (init_ok nv nv_ub F as' ds ws' vt' vt'_eq)
          end
      | assign_unit_unsat _ _ as' ws' p =>
          do
          (consume_unowned lit l)
          (consume_unique <DecisionState nv> ds)
					(consume_unique <AssignState nv F> as')
					(consume_unique <WatchState nv F> ws')
          (consume_unique <uwarray assignment (inc_nv nv nv_ub)> vt')
          (init_unsat nv F p)
          end
      end

  | clause_other _ _ _ vt' vt'_eq c' u1 u2 =>
      abbrev c'' = (inspect clause c') in
      abbrev u1' = hypjoin (cl_subsume c c'') tt by u1 end in
      abbrev u2' = hypjoin (cl_valid nv c'') tt by u2 end in
			abbrev cp_1 = (pf_asm F c u) in
			abbrev cp = (pf_sub F c'' c cp_1 u1') in
			let ac = (build_aclause nv F c'' cp u2') in
			
			let aci = (inspect <aclause nv F> ac) in
			let ds' = (bumpActivity nv F ds aci) in % score lits
      do
      (consume_unowned clause c')
			(consume_owned <aclause nv F> aci)
      let ws' = (addInitialClause nv F ws ac) in
      (init_ok nv nv_ub F as ds' ws' vt' vt'_eq)
      end
  end.

Define addFormula :=
  fun addFormula(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
                (spec F:formula)
                (#unique as:<AssignState nv F>)
								(#unique ds:<DecisionState nv>)
                (#unique ws:<WatchState nv F>)
                (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
                (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
                (^#owned todo:formula)
                (u:{ (list_subset eq_clause todo F) = tt })
               : #unique <init_t nv F>.
  match todo with
    nil _ => (init_ok nv nv_ub F as ds ws vt vt_eq)
  | cons _ c todo' =>
      abbrev p1_1 = hypjoin (member c todo eq_clause) tt by todo_eq [eq_clause_refl c] end in
      abbrev p1 = [member_trans_lemma clause c
                    eq_clause eq_clause_total todo F
                    p1_1 u eq_clause_eq] in
      match (addClause nv nv_ub F as ds ws vt vt_eq c p1) with
        init_ok _ _ _ as' ds' ws' vt' vt'_eq =>
					% want p3: (list_subset todo' todo) = tt
					abbrev p3_1 = % (list_subset eq_clause (cons c todo') todo) = tt
						trans cong (list_subset eq_clause * todo) symm todo_eq
									[list_subset_refl clause eq_clause eq_clause_total eq_clause_refl
										todo]
					in
					abbrev p3 = [list_subset_cons_tt_tail clause eq_clause
												c todo' todo p3_1] in
					abbrev p4 =
						% want: (list_subset eq_clause todo' F) = tt
						% have p3: (list_subset eq_clause todo' todo) = tt
						% have u: (list_subset eq_clause todo F) = tt
						[list_transitivity clause eq_clause eq_clause_total
							todo' todo F p3 u eq_clause_refl eq_clause_eq]
					in
          (addFormula nv nv_ub F as' ds' ws' vt' vt'_eq todo' p4)

      | init_unsat _ _ p =>
          do
            (consume_owned formula todo')
            (init_unsat nv F p)
          end
      end
  end.

Define insertAllVars_h := fun insertAllVars_h
  (nv:word)
  (#unique ds:<DecisionState nv>)
  (v:word)
  :#unique <DecisionState nv>.
	match (leword v nv) by q1 _ with
	  ff => ds
	| tt =>
		let ds' = (insertVarOrder nv ds v q1) in
		let v' = (word_inc2 v) in
		(insertAllVars_h nv ds' v')
  end.

Define insertAllVars := fun
  (nv:word)
  (#unique ds:<DecisionState nv>)
  :#unique <DecisionState nv>.
	(insertAllVars_h nv ds word1).

Define initState :=
  fun(nv:word)
     (nv_ub:{ (ltword nv var_upper_bound) = tt })
     (!f:formula)
    : #unique <init_t nv f>.
  let f' = (inspect formula f) in
  let as = (newAssignState nv f' nv_ub) in
	let ds = (newDecisionState nv nv_ub) in
  let ws = (newWatchState nv f' nv_ub) in
  let vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) in
  abbrev u = [list_subset_refl clause eq_clause eq_clause_total eq_clause_refl f'] in
	let rval =
		match (addFormula nv nv_ub f' as ds ws vt vt_eq f' u) with
			init_ok _ _ _ as ds ws vt vt_eq =>
				let	ds' = (insertAllVars nv ds) in
				(init_ok nv nv_ub f' as ds' ws vt vt_eq)
		| init_unsat _ _ p => (init_unsat nv f' p)
		end in
  cast rval by cong <init_t nv *> hypjoin f' f by f'_eq end
  .
