Include trusted "cnf.g".

Define ulitToString := fun(l:ulit).
	match (ulit_sign l) with
		ff => (ucons char '-' (word_num_to_string l))
	|	tt => (word_num_to_string (ulit_vnum l))
	end.

Define ownedLitToString := fun(^#owned l:lit).(ulitToString (to_ulit l)).

Define litToString := fun(^l:lit).
	match l with mk_uholder _ x =>
	(ulitToString x)
	end.

Define ownedClauseToString := fun ownedClauseToString
  (^#owned c:clause)
  : string.
  match c with
		nil _ => (inc string stringn)
	| cons _ l c' =>
			let s = (ownedLitToString l) in
			(string_app1 s (string_app1 " " (ownedClauseToString c')))
  end.

Define ownedClauseToString' := fun(!#owned c:clause).
  (ownedClauseToString (clone_owned clause c)).

Define clauseToString := fun(^c:clause).
  let rval = (ownedClauseToString (inspect clause c)) in
	do
	(consume_unowned clause c)
	rval
	end.

Define clauseToString' := fun(!c:clause).
  (ownedClauseToString (inspect clause c)).
