%=============================================================================
% conflict.g : conflict analysis to derivie a conflict clauses
%=============================================================================
Include trusted "decision.g".
Include trusted "resolution.g".

%=============================================================================
% la_has_lit ("la_" means literal-array)
%=============================================================================
                  
Define _la_has_lit_h := fun _la_has_lit_h
	(spec nv:word)
	(spec n:word)(^#unique_owned la:<uwarray ulit n>)
	(l:ulit)
	(i:word)
	(u:{ (array_in_bounds nv (vec_nth_tail la (to_nat i))) = tt })
	: bool.
  % need: (ltword i n) = tt
  cabbrev p1 = [nth_tail_in_bounds_implies_ltword nv n la i u]
  let x = (uwarray_get ulit n la i p1) in
  match (eq_ulit x ulit_null) by q1 Q1 with
  | ff => % do more
			match (eq_ulit l x) with
			| ff =>
				abbrev p2 = [ltword_implies_ltword_word_max i n p1] in
				let i' = (word_inc_safe i p2) in
				abbrev p3 = [nth_tail_in_bounds_the_rest nv n la i i' x u i'_eq x_eq q1] in
				(_la_has_lit_h nv n la l i' p3)
			| tt => tt
			end
  | tt => % done
      ff
  end

Define la_has_lit := 
  fun(spec nv:word)
     (spec n:word)(^#unique_owned la:<uwarray ulit n>)
     (u:{ (array_in_bounds nv la) = tt })
     (l:ulit).
  abbrev u' = hypjoin (array_in_bounds nv (vec_nth_tail la (to_nat word0))) tt by u end
	(_la_has_lit_h nv n la l word0 u')

Define la_has_lit_lem2_h : Forall
	(nv:word)
	(n:nat)(n_ub:{ (le n (to_nat word_max)) = tt })
	(la:<vec ulit n>)
	(l:ulit)
	(i:word)
	(u1:{ (array_in_bounds nv (vec_nth_tail la (to_nat i))) = tt })
	(u2:{ (_la_has_lit_h la l i) = tt })
	.{ (cl_has (to_cl (vec_nth_tail la (to_nat i))) (to_lit l)) = tt }
  := foralli
	(nv:word)
	(n:nat)(n_ub:{ (le n (to_nat word_max)) = tt })
	(la:<vec ulit n>)
	(l:ulit)
	(i:word)
	(u1:{ (array_in_bounds nv (vec_nth_tail la (to_nat i))) = tt })
	(u2:{ (_la_has_lit_h la l i) = tt })
	.
	cabbrev j = (minus n (word_to_nat i))
	cabbrev p1_1 = [nth_tail_in_bounds_implies_lt nv n la (word_to_nat i) u1]
	cabbrev p1 = [lt_implies_le (word_to_nat i) n p1_1]
	cabbrev i_eq = symm [minus_minus n (word_to_nat i) p1]	% j_eq
	[
	induction(j:nat) return Forall	% j is the size of remainder
		(i:word)
		(i_eq:{ (to_nat i) = (minus n j) })	
		(u1:{ (array_in_bounds nv (vec_nth_tail la (to_nat i))) = tt })
		(u2:{ (_la_has_lit_h la l i) = tt })
		.{ (cl_has (to_cl (vec_nth_tail la (to_nat i))) (to_lit l)) = tt }
	with
	| Z => foralli
		(i:word)
		(i_eq:{ (to_nat i) = (minus n j) })	
		(u1:{ (array_in_bounds nv (vec_nth_tail la (to_nat i))) = tt })
		(u2:{ (_la_has_lit_h la l i) = tt })
		.
		cabbrev p1 = hypjoin (minus n j) n by j_eq end
		cabbrev p2 = [vec_nth_tail_last ulit n la]
		contra
		trans symm u1
		trans hypjoin (array_in_bounds nv (vec_nth_tail la (to_nat i))) ff by i_eq p1 p2 end
					clash ff tt
		{ (cl_has (to_cl (vec_nth_tail la (to_nat i))) (to_lit l)) = tt }
		
	| S j' => foralli
		(i:word)
		(i_eq:{ (to_nat i) = (minus n j) })	
		(u1:{ (array_in_bounds nv (vec_nth_tail la (to_nat i))) = tt })
		(u2:{ (_la_has_lit_h la l i) = tt })
		.
		cabbrev p1 = [minus_le n j (word_to_nat i) symm i_eq]	% (le (to_nat i) n) = tt
		cabbrev t = (vec_nth_tail ulit n la (word_to_nat i) p1)
		case t with
		| vecn _ =>
			cabbrev p2_1 = inj <vec ** *> t_Eq	% (minus n (to_nat i)) = Z
			cabbrev p2_2 = [minus_eq_Z n (word_to_nat i) p2_1]	% n = (to_nat i)
			cabbrev p2_3 = hypjoin (minus n j) n by p2_2 i_eq end
			cabbrev p2 = [a_minus_b_eq_a n j p2_3]	% j = Z
			contra
			trans symm p2
			trans j_eq
						clash (S j') Z
			{ (cl_has (to_cl (vec_nth_tail la (to_nat i))) (to_lit l)) = tt }

		| vecc _ k x t' =>
			cabbrev r1 = [minus_le2 n j (word_to_nat i) symm i_eq]	% (le j n) = tt

			% p2: (lt j' n) = tt
			cabbrev p2_1 = hypjoin (le (S j') n) tt by r1 j_eq end
			cabbrev p2 = [le_S_lt j' n p2_1]
			
			% p3: (lt Z j) = tt
			cabbrev p3 = hypjoin (lt Z j) tt by j_eq end
			
			% p4: (ltword i word_max) = tt
			cabbrev p4_1 = [array_bounds_nth_tail_implies_lt nv n la (word_to_nat i) u1]
			cabbrev p4_2 = [ltle_trans (word_to_nat i) n (word_to_nat word_max) p4_1 n_ub]
			cabbrev p4 = trans [ltword_to_lt i word_max] p4_2
			cabbrev i' = (word_inc_safe i p4)

			cabbrev p5 = [word_inc_safe_word_to_nat i p4]
			cabbrev p6_1 = inj <vec ** *> t_Eq	% (minus n i) = (S k)
			cabbrev p6_2 = [minus_S_lt n (word_to_nat i) k p6_1]
			cabbrev p6 = [vec_nth_tail_eq ulit n (word_to_nat i) la p6_2]
			cabbrev p7 = hypjoin (vecc (vec_get la (to_nat i)) (vec_nth_tail la (S (to_nat i)))) (vecc x t') by t_eq p6 end
			cabbrev p8_1 = inj (vecc ** *) p7
			cabbrev p8_2 = inj (vecc * **) p7
			cabbrev p8 = hypjoin (vec_nth_tail la (to_nat i')) t' by p5 p8_1 end
			cabbrev p8' = hypjoin (vec_get la (to_nat i)) x by p5 p8_2 end
			
			cabbrev p9 = hypjoin (array_in_bounds nv (vecc x t')) tt by t_eq u1 end
			case (eq_ulit x ulit_null) by q1 _ with
			| ff =>
				% subgoals
				% u1':{ (array_in_bounds nv (vec_nth_tail la (to_nat i'))) = tt })
				% u2':{ (_la_has_lit_h la l i') = tt })
				cabbrev p10 = [array_in_bounds_tail nv k x t' p9 q1]
				cabbrev u1' = hypjoin (array_in_bounds nv (vec_nth_tail la (to_nat i'))) tt by p10 p8 end
				cabbrev p11 = hypjoin (array_in_bounds nv t') tt by u1' p8 end
				existse [to_cl_total' nv k t' p11]
				foralli(c':clause)(c'_pf:{ (to_cl t') = c' })
				.
				case (eq_ulit l x) by q2 _ with
				| ff =>
					cabbrev u2' = hypjoin (_la_has_lit_h la l i') tt by u2 p8' q1 q2 end
					% p11: (to_nat i') = (minus n j')
					% need: (minus n j') = (S (minus n j)) = (S (to_nat i))
					cabbrev r'_1 = [minusS2 n j' p2]
					cabbrev r' = hypjoin (to_nat i') (minus n j') by r'_1 p5 i_eq j_eq end
					cabbrev ih = [j_IH j' i' r' u1' u2']
					cabbrev p12 = hypjoin (cl_has c' (to_lit l)) tt by p8 ih c'_pf end
					cabbrev p13 = [cl_has_tt_cons c' (to_lit l) (to_lit x) p12]
					hypjoin (cl_has (to_cl t) (to_lit l)) tt by p13 t_eq c'_pf q1 end
				| tt =>
					cabbrev p12 = hypjoin (to_cl t) (cons (to_lit x) (to_cl t')) by t_eq q1 end
					cabbrev p13 = [eq_ulit_eq l x q2]
					cabbrev p14 = [eq_lit_refl (to_lit x)]
					hypjoin (cl_has (to_cl t) (to_lit l)) tt by p12 p13 p14 end
				end
			| tt =>
				contra
				trans symm u2
				trans hypjoin (_la_has_lit_h la l i) ff by q1 p8' end
							clash ff tt
				{ (cl_has (to_cl t) (to_lit l)) = tt }
			end
		end
	end
	j i i_eq u1 u2]

Define la_has_lit_lem2 :
  Forall(nv:word)
        (n:word)(la:<uwarray ulit n>)
        (u:{ (array_in_bounds nv la) = tt })
        (l:ulit)
        (c:clause)(c_eq:{ c = (to_cl la) })
        (u2:{ (la_has_lit la l) = tt }).
    { (cl_has c (to_lit l)) = tt }
  := foralli
	(nv:word)
	(n:word)(la:<uwarray ulit n>)
	(u:{ (array_in_bounds nv la) = tt })
	(l:ulit)
	(c:clause)(c_eq:{ c = (to_cl la) })
	(u2:{ (la_has_lit la l) = tt })
	.
	cabbrev n_ub = trans symm [leword_to_le n word_max] [leword_word_max n]
	cabbrev q1 = hypjoin (array_in_bounds nv (vec_nth_tail la (to_nat word0))) tt by u end
	cabbrev q2 = hypjoin (_la_has_lit_h la l word0) tt by u2 end
	cabbrev p = [la_has_lit_lem2_h nv (word_to_nat n) n_ub la l word0 q1 q2]
	hypjoin (cl_has c (to_lit l)) tt by p c_eq end


%=============================================================================
% derivation loop
%=============================================================================

% state for conflict analysis
Inductive DeriveReturn_h : Fun(nv:word)(F:formula).type :=
  derive_return_h : Fun (spec nv:word)(spec F:formula)
                        (nv_ub:{ (ltword nv var_upper_bound) = tt })
												(#unique ds:<DecisionState nv>)
                        (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
                        (c:clause)
                        (u2:{ (all_lits_are_assigned vt c) = tt })
                        (u3:{ (cl_has_all_vars c vt) = tt })
                        (spec rsp:<pf F c>)
                        (rsv:{ (cl_valid nv c) = tt })
                        (uip:lit)
                    . #unique <DeriveReturn_h nv F>
.

Define derive_h :=
  fun derive_h(nv:word)(spec F:formula)
              (nv_ub:{ (ltword nv var_upper_bound) = tt })
              (dl:word)
              (^#unique_owned why:<warray <option <aclause nv F>> (inc_nv nv nv_ub)>)
              (^#unique_owned dls:<uwarray word (inc_nv nv nv_ub)>)
              (^#unique_owned hist:<uwarray ulit nv>)
              (hist_pt:word)
							(#unique ds:<DecisionState nv>)
              (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
              (c1:clause)       % lits set below the current level
              (spec c2:clause)  % lits set at the current level
              (c2l:nat)
              (u1:{ c2l = (length c2) })
              (u2:{ (all_lits_are_assigned vt (append c2 c1)) = tt })
              (u3:{ (cl_has_all_vars (append c2 c1) vt) = tt })
              (u4:{ (cl_unique c2) = tt })
              (u5:{ (cl_set_at_prev_levels dl dls c1) = tt })
              (u6:{ (cl_valid nv c1) = tt })
              (u7:{ (cl_valid nv c2) = tt })
              (spec ccp:<pf F (append lit c2 c1)>)
            : #unique <DeriveReturn_h nv F>.
  let c2li = (inspect nat c2l) in
  match c2li by c2l_eq _ with
    Z => % Probably got an empty conflict clause (ignore the returning lit)
         % This can happen when deriving at decision level 0. (UNSAT)
      abbrev p1_1 = hypjoin (length c2) Z by u1 c2l_eq c2li_eq end in
      abbrev p1_2 = [length_eq_Z lit c2 p1_1] in
      abbrev p1_3 = [append_nil lit c1] in
      abbrev p1 = hypjoin (append c2 c1) c1 by p1_2 p1_3 end in
      abbrev ccp' = cast ccp by cong <pf F *> p1 in
      abbrev u2' = hypjoin (all_lits_are_assigned vt c1) tt by u2 p1 end in
      abbrev u3' = hypjoin (cl_has_all_vars c1 vt) tt by u3 p1 end in
      do
      (consume_owned nat c2li)
      (consume_unowned nat c2l)
      (derive_return_h nv F nv_ub ds vt c1 u2' u3' ccp' u6 (inc lit lit_null))
      end

  | S c2l' =>
      abbrev c2l_eq = hypjoin c2l (S c2l') by c2l_eq c2li_eq end in
      abbrev nv' = (inc_nv nv nv_ub) in

      match (ltword word0 hist_pt) by q1 _ with ff => abort <DeriveReturn_h nv F> | tt =>
      let hist_pt' = (word_dec_safe hist_pt q1) in
      match (ltword hist_pt' nv) by q2 _ with ff => abort <DeriveReturn_h nv F> | tt =>
      let l = (uwarray_get ulit nv hist hist_pt' q2) in
      let l' = (to_lit l) in
      let neg_l' = (negated (inspect lit l')) in
      let vti = (inspect_unique <uwarray assignment nv'> vt) in
      let v = (ulit_vnum l) in

      % STEP 1. look at the last assignment and see if it's in c2
      % [assert] hist members are supposed to be valid
      match (ltword v nv') by q3 _ with ff => abort <DeriveReturn_h nv F> | tt =>
      let a = (uwarray_get assignment nv' vti v q3) in
      
      do
      (consume_unique_owned <uwarray assignment nv'> vti)
      match (is_equal_assignment a (lit_sign (inspect lit neg_l'))) by q4 _ with
        ff => % the current cc does not have -l => try the previous lit assigned
          do
            (consume_unowned lit neg_l')
            (consume_unowned lit l')
            (consume_owned nat c2l')
            (consume_owned nat c2li)
            (derive_h nv F nv_ub dl why dls hist hist_pt' ds vt c1 c2 c2l u1 u2 u3 u4 u5 u6 u7 ccp)
          end
      | tt => % yes, c2 has neg_l'
          abbrev q4 = hypjoin (is_equal_assignment a (lit_sign neg_l')) tt by q4 end in
          let v_dl = (uwarray_get word nv' dls v q3) in
          % [assert] l is set at the current level
          match (not (ltword v_dl dl)) by q6 _ with ff => abort <DeriveReturn_h nv F> | tt =>
          abbrev q6 = [not_tt (ltword v_dl dl) q6] in
          
          abbrev r2 = hypjoin (ltword (uwarray_get dls (ulit_vnum l)) dl) ff by v_dl_eq v_eq q6 end in
          abbrev r3_1 = [is_equal_assignment_lem2 a neg_l' q4] in
          abbrev r3_2 = [unegated_ulit_assignment_eq_negated_lit_assignment l] in
          abbrev r3 = trans hypjoin (uwarray_get vt (ulit_vnum l)) a by vti_eq v_eq a_eq end
                            hypjoin a (ulit_assignment (unegated l)) by l'_eq neg_l'_eq r3_1 r3_2 end in

          abbrev cc = (append lit c2 c1) in
          abbrev p2_1 = [ulit_vnum_eq_to_lit_negated_lit_vnum l] in
          abbrev p2_2 = hypjoin (lit_vnum neg_l') (ulit_vnum l) by p2_1 neg_l'_eq l'_eq end in
          abbrev p2_3 = hypjoin (uwarray_get vt (lit_vnum neg_l')) (lit_assignment neg_l') by p2_2 r3_1 vti_eq v_eq a_eq end in
          abbrev p2_4 = [cl_has_all_vars_lem3 cc nv nv_ub vt neg_l' u3 p2_3] in
          abbrev p2 = hypjoin (cl_has cc (negated (to_lit l))) tt by p2_4 neg_l'_eq l'_eq end in

          abbrev r1 = hypjoin (lt Z c2l) tt by c2l_eq end in
            
          % now, check if neg_l' is the UIP
          let z = (inc nat zero) in
          match (and (eqnat (inspect nat z) c2l') (ltword word0 dl)) by q5 _ with
            ff => % no UIP literal (or at level zero) => do a resolution
              abbrev q5 = hypjoin (and (eqnat Z c2l') (ltword word0 dl)) ff by q5 z_eq end in
              let reason = (warray_get <option <aclause nv F>> nv' why v q3) in
              match reason with nothing _ => abort <DeriveReturn_h nv F> | something _ ac =>
							let ds' = (bumpActivity nv F ds ac) in
              match ac with mk_aclause ac_n ac_l _ _ ac_ib ac_c ac_cp ac_ceq =>
              
              % [assert] ac should have l (ac is the reason of l)
              abbrev ac_ib' = hypjoin (array_in_bounds nv (clone_unique_owned <uwarray ulit ac_n> ac_l)) tt by ac_ib end in
              match (la_has_lit nv ac_n (clone_unique_owned <uwarray ulit ac_n> ac_l) ac_ib' l) by q5 ign with ff => abort <DeriveReturn_h nv F> | tt =>

              do
              (consume_owned nat c2li)
              abbrev rs = (resolve nv nv_ub dl dls vt c1 c2 c2l u1 u2 u3 u4 u5 u6 u7 ac_n ac_l l ac_c ac_ceq r1 r2 r3 ac_ib) in
              match rs with res_state _ _ _ _ vt' _ _ c1' c2' c2l' rsp_1 rsp_2 u1' u2' u3' u4' u5' u6' u7' =>
              
              abbrev q5' = hypjoin (la_has_lit ac_l l) tt by q5 end in
              abbrev p3 = [la_has_lit_lem2 nv ac_n ac_l ac_ib l ac_c ac_ceq q5'] in

              abbrev cc' = (append lit c2' c1') in
              abbrev p4 = hypjoin (is_resolvent cc' cc ac_c (to_lit l)) tt by p2 p3 rsp_1 rsp_2 end in
              abbrev ccp' = (pf_res F cc' cc ac_c (to_lit l) ccp ac_cp p4) in
              do
                (consume_unowned lit neg_l')
                (consume_unowned lit l')
                (consume_unowned nat z)
                (consume_unique_owned <uwarray ulit ac_n> ac_l)
                (consume_owned <aclause nv F> ac)
                (consume_owned <option <aclause nv F>> reason)
                (derive_h nv F nv_ub dl why dls hist hist_pt' ds' vt' c1' c2' c2l' u1' u2' u3' u4' u5' u6' u7' ccp')
              end
              end
              end end end end
          | tt => % found a UIP literal
              abbrev q5 = hypjoin (and (eqnat Z c2l') (ltword word0 dl)) tt by q5 z_eq end in
              % goal: c2 is neg_l'
              % have: cc has neg_l'
              abbrev q5' = [andtt_e1 (eqnat Z c2l') (ltword word0 dl) q5] in
              abbrev c2l'_Z = [eqnatEq Z c2l' q5'] in % Z = c2l'
              abbrev c2_len = hypjoin (length c2) (S Z) by u1 c2l_eq c2l'_Z end in
              % have p2_2: (lit_vnum neg_l') = (ulit_num l)
              abbrev p3_1 = hypjoin (ltword (uwarray_get dls (lit_vnum neg_l')) dl) ff by r2 p2_2 end in
              abbrev p3 = [cl_set_at_prev_levels_lem1 nv nv_ub dl dls c1 neg_l' u6 u5 p3_1] in
              % have p2_4: (cl_has cc neg_l') = tt
              abbrev p4_1 = [member_or_append lit eq_lit eq_lit_total neg_l' c2 c1] in
              abbrev p4_2 = [or_def2ff (cl_has c2 neg_l')] in
              abbrev p4 = hypjoin (cl_has c2 neg_l') tt by p2_4 p3 p4_1 p4_2 end in
              abbrev c2_eq = [cl_length_one_has_lit c2 neg_l' c2_len p4] in
              
              abbrev cc' = (cons lit (inc lit neg_l') c1) in
              abbrev cc'_eq = hypjoin cc' (append c2 c1) by c2_eq end in
              abbrev u2' = hypjoin (all_lits_are_assigned vt cc') tt by u2 c2_eq end in
              abbrev u3' = hypjoin (cl_has_all_vars cc' vt) tt by u3 c2_eq end in
              abbrev ccp' = cast ccp by cong <pf F *> symm cc'_eq in
              abbrev ccv'_1 = [cl_valid_append nv c2 c1 u7 u6] in
              abbrev ccv' = hypjoin (cl_valid nv cc') tt by ccv'_1 cc'_eq end in
              do
                (consume_unowned lit l')
                (consume_unowned nat z)
                (consume_owned nat c2li)
                (consume_unowned nat c2l)
                (derive_return_h nv F nv_ub ds vt cc' u2' u3' ccp' ccv' neg_l')
              end
          end % (and (eqnat (inspect nat Z) (inspect nat c2l')) (ltword word0 dl))
          end
      end % (is_equal_assignment a (lit_sign (inspect lit neg_l')))
      end % do
      end end end
  end.


%=============================================================================
% derive (front-end)
%=============================================================================

Define calcLevel_h :=
  fun calcLevel_h(spec nv:word)(spec F:formula)
     (nv_ub:{ (ltword nv var_upper_bound) = tt })
  	 (!#unique_owned dls:<uwarray word (inc_nv nv nv_ub)>)
     (^#owned cc:clause)
     (ccv:{ (cl_valid nv cc) = tt })
     (^#owned uip:lit)
     (lev:word)
    : word.
  match cc with
    nil _ => lev
  | cons _ l cc' =>
      abbrev p1 = [cl_valid_implies_lit_valid_head2 nv cc l cc' ccv cc_eq] in
      abbrev p2 = [cl_valid_implies_cl_valid_tail2 nv cc l cc' ccv cc_eq] in
      match (eq_lit (clone_owned lit uip) (clone_owned lit l)) with
        ff => % check level
          let vn = (lit_vnum l) in
          abbrev p3 = hypjoin (ltword vn (inc_nv nv)) tt by vn_eq
                        [lit_valid_implies_ltword_inc_nv nv nv_ub l p1] end in
        	let l_dl = (uwarray_get word (inc_nv nv nv_ub) dls vn p3) in
        	match (ltword lev l_dl) with
        	  ff => (calcLevel_h nv F nv_ub dls cc' p2 uip lev)
        	| tt => (calcLevel_h nv F nv_ub dls cc' p2 uip l_dl)
        	end
      | tt => % ignore
          (calcLevel_h nv F nv_ub dls cc' p2 uip lev)
      end
  end.

Define calcLevel :=
  fun(spec nv:word)(spec F:formula)
  	 (^#unique_owned as:<AssignState nv F>)
     (^#owned cc:clause)
     (ccv:{ (cl_valid nv cc) = tt })
     (^#owned uip:lit)
  .
  match as with assign_state _ _ nv_ub pa why dls hist hist_cur hist_end =>
  (calcLevel_h nv F nv_ub dls cc ccv uip word0)
  end.

Inductive DeriveReturn : Fun(nv:word)(F:formula).type :=
  derive_return : Fun(spec nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
										 (#unique ds:<DecisionState nv>)
                     (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
                     (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
                     (spec F:formula)
                     (cc:<aclause nv F>)
                     (uip:lit)
                     (new_dl:word)
                    .#unique <DeriveReturn nv F>
.

Define derive :=
  fun(nv:word)(nv_ub:{ (ltword nv var_upper_bound) = tt })
     (spec F:formula)
     (!#unique as:<AssignState nv F>)
     (dl:word)
		 (#unique ds:<DecisionState nv>)
     (#unique vt:<uwarray assignment (inc_nv nv nv_ub)>)
     (vt_eq:{ vt = (uwarray_new assignment (inc_nv nv nv_ub) UN) })
     (^#owned ac:<aclause nv F>)
    : #unique <DeriveReturn nv F>.
  let asi = (inspect_unique <AssignState nv F> as) in
  match !asi with assign_state _ _ _ _ why dls hist _ hist_end =>
  match !ac with mk_aclause n l _ _ u1 ac' acp ac_eq =>
  abbrev nv' = (inc_nv nv nv_ub) in
  abbrev rs = (init_res nv nv_ub dl dls vt vt_eq n l u1 ac' ac_eq) in
  match rs with res_state _ _ _ _ vt' _ _ c1 c2 c2l rsp_1 _ u1 u2 u3 u4 u5 u6 u7 =>
  abbrev rsp = (pf_sub F (append lit c2 c1) ac' acp rsp_1) in
    
  let dr = (derive_h nv F nv_ub dl why dls hist hist_end ds vt' c1 c2 c2l u1 u2 u3 u4 u5 u6 u7 rsp) in
  match dr with derive_return_h _ _ _ ds' vt cc u2 u3 ccp ccv uip =>

  abbrev ccp' = cast ccp by cong <pf F *> join cc (inspect cc) in
  abbrev ccv' = hypjoin (cl_valid nv (inspect cc)) tt by ccv end in
  let ac_new = (build_aclause nv F (inspect clause cc) ccp' ccv') in
	
  let new_dl = (calcLevel nv F asi (inspect clause cc) ccv' (inspect lit uip)) in

	let ac_newi = (inspect <aclause nv F> ac_new) in
	let ds'' = (bumpActivity nv F ds' ac_newi) in

  let vt'' = (clear_vars nv nv_ub vt (inspect clause cc) ccv') in
  abbrev vt''_eq_1 = [cl_has_all_vars_implies_clear_vars_like_new nv nv_ub vt cc ccv u3] in
  abbrev vt''_eq = hypjoin vt'' (uwarray_new nv' UN) by vt''_eq_1 vt''_eq end in
  do
	(consume_unowned clause cc)
	(consume_owned <aclause nv F> ac_newi)
	(derive_return nv nv_ub ds'' vt'' vt''_eq F ac_new uip new_dl)
  end
  end end end end
  .
