%=============================================================================
% cnf.g
% - defines the array-based clause data structure for efficient implementation
%   and the interpretation of it as a list-based clause
%=============================================================================
Include trusted "pf.g".

%=============================================================================
% Defining the interpretation of an array as a clause
%=============================================================================

% ulit : untracked-resource-type version of lit
Define ulit := word.

Define to_lit := boxWord.
Define to_ulit :=
  fun(^#owned l:lit).
  match l with mk_uholder _ w =>
    cast w by symm inj <uholder *> l_Eq
  end.

Define eq_ulit := eqword.
Define ulit_null := word0.
Define ulit_sign := word_read_msb.
Define ulit_vnum := word_clear_msb.

Define unegated :=
  fun(l:ulit).
    match (word_read_msb l) with
      ff => (word_set_msb l)
    | tt => (word_clear_msb l)
    end.

Define array_in_bounds :=
  fun array_in_bounds(nv:word)(spec n:nat)(c:<vec ulit n>): bool.
  match c with
  | vecn _ => ff
  | vecc _ n' l c' =>
		match (eq_ulit l ulit_null) with
		| ff =>
			cabbrev v = (ulit_vnum l)
			match (ltword word0 v) with
			| ff => ff
			| tt =>
				match (leword v nv) with
				| ff => ff
				| tt => (array_in_bounds nv n' c')
				end
			end
		| tt => tt
		end
  end

Define to_cl :=
  fun to_cl(spec n:nat)(c:<vec ulit n>): clause.
  match c with
    vecn _ => abort clause
  | vecc _ n' l c' =>
      match (eq_ulit l ulit_null) with
        ff =>
          (cons lit (to_lit l) (to_cl n' c'))
      | tt => (nil lit)
      end
  end.


%=============================================================================
% array-based clause with invariants
%=============================================================================

Inductive aclause : Fun(nv:word)(F:formula).type :=
  mk_aclause : Fun(spec n:word)(#unique l:<uwarray ulit n>)
                  (spec nv:word)(spec F:formula)
                  (u1:{ (array_in_bounds nv l) = tt })  % for bounds checking
                  (spec c:clause)(spec pf_c:<pf F c>)
                  (u2:{ c = (to_cl l) })
                 .<aclause nv F>
