open Grammar;;
open Trie;;

let symbol_var_name (s,b) = s;;

let symbol_ctor_name (s:string) = s;;

let numbered xs =
		let n = ref 0 in
	List.map (fun x -> n := !n+1; (x,!n)) xs;;

let starts_with_nonterminal ss = 
	match ss with
		[] -> false
		| s::ss' -> (not (is_terminal s));;

let svn_pos ss s = 
	let n = ref 0 in 
	let n' = ref 0 in 
	if(not(starts_with_nonterminal ss)) then (incr n);
	List.iter(fun s' ->
		incr n;
		if((symbol_var_name s') = symbol_var_name (s,false)) then (n' := !n);
	) ss; !n';;

let starts_with sub' st = 
	let sub_ln = String.length sub' in
	if(sub_ln > String.length st) then (false)
	else (
		if(String.sub st 0 sub_ln = sub') then (true)
	else (false)
);;

let dump_nm = "eq_";;

let rec dump_mlcf_eq (g:grammar) = 
	match g with Grammar(name,_,_,ps,_,t,_) ->
		let ofile = (open_out (name ^ "_eq.ml")) in
		let os = output_string ofile in
		let n = ref "" in
		let num_same_nonterm = ref 1 in
		os "(* auto-generated by gt *)\n\n";
		os "open ";
		os (String.capitalize name);
		os "_syntax;;\n\n";
		os "let rec dummy () = () ";
 

		List.iter (fun (Production(c,s,ss)) -> 
			if (s <> !n) then (
				if (!num_same_nonterm > 1) then os "\n   | _ -> false\n";
				num_same_nonterm := 1;
				n := s;
				os "\nand ";
				os ("eq_" ^ (symbol_var_name (s,false)));
				os " = function "
			)
			else incr num_same_nonterm; os "\n   |";

			let ss' = if((starts_with "List_Left" (symbol_ctor_name c))) then (List.rev (numbered ss)) else (numbered ss) in
			let var_pos = ref (svn_pos ss s) in
			let is_list = if(starts_with "List_Left" (symbol_ctor_name c) || 
				starts_with "List_Right" (symbol_ctor_name c)) then true else false in
			let is_opt = starts_with "Option" (symbol_ctor_name c) in

			let emit_pattern n = 
	let print_pattern k = 
		if(not(is_opt) && not(is_list)) then os (symbol_ctor_name c);
		if(not(is_list)) then os " (_"
		else (
			if(k mod 2 = 1 || k = 0) then os " (d" else os " (d'"
		);

		let c' = ref 0 in 
		let ss' = if((starts_with "List_Left" (symbol_ctor_name c))) then (List.rev (numbered ss)) else (numbered ss) in 

		let first = ref true in
		List.iter (fun (s',n) ->
			let x_i =
				if (is_terminal s') then "str"^string_of_int n
				else (symbol_var_name s') ^ string_of_int n in
			incr c';
			if (is_in_ast t s') then (
				if(!c' = List.length ss' && is_list) then os ")::" else os " , ";
				if(!first && (is_opt || is_list)) then (
					first := false;
					if(is_opt) then os "Some"; os "("
				);
				if(k = 0) then os x_i 
				else os (x_i^"_"^(string_of_int k))
			)
		) (ss');

		os ")"; if(List.length ss <> 0 && is_opt) then os ")"; in				

	if(List.length ss = 0 && is_opt) then ( 
		os "(_,None)" 
	)
	else if((!var_pos = 0 || List.length ss = 0) && is_list) then (
		os "(_,[])";
	)
	else (
		print_pattern n;
	)
	in

let equality = c in 
emit_pattern 1; os ","; emit_pattern 2; os "-> true"; 
 if(!var_pos = 0 && is_list) then ()
else (
	List.iter (fun (x1,n) -> 
		let eq_i = dump_nm^(symbol_var_name x1) in
		let x_i = 
		if (is_terminal x1) then "str"^string_of_int n
		else (symbol_var_name x1) ^ string_of_int n in
	let is_in_ast = is_in_ast t x1 in 
	let is_terminal = is_terminal x1 in
	let is_cur_eq_first_nt = if((symbol_var_name x1) = symbol_var_name (s,false)) then true else false in


if(is_in_ast) then (
   os " && "; 
   if(is_terminal) then (
    os (x_i^"_1"); os " = "; os (x_i^"_2")
   )
   else (
    os (eq_i^"(");
    if(is_cur_eq_first_nt && (is_list || is_opt)) then
     os ("(d,"^x_i^"_1"^") , (d',"^x_i^"_2))")
    else (os (x_i^"_1"); os " , "; os (x_i^"_2)"));
   )
  ); 


os "";
	) ss';);

 
)ps;

if (!num_same_nonterm > 1) then os "\n   | _ -> false\n";os ";;\n";
os ("let eq e = eq_" ^ symbol_var_name (get_start_symbol g) ^ " e;;");
close_out ofile;;
