open Grammar;;
open Trie;;

(* return the name to use for this symbol as a variable in an emitted file. 	
   The second argument should be true if s is a terminal, and false if it		
   is a nonterminal. 																			
																										
	let symbol_var_name (s,b) =																
  		if b then																					
    		String.uppercase ("gt_"^s)															
  	else																								
   	"g"^(String.uppercase ("t_"^s))														
;;*)					

(* this function returns the specified comment 
	delimeter w/out the quotes around it. *)
let rec get_comment_delimiter s = 
	let delim = ref "" in
	let i = ref 0 in
	String.iter (fun s' ->
		if(!i <> 0 && !i <> (String.length s) - 1) then delim := !delim^(Char.escaped s');
		incr i) s;
	!delim
;;					

(* returns true if the string - st - starts
	with the substring - sub - otherwise false.*)
let starts_with sub st = 
	let sub_ln = String.length sub in
   if(sub_ln > String.length st) then (false)
	else (
		if(String.sub st 0 sub_ln = sub) then (true)
		else (false)	
	);;
													

let symbol_var_name (s,b) = s;;

let symbol_ctor_name (s:string) = s;;

let dump_lexer (g:grammar) =
	match g with
   	Grammar(name,_,lcd,_,lcs,t,_) ->
			let ofile = (open_out (name ^ "_lex.mll")) in
			let os = output_string ofile in
			let util_line = (String.capitalize name) ^ "_util.line" in
			os "{\n (* auto-generated by gt *)\n\nopen ";
			os (String.capitalize name);
			os "_parse;;\n}\n\n";
			os "rule token = parse\n";
			os "| ['\\t' ' ' ]+ { token lexbuf }\n";
			(*os "| '#' (_ # '\\n')* { token lexbuf }\n";*)
			let delim = 
				match lcd with 
				None -> "#"
				|Some(s)-> get_comment_delimiter s in
				
			os "| ";
			String.iter(fun c -> os "'"; os (Char.escaped c); os "' ") delim;
			os " (_ # '\\n')* { token lexbuf }\n";
			os "| ['\\n']+ as str { ";
			os util_line;
			os " := (!";
			os util_line;
			os " + (String.length str)); token lexbuf }\n";
			List.iter (fun (s,c) -> 
				let in_ast = trie_contains t s in
				os "| ";
				if starts_with "char" c then (
					os (String.sub c 4 ((String.length c)-4));
				)
				else os c;

				if in_ast then os " as str";
				os " { ";

 				os (symbol_var_name (s,true));
				if in_ast && starts_with "char" c then os "(Char.escaped (str))"
				else if in_ast then os "(str)";
				os " }\n"
			) lcs;

			os "| eof { EOF }\n";
			os "| _ {failwith((Lexing.lexeme lexbuf) ^\n";
			os "\": lexing error on line \"^(string_of_int !";
			os util_line;
			os "))}";
			os "{}\n";
			close_out ofile;;

let starts_with_nonterminal ss = 
	match ss with
  		[] -> false
		| s::ss' -> (not (is_terminal s));;

(* Position of the symbol_var_name of s in given list ss *)
let svn_pos ss s = 
	let n = ref 0 in 
	let n' = ref 0 in
	if(not(starts_with_nonterminal ss)) then (incr n);
	List.iter(fun s' ->
		incr n;
		if((symbol_var_name s') = symbol_var_name (s,false)) then (n' := !n);
	) ss; !n';;

let dump_syntax (g:grammar) =
	match g with
		Grammar(name,_,_,ps,_,t,_) ->
			let ofile = (open_out (name ^ "_syntax.ml")) in
			let os = output_string ofile in
			let n = ref "" in
			os "(* auto-generated by gt *)\n\n";
			os "open ";
			os (String.capitalize name);
			os "_util;;\n\n";
			os "type dummy = Dummy ";
			List.iter (fun (Production(c,s,ss)) -> 
				let fnm = symbol_var_name (s,false) in 
				if (s <> !n) then (
					n := s;
					os "\nand ";
					os (fnm);
					os " ="
				);

				let n' = ref (svn_pos ss s) in
				let is_list = if(starts_with "List_Left" (symbol_ctor_name c) || 
						  		starts_with "List_Right" (symbol_ctor_name c)) then true else false in
				let is_opt = starts_with "Option`" (symbol_ctor_name c) in

				if((List.length ss <> 0 && (is_opt || (!n' <> 0 && is_list))) || (not is_list && not is_opt)) then (
					if(not is_list && not is_opt) then (os " | "; os (symbol_ctor_name c); os " of pd";)
					else os " pd * (";
					let first = ref false in
					List.iter (fun s' ->
						if (is_in_ast t s') then(
							if(not is_list && not is_opt) then os " * "
							else if((symbol_var_name s')<>symbol_var_name (s,false)) then (
								if(!first ) then (os " * ") else (os " ");
								first := true
							);

							if (is_terminal s') then (os "string")
							else (
								if((is_list || is_opt) && (symbol_var_name s') = symbol_var_name (s,false)) then () 
								else (os (symbol_var_name s'))
							)
						);
					) ss; 

					if(is_opt) then os ") option";
					if(is_list) then os ") list";
				);
			)ps;

			os ";;\n\n";
	    	(* now dump functions to extract the (pos,extradata): *)
	    	os "(* pd stands for pos (position) and extradata *)\n";
	    	os "let rec dummy () = () ";
			n := "";
			List.iter (fun (Production(c,s,ss)) -> 
				if (s <> !n) then (
					n := s;
				 	os "\nand ";
				 	os ("pd_" ^ (symbol_var_name (s,false)));
				 	os " = function "
				);
				os "\n  | ";

				let n' = ref (svn_pos ss s) in
				let is_list = if(starts_with "List_Left" (symbol_ctor_name c) || 
						  		starts_with "List_Right" (symbol_ctor_name c)) then true else false in
				let is_opt = starts_with "Option`" (symbol_ctor_name c) in

			 	if((List.length ss <> 0 && (is_opt || (!n' <> 0 && is_list))) || (not is_list && not is_opt)) then
			 	(
					if(not is_list && not is_opt) then os (symbol_ctor_name c);
					os "(d";
					if(is_opt) then os ",Some( ";
					if(is_list) then os ",( ";

					let fir = ref true in
				 	List.iter (fun s' ->
						if (is_in_ast t s') then(
							if(not is_opt && not is_list) then os (",_")
							else if((symbol_var_name s') <> symbol_var_name (s,false)) then (
								if(!fir) then (fir := false; os "_")
								else os (",_");
							)
						);
					) ss;
					if(is_opt || is_list) then os " )";
					if(is_list) then os "::f1239o2";
					os ") -> d\n"; 		
				)
				else (
					if(is_opt) then (os "(d,"; os "None"; os ") -> d\n");
					if(is_list) then (os "(d,"; os "[]"; os ") -> d\n");
				);			    
		) ps;

		os ";;\n";
		os ("let pd e = pd_" ^ symbol_var_name (get_start_symbol g) ^ " e;;");

		close_out ofile;;

let dump_parser (g:grammar) =
	let terminals = get_terminals g in
	let nonterminals = get_nonterminals g in
	match g with
		Grammar(name,start_symbol,_,productions,_,t,_) ->
			let start_var = (symbol_var_name (start_symbol,false)) in
			let ofile = (open_out (name ^ "_parse.mly")) in
			let os = output_string ofile in
			let cap_name = (String.capitalize name) in
			let syntax = cap_name^"_syntax" in
			let util = cap_name^"_util" in
			let os_type_decl n v = (
				os "\n\n%type <";
            os syntax;
            os ".";
            os n;
            os "> ";
            os v
			) in
			os "%{\n(* auto-generated by gt *)\n\n   open ";
			os syntax;
			os ";;\n";
			os "let parse_error s =\n ";
			os "  print_string s;\n";
			os "  print_string \" on line \";\n";
			os "  print_int !";
			os (String.capitalize name);
			os "_util.line;\n";
			os "  print_string \"\\n\";;\n\n";
			os "%}\n\n%start main\n\n";
			os "%token EOF";
			List.iter (fun s -> 
				if (is_in_ast t s) then ()
				else (
					os " ";
					os (symbol_var_name s)
				)
			) terminals;
			os "\n%token <string>";
			List.iter (fun s -> 
				if (is_in_ast t s) then (
					os " "; os (symbol_var_name s)
				)
			) terminals;
			os "\n\n%type <";
			os syntax;
			os ".";
			os start_var;
			os " option> main";
			List.iter (fun s -> 
				let n = (symbol_var_name s) in
				os_type_decl n n
			) nonterminals;
			os "\n\n%type <";
			os util;
			os ".pd> cur_position\n\n%%\n\n";
			os "main:\n| ";
			os start_var;
			os " { Some($1) }\n";
			os "| EOF { None }\n\n";
			os "cur_position:\n| { ";
			os util;
			os ".cur_pd() }\n";

			List.iter(fun p ->
				match p with
					Production(n,s,ss) ->
						os "\n";
						os (symbol_var_name (s,false));
						os ":\n|";

				  		let ctor_nm = (symbol_ctor_name n) in
                  let starts_with_nonterminal = 
                  	match ss with
                    		[] -> false
                        | s::ss' -> (not (is_terminal s)) in

						let is_list = if(starts_with "List_Left"  ctor_nm || 
										  		starts_with "List_Right" ctor_nm) then true else false in
						let is_repetition = if(starts_with "List_Left_Repetition" ctor_nm || 
							starts_with "List_Right_Repetition"	ctor_nm) then true else false in
						let is_opt = starts_with "Option`" ctor_nm in
                  if (not starts_with_nonterminal || (List.length ss = 0 && (is_list || is_opt))) then os " cur_position";
						List.iter (fun s -> os " "; os (symbol_var_name s)) ss;
			         os " { ";

						let r = ref 1 in
						let n' = ref (svn_pos ss s) in
						let li_nm = ref "" in
						if(!n' <> 0 && is_list) then (
							os "let (";
							let c = ref 1 in
							let first = ref true in 
							let first' = ref true in
			         	List.iter (fun s' -> 
								if((symbol_var_name s') <> symbol_var_name (s,false))then(
                       		if (!first) then (first := false; os "p"; os ", (");
					            if (is_in_ast t s' && !first') then (
										first' := false; 
										os " l"; os (string_of_int !c); os " ";
										li_nm := "l"^(string_of_int !c)
									)
								); incr c;
							) ss;
	
							if(List.length ss <> 0) then os ")"; os ") = "; 
							os "$"; 
							os (string_of_int !n');
							os " in ";
						);
			
				    	if(not is_opt && not is_list) then os ctor_nm;     
			       	if (not starts_with_nonterminal) then (
							os "($1";
			           	incr r
						);

						if(is_opt && List.length ss = 0) then (os ", None");
						if(is_list && List.length ss = 0) then (os ", []");
						let le = ref 0 in List.iter(fun s' -> incr le; if(is_in_ast t s' && !le = List.length ss) then incr le;) ss;
					   let first = ref true in
						let first' = ref true in
						List.iter (fun s' -> 
					   	if (!first) then (
								first := false;
				            if (starts_with_nonterminal) then
				            	os ("(pd_"^(symbol_var_name s')^" $1");
								if(is_opt) then os ", Some(";
								if(is_list) then os ", (";
							);
							if((symbol_var_name s') = symbol_var_name (s,false) && is_list) then ()
							else if (is_in_ast t s') then (
								if(!first' && (is_opt || is_list)) then ( 
									first' := false; 
									if(is_opt) then os " "; os "$"; 
									os (string_of_int !r);
									if(is_opt) then os " ";
								)
								else (
									if(	is_repetition) then
										os "::$"							
									else os ", $";
									os (string_of_int !r)
								);
							); incr r
						) ss; 

						if(is_list && List.length ss <> 0) then (
							if(is_repetition) then (
								if(!n' <> 0) then os ("::(" ^ !li_nm ^ "))")
								else os "::[])";			
							)				
							else (
								if(!n' <> 0) then os (")::(" ^ !li_nm ^ ")")
								else os ")::[]";
							)
						);
 						if(is_opt && List.length ss <> 0) then os ")"; os ") }\n"   
			) productions;
close_out ofile;;

let numbered xs =
	let n = ref 0 in
	List.map (fun x -> n := !n+1; (x,!n)) xs

(*
let dump_prettyprinter (g:grammar) =
	match g with
		Grammar(name,_,_,ps,_,t,_) ->
			let ofile = (open_out (name ^ "_pp.ml")) in
			let os = output_string ofile in
			let n = ref "" in
			os "(* auto-generated by gt *)\n\n";
			os "open ";
			os (String.capitalize name);
			os "_syntax;;\n\n";
			os "let rec dummy () = () ";

			List.iter (fun (Production(c,s,ss)) -> 
				if (s <> !n) then (
					n := s;
					os "\nand ";
					os ("pp_" ^ (symbol_var_name (s,false)));
					os " = function "
				);
				os "\n  | ";

				let n' = ref (svn_pos ss s) in
				let is_list = if(starts_with "List_Left" (symbol_ctor_name c) || 
											starts_with "List_Right" (symbol_ctor_name c)) then true else false in
				let is_opt = starts_with "Option`" (symbol_ctor_name c) in

				if(List.length ss = 0 && is_opt) then (os "(d,None) -> ")
				else if ((List.length ss = 0 || !n' = 0) && is_list) then ( os "(d,[]) -> " )
				else (
					if(not is_opt && not is_list) then (os (symbol_ctor_name c); os " (_")
					else os " (d";

					let c' = ref 0 in
			  		let ss' = if((starts_with "List_Left" (symbol_ctor_name c))) then (List.rev (numbered ss)) else (numbered ss) in 

					let first = ref true in 
					List.iter (fun (s',n) ->
						incr c';
						let varname = 
							if (is_terminal s') then "str"^string_of_int n
							else (symbol_var_name s') ^ string_of_int n in
				
						if (is_in_ast t s') then (
							if(!c' = List.length ss' && is_list) then os (")::") else os (" , "); 
							if(!first && (is_opt || is_list)) then (
								first := false;
								if(is_opt) then os "Some"; 
								os "("
							);
							os varname
						)
					)(ss');

					if(is_opt) then os ")"; os ") -> ";
				);

				if(!n' = 0 && is_list) then ()
				else (
					let print_space = ref false in
						List.iter (fun (s',n) ->
							let varname = 
								if (is_terminal s') then "str"^string_of_int n
								else (symbol_var_name s')^string_of_int n in
							
							if !print_space then  (os "print_string \" \"; ")
							else print_space := true;
							
							if (is_in_ast t s') then (
								if (is_terminal s') then os "print_string "
								else os ("pp_" ^ symbol_var_name s'); os " ";

								if((symbol_var_name s') = (symbol_var_name (s,false)) && (is_list || is_opt)) then (  
									os "( d , "; os varname; os " )"
								) 
								else os varname; os " "
							)
							else (
								os "print_string "; os (string_of_terminal g s')
							); os "; "
						) (numbered ss);
				); os "()"
			) ps;

			os ";;\n";
			os ("let pp e = pp_" ^ symbol_var_name (get_start_symbol g) ^ " e;;");
			close_out ofile;;
	      
let dump_eq (g:grammar) =
	match g with
		Grammar(name,_,_,ps,_,t,_) ->
			let ofile = (open_out (name ^ "_eq.ml")) in
			let os = output_string ofile in
			let n = ref "" in
			let num_same_nonterm = ref 1 in
			os "(* auto-generated by gt *)\n\n";
			os "open ";
			os (String.capitalize name);
			os "_syntax;;\n\n";
			os "let rec dummy () = () ";
			List.iter (fun (Production(c,s,ss)) -> 
				if (s <> !n) then (
					if (!num_same_nonterm > 1) then os "\n  | _ -> false\n";
					num_same_nonterm := 1;
					n := s;
					os "\nand ";
					os ("eq_" ^ (symbol_var_name (s,false)));
					os " = function "
				)
				else incr num_same_nonterm;

				os "\n  | ";
				let varname s' n k = 
					(if (is_terminal s') then "str" else (symbol_var_name s'))^(string_of_int n)^"_"^(string_of_int k) in

				let is_list = if(starts_with "List_Left" (symbol_ctor_name c) || 
										starts_with "List_Right" (symbol_ctor_name c)) then true else false in
				let is_opt = starts_with "Option`" (symbol_ctor_name c) in
				let n' = ref (svn_pos ss s) in

				let print_pattern k = 
					if(not(is_opt) && not(is_list)) then os (symbol_ctor_name c);
					if(not(is_list)) then os " (_" 
					else (
						if(k mod 2 = 1) then os " (d" else os " (d'"
					);
				
					let c' = ref 0 in 
			  		let ss' = if((starts_with "List_Left" (symbol_ctor_name c))) then (List.rev (numbered ss)) else (numbered ss) in 

					let first = ref true in
					List.iter (fun (s',n) ->
						incr c';
						if (is_in_ast t s') then (
							if(!c' = List.length ss' && is_list) then os ")::" else os " , ";
							if(!first && (is_opt || is_list)) then (
								first := false; 
								if(is_opt) then os "Some"; os "("
							);
							os (varname s' n k)
						)
					) (ss');

					os ")"; if(List.length ss <> 0 && is_opt) then os ")"; in

				if(List.length ss = 0 && is_opt) then ( 
					os "(_,None) , (_,None)" 
				)
				else if((!n' = 0 || List.length ss = 0) && is_list) then (
					os "(_,[]) , (_,[])";
				)
				else (
					print_pattern 1;
					os " , ";
					print_pattern 2
				);

				os " -> ";
				os " true ";
				if(!n' = 0 && is_list) then ()
				else(
					List.iter (fun (s',n) ->
						if(is_in_ast t s') then (
							os " && ";
							if is_terminal s' then (
								os (varname s' n 1); os " = "; os (varname s' n 2)
							)
							else (
								if(symbol_var_name s' = (symbol_var_name (s,false)) && (is_list || is_opt)) then (
									os ("eq_" ^(symbol_var_name s') ^ "( " ^ "(d," ^ (varname s' n 1) ^ ") , " ^ "(d'," ^ (varname s' n 2) ^ "))")
								)
								else os ("eq_" ^ (symbol_var_name s') ^ "( " ^ (varname s' n 1) ^ " , " ^ (varname s' n 2) ^ " )");
						
							)
						)
					) (numbered ss)
				)
			) ps;

	if (!num_same_nonterm > 1) then os "\n  | _ -> false\n";
	os ";;\n\n";
	os ("let eq e = eq_" ^ symbol_var_name (get_start_symbol g) ^ " e;;");
	close_out ofile;;
*)

let dump_main (g:grammar) = 
	match g with
		Grammar(name,_,_,_,_,_,_) ->
			let ofile = (open_out (name ^ "_main.ml")) in
			let os = output_string ofile in
			let cap_name = (String.capitalize name) in
			os "(* auto-generated by gt *)\n\n";
			os "let parsed =";
			os "  let lexbuf = Lexing.from_channel stdin in";
			os "  ";
			os cap_name;
			os "_parse.main ";
			os cap_name;
			os "_lex.token lexbuf;;\n";
			os "match parsed with\n";
			os "  None -> ()\n";
			os "| Some(x) -> ";
			os cap_name; 
			os "_pp.pp x;;";
			os "\n\nprint_string \"\\n\";;";
			close_out ofile;;

let dump_util (g:grammar) = 
	match g with
		Grammar(name,_,_,_,_,_,extradata) ->
			let ofile = (open_out (name ^ "_util.ml")) in
			let os = output_string ofile in
			let have_extradata=(extradata<>"") in
			os "(* auto-generated by gt *)\n\n";
			if have_extradata then (
				os "(* begin extra data from grammar file: *)\n";
				os extradata;
				os "\n(* begin extra data from grammar file: *)\n\n"
			)
			else (
				os "(* no extra data from grammar file. *)\n";
				os "type extradata = unit;;\n";
				os "let initial_data() = ();;\n\n"
			);
			os "let file = ref \"stdin\";;\n";
			os "let line = ref 1;;\n";
			os "type pos = int;;\n";
			os "let string_of_pos p = \"line \"^(string_of_int p);;\n";
			os "let cur_pd() = (!line, initial_data());;   (* \"pd\": pos + extradata *) \n";
			os "type pd = pos * extradata;;\n";
	close_out ofile;;
		
let dump_Makefile (g:grammar) =
	match g with
		Grammar(name,_,_,_,_,_,_) ->
	  		let ofile = (open_out (name ^ "_Makefile")) in
	  		let os = output_string ofile in
			os "# auto-generated by gt \n\n";
			os "NAME=";
			os name;
			os "\n$(NAME): $(NAME)_util.cmo $(NAME)_syntax.cmo $(NAME)_parse.cmo $(NAME)_lex.cmo $(NAME)_pp.cmo $(NAME)_eq.cmo $(NAME)_main.cmo\n";
			os "\tocamlc -o $(NAME) $(NAME)_util.cmo $(NAME)_syntax.cmo $(NAME)_parse.cmo $(NAME)_lex.cmo $(NAME)_pp.cmo $(NAME)_main.cmo\n";
			os "\n";
			os "$(NAME)_main.cmo: $(NAME)_main.ml $(NAME)_parse.cmo $(NAME)_lex.cmo\n";
			os "\tocamlc -c $(NAME)_main.ml\n";
			os "\n";
			os "$(NAME)_syntax.cmo: $(NAME)_syntax.ml $(NAME)_util.cmo\n";
			os "\tocamlc -c $(NAME)_syntax.ml\n";
			os "\n";
			os "$(NAME)_pp.cmo: $(NAME)_pp.ml $(NAME)_syntax.cmo\n";
			os "\tocamlc -c $(NAME)_pp.ml\n";
			os "\n";
			os "$(NAME)_eq.cmo: $(NAME)_eq.ml $(NAME)_syntax.cmo\n";
			os "\tocamlc -c $(NAME)_eq.ml\n";
			os "\n";
			os "$(NAME)_util.cmo: $(NAME)_util.ml\n";
			os "\tocamlc -c $(NAME)_util.ml\n";
			os "\n";
			os "$(NAME)_lex.cmo: $(NAME)_lex.ml\n";
			os "\tocamlc -c $(NAME)_lex.ml\n";
			os "\n";
			os "$(NAME)_parse.cmo: $(NAME)_parse.ml $(NAME)_parse.cmi\n";
			os "\tocamlc -c $(NAME)_parse.ml\n";
			os "\n";
			os "$(NAME)_parse.cmi: $(NAME)_parse.mli\n";
			os "\tocamlc -c $(NAME)_parse.mli\n";
			os "\n";
			os "$(NAME)_parse.mli $(NAME)_parse.ml: $(NAME)_parse.mly $(NAME)_syntax.cmo\n";
			os "\tocamlyacc -v $(NAME)_parse.mly\n";
			os "\n";
			os "$(NAME)_lex.ml: $(NAME)_lex.mll $(NAME)_parse.cmi\n";
			os "\tocamllex $(NAME)_lex.mll\n";
			os "\nclean:\n\trm -f $(NAME)_lex.ml $(NAME)_parse.mli $(NAME)_parse.ml *.cmo *.cmi $(NAME)\n\n";
			close_out ofile;

			let ofile = (open_out "most_recent_emitted_Makefile") in
			let os = output_string ofile in
			os "all:\n\t$(MAKE) -f ";
			os name;
			os "_Makefile";
			close_out ofile;;
