module Main where

import Control.Exception 
import System( getArgs )

main = do
        args <- getArgs
        s <- getContents
        let o = what_output args in
          let u = bench_to_form (parse s) in
            do (lfshow_result o u (solve u))
               putStrLn "."

data Output = Prefix | Explicit | Implicit | Scimplicit | None

what_output ("prefix":[]) = Prefix
what_output ("explicit":[]) = Explicit
what_output ("implicit":[]) = Implicit
what_output ("scimplicit":[]) = Scimplicit
what_output ("none":[]) = None
what_output _ = Explicit

data Bench = ExistsB [Int] Bench
           | ForallB [Int] Bench
           | ClauseB [Int] Bench
           | EmptyB deriving Show

consume_line s =
  case s of 
   ('\n':ss) -> ss
   (c:ss) -> consume_line ss

read_to c s =
  let (a,b) = break (== c) s in
    (a,if b == [] then [] else tail b)

string_to_int_list [] = []
string_to_int_list s = 
  let (l,r) = read_to ' ' s in
    let x = read l in
    let rr = string_to_int_list r in
      if x == 0 then
        rr
      else
        x:rr

split_line = read_to '\n'

eat_num_line s f c =
   let (l,r) = split_line s in
      f (string_to_int_list l) (c r)

parse s = 
  case s of
    (a:ss) | a == 'c' || a == 'p' -> parse (consume_line ss)
    (a:' ':ss) | a == 'e' || a == 'a' ->
       eat_num_line ss (case a of
                         'e' -> (\ x y -> ExistsB x y)
                         'a' -> (\ x y -> ForallB x y))
          parse
    (a:ss) -> eat_num_line s (\ x y -> ClauseB x y) parse
    [] -> EmptyB   

data Pol = Pos | Neg deriving (Show, Eq)
data Form = Quant Pol Int Form | Conn Pol Form Form
          | Not Form | Lit Int | Bval Pol deriving Show

bench_to_clause (n:c) = Conn Neg (if n < 0 then Not (Lit (-n)) else Lit n)
                           (bench_to_clause c)
bench_to_clause [] = Bval Neg

bench_to_clauses (ClauseB l b) = 
  Conn Pos (bench_to_clause l) (bench_to_clauses b)
bench_to_clauses EmptyB = Bval Pos

bench_to_form (ExistsB (v:vs) b) = Quant Neg v (bench_to_form (ExistsB vs b))
bench_to_form (ExistsB [] b) = bench_to_form b
bench_to_form (ForallB (v:vs) b) = Quant Pos v (bench_to_form (ForallB vs b))
bench_to_form (ForallB [] b) = bench_to_form b
bench_to_form (ClauseB l b) = bench_to_clauses (ClauseB l b)
bench_to_form x = throw (ErrorCall (show x))

data OppPf = Opp1 | Opp2 deriving Show

data Pf = Nott |
          Notf | 
          Refl Form |
          Trans Form Form Form Pf Pf | 
          Connc Pol Form Form Form Form Pf Pf |
          Connz1 Pol Pol OppPf Form |
          Connz2 Pol Pol OppPf Form |
          Connu1 Pol Form |
          Connu2 Pol Form |
          Quantz Pol Pol OppPf Pol Int Form Pf |
          Quantu Pol Int Form Pf Pf |
          Quantn Pol Form |
          Quantc Pol Int Form Form Pf deriving Show

lfshow_result o f (p,r) = 
  do
    case o of 
      Prefix -> 
        do 
          putStrLn ("bench = ")
          lfshow o r
          putStrLn ": Equiv "
          lfshowF f
          lfshowF (Bval p)
      None ->
        do
          lfshowP p
      _ ->
        do
          putStr "bench : "
          lfshowF f
          putStrLn " Equiv "
          lfshowF (Bval p)
          putStrLn " = "
          lfshow o r


lfshowlam v f = 
  do
    putStr "([x"
    putStr (show v)
    putStr ":o] "
    lfshowF f
    putStr ")"

lfshowF (Quant i v f) = 
  do
    putStr "(quant "
    lfshowP i
    putStr " "
    lfshowlam v f
    putStr ")"
lfshowF (Conn i f1 f2) =
  do
    putStr "(conn "
    lfshowP i
    putStr " "
    lfshowF f1
    putStr " "
    lfshowF f2
    putStr ")"
lfshowF (Lit v) = 
  do
    putStr "x"
    putStr (show v)
lfshowF (Not f) = 
  do
    putStr "(not "
    lfshowF f
    putStr ")"
lfshowF (Bval i) = 
   do
    putStr "(bval "
    lfshowP i
    putStr ")"

lfshowO Opp1 = putStr "opp1"
lfshowO Opp2 = putStr "opp2"
lfshowP Pos = putStr "pos"
lfshowP Neg = putStr "neg"

-- cases where implicit and explict are the same
lfshow None _ = putStr ""
lfshow _ Nott = putStr "nott"
lfshow _ Notf = putStr "notf"
lfshow _ (Refl f) = 
	do
	  putStr "(refl "
          lfshowF f
          putStr ")"
lfshow _ (Quantn i f) =
  do
    putStr "(quantn "
    lfshowP i
    putStr " "
    lfshowF f
    putStr ")"
lfshow _ (Connu1 i f) = 
  do
    putStr "(connu1 "
    lfshowP i
    putStr " "
    lfshowF f
    putStr ")"
lfshow _ (Connu2 i f) = 
  do
    putStr "(connu2 "
    lfshowP i
    putStr " "
    lfshowF f
    putStr ")"

-- scimplicit cases 
lfshow Scimplicit (Trans f1 f2 f3 p1 p2) = 
  do
    putStr "(trans _ _ _ "
    lfshow Scimplicit p1
    putStr " "
    lfshow Scimplicit p2
    putStr ")"
lfshow Scimplicit (Connc i f1 f2 f3 f4 p1 p2) = 
  do 
    putStr "(connc "
    lfshowP i
    putStr " _ _ _ _ "
    lfshow Scimplicit p1
    putStr " "
    lfshow Scimplicit p2
    putStr ")"
lfshow Scimplicit (Connz1 i i2 o f) = 
  do
    putStr "(connz1 _ _ "
    lfshowO o
    putStr " "
    lfshowF f
    putStr ")"
lfshow Scimplicit (Connz2 i i2 o f) = 
  do
    putStr "(connz2 _ _ "
    lfshowO o
    putStr " "
    lfshowF f
    putStr ")"
lfshow Scimplicit (Quantz i i2 o i3 v f p) = 
  do
    putStr "(quantz _ _ "
    lfshowO o
    putStr " "
    lfshowP i3
    putStr " "
    lfshowlam v f
    putStr " "
    lfshow Scimplicit p
    putStr ")"
lfshow Scimplicit (Quantu i v f p1 p2) = 
  do
    putStr "(quantu _ "
    lfshowlam v f
    putStr " "
    lfshow Scimplicit p1
    putStr " "
    lfshow Scimplicit p2
    putStr ")"
lfshow Scimplicit (Quantc i v f1 f2 p) = 
  do
    putStr "(quantc "
    lfshowP i
    putStr " _ _ "
    putStr "[x"
    putStr (show v)
    putStr ":o] "
    lfshow Scimplicit p
    putStr ")"

-- implicit cases
lfshow Implicit (Trans f1 f2 f3 p1 p2) = 
  do
    putStr "(trans "
    lfshow Implicit p1
    putStr " "
    lfshow Implicit p2
    putStr ")"
lfshow Implicit (Connc i f1 f2 f3 f4 p1 p2) = 
  do 
    putStr "(connc "
    lfshowP i
    putStr " "
    lfshow Implicit p1
    putStr " "
    lfshow Implicit p2
    putStr ")"
lfshow Implicit (Connz1 i i2 o f) = 
  do
    putStr "(connz1 "
    lfshowO o
    putStr " "
    lfshowF f
    putStr ")"
lfshow Implicit (Connz2 i i2 o f) = 
  do
    putStr "(connz2 "
    lfshowO o
    putStr " "
    lfshowF f
    putStr ")"
lfshow Implicit (Quantz i i2 o i3 v f p) = 
  do
    putStr "(quantz "
    lfshowO o
    putStr " "
    lfshowP i3
    putStr " "
    lfshowlam v f
    putStr " "
    lfshow Implicit p
    putStr ")"
lfshow Implicit (Quantu i v f p1 p2) = 
  do
    putStr "(quantu "
    lfshowlam v f
    putStr " "
    lfshow Implicit p1
    putStr " "
    lfshow Implicit p2
    putStr ")"
lfshow Implicit (Quantc i v f1 f2 p) = 
  do
    putStr "(quantc "
    lfshowP i
    putStr " "
    putStr "[x"
    putStr (show v)
    putStr ":o] "
    lfshow Implicit p
    putStr ")"


-- properly explicit and properly prefix cases 
lfshow x (Trans f1 f2 f3 p1 p2) = 
  do
    putStr "(trans "
    lfshowF f1
    putStr " "
    lfshowF f2
    putStr " "
    lfshowF f3
    putStr " "
    lfshow x p1
    putStr " "
    lfshow x p2
    putStr ")"
lfshow x (Connc i f1 f2 f3 f4 p1 p2) = 
  do
    putStr "(connc " 
    lfshowP i
    putStr " "
    lfshowF f1
    putStr " "
    lfshowF f2
    putStr " "
    lfshowF f3
    putStr " "
    lfshowF f4
    putStr " "
    lfshow x p1
    putStr " "
    lfshow x p2
    putStr ")"
lfshow _ (Connz1 i i2 o f) = 
  do
    putStr "(connz1 "
    lfshowP i
    putStr " "
    lfshowP i2
    putStr " "
    lfshowO o
    putStr " "
    lfshowF f
    putStr ")"
lfshow _ (Connz2 i i2 o f) = 
  do
    putStr "(connz2 " 
    lfshowP i
    putStr " "
    lfshowP i2
    putStr " "
    lfshowO o
    putStr " "
    lfshowF f
    putStr ")"
lfshow x (Quantz i i2 o i3 v f p) = 
  do
    putStr "(quantz " 
    lfshowP i
    putStr " "
    lfshowP i2
    putStr " "
    lfshowO o
    putStr " "
    lfshowP i3
    putStr " "
    lfshowlam v f
    putStr " "
    lfshow x p
    putStr ")"
lfshow x (Quantu i v f p1 p2) = 
  do
    putStr "(quantu " 
    lfshowP i
    putStr " "
    lfshowlam v f
    putStr " "
    lfshow x p1
    putStr " "
    lfshow x p2
    putStr ")"
lfshow x (Quantc i v f1 f2 p) = 
  do 
    putStr "(quantc " 
    lfshowP i
    putStr " "
    lfshowlam v f1
    putStr " "
    lfshowlam v f2
    putStr " "
    putStr "[x"
    putStr (show v)
    putStr ":o] "
    lfshow x p
    putStr ")"


simplify (Quant i v2 f) = 
  let (ff,p) = simplify f in
  let pc = Quantc i v2 f ff p in
    if free_in v2 ff then
      (Quant i v2 ff, pc)
    else
       (ff, Trans (Quant i v2 f) (Quant i v2 ff) ff pc
               (Quantn i ff))
simplify (Conn i f1 f2) = 
  let (f1a,p1) = simplify f1 in
  case f1a of
    Bval i2 -> 
      let pc = Connc i f1 f1a f2 f2 p1 (Refl f2) in
      if i == opp i2 then
        (f1a, Trans (Conn i f1 f2) (Conn i f1a f2) f1a pc 
                 (Connz1 i i2 (opppf i i2) f2))
      else
        let (f2a, p2) = simplify f2 in
          (f2a, Trans (Conn i f1 f2) f2 f2a
                  (Trans (Conn i f1 f2) (Conn i f1a f2) f2
                     pc (Connu1 i f2))
                  p2)
    _ -> let (f2a,p2) = simplify f2 in
         case f2a of
            Bval i2 ->
              let pc = (Connc i f1 f1 f2 f2a (Refl f1) p2) in
              if i == opp i2 then
                (f2a, Trans (Conn i f1 f2) (Conn i f1 f2a) f2a 
                        pc (Connz2 i i2 (opppf i i2) f1))
              else
                (f1a, Trans (Conn i f1 f2) f1 f1a
                        (Trans (Conn i f1 f2) (Conn i f1 f2a) f1
                           pc (Connu2 i f1))
                        p1)
            _ -> (Conn i f1a f2a, Connc i f1 f1a f2 f2a p1 p2)
simplify (Not (Bval b)) = 
  if b == Pos then
      (Bval Neg, Nott)
  else
      (Bval Pos, Notf)
simplify f = (f, Refl f)

subst v b (Quant i v2 f) | not (v == v2) = (Quant i v2 (subst v b f))
subst v b (Conn i f1 f2) = (Conn i (subst v b f1) (subst v b f2))
subst v b (Lit v2) | v == v2 = Bval b
subst v b (Not f) = (Not (subst v b f))
subst v b x = x

opp Pos = Neg
opp Neg = Pos

opppf Pos Neg = Opp1
opppf Neg Pos = Opp2

free_in v (Quant i v2 f) = v == v2 || free_in v f
free_in v (Conn i f1 f2) = free_in v f1 || free_in v f2
free_in v (Lit v2) = v == v2
free_in v (Not f) = free_in v f
free_in v (Bval i) = False

solveh (Quant i v f) po = 
  -- b == Pos iff we already derived the unit for the Pos instance of this 
  -- quantified formula
  let b = (case po of { Nothing -> Pos; _ -> Neg }) in
  -- pt needs to show that the appropriate instance of f is equiv to the unit
  let on_unit pt = 
       case b of 
         Pos -> solveh (Quant i v f) (Just pt)
         Neg -> (i, Quantu i v f (case po of Just p -> p) pt) in
  let fi = subst v b f in 
  case (simplify fi) of
      (Bval i2, p) | i2 == opp i -> (i2,Quantz i i2 (opppf i i2) b v f p)
      (Bval _,p) -> on_unit p
      (ff,p) -> case solveh ff Nothing of
                  (i2, p2) | i2 == opp i -> 
                      (i2, Quantz i i2 (opppf i i2)
                             b v f (Trans fi ff (Bval i2) p p2))
                  (_, p2) -> on_unit (Trans fi ff (Bval i) p p2) 
                                 
solve f = solveh f Nothing