#include <iostream.h>
#include <stdio.h>
#include <string>

std::string f(int n) {
  if( n==0 ) return "a";
  return "(f " + f(n-1) + ")";
}

void printCongf(int n, ostream &of) {
  of << "congf" << n
    // << ": pf (all [a:trm] ((a == (h a)) imp (" << f(n-1) << " == " << f(n) << ")))"
     << " = alli ([a:trm] ((a == (h a)) imp (" << f(n-1) << " == " << f(n) << "))) ([a:trm] impi (a == (h a)) (" << f(n-1) << " == " << f(n) << ") ([u:pf (a == (h a))] congf " << f(n-2) << " " << f(n-1) << " (mp (a == (h a)) (" << f(n-2) << " == " << f(n-1) << ") (alle ([a:trm] ((a == (h a)) imp (" << f(n-2) << " == " << f(n-1) << "))) a congf" << (n-1) << ") u)))." << std::endl;
}

void printProof(int n, ostream &of) {
  of << "pf" << n 
    //     << ": pf ((a == (g a)) imp (a == " << f(n) << ")) "
     << " = impi (a == (g a)) (a == " << f(n) << ") ([u:pf (a == (g a))] trans a " << f(n-1) << " " << f(n) << " (mp (a == (g a)) (a == " << f(n-1) << ") pf" << (n-1) << " u) (mp (a == (g a)) (" << f(n-1) << " == " << f(n) << ") (alle ([a:trm] ((a == (g a)) imp (" << f(n-1) << " == " << f(n) << "))) a congf" << n << ") u))." << std::endl;
}

void printCongfPrefix(int n, ostream &of) {
  of << "congf" << n << " = (alli ([a:trm] (imp (eq a (h a)) (eq " << f(n-1) << " " << f(n) << "))) ([a:trm] impi (eq a (h a)) (eq " << f(n-1) << " " << f(n) << ") ([u:pf (eq a (h a))] congf " << f(n-2) << " " << f(n-1) << " (mp (eq a (h a)) (eq " << f(n-2) << " " << f(n-1) << ") (alle ([a:trm] (imp (eq a (h a)) (eq " << f(n-2) << " " << f(n-1) << "))) a congf" << (n-1) << ") u)))) : pf (all [a:trm] (imp (eq a (h a)) (eq " << f(n-1) << " " << f(n) << ")))." << std::endl;
}

void printProofPrefix(int n, ostream &of) {
  of << "pf" << n << " = (impi (eq a (g a)) (eq a " << f(n) << ") ([u:pf (eq a (g a))] trans a " << f(n-1) << " " << f(n) << " (mp (eq a (g a)) (eq a " << f(n-1) << ") pf" << (n-1) << " u) (mp (eq a (g a)) (eq " << f(n-1) << " " << f(n) << ") (alle ([a:trm] (imp (eq a (g a))  (eq " << f(n-1) << " " << f(n) << "))) a congf" << n << ") u)))"
    //<< ": pf (imp (eq a (g a)) (eq a " << f(n) << "))"
     << "." << std::endl;
}

void printCongfImplicit(int n, ostream &of) {
  of << "congf" << n 
    //<< ": pf (all [a:trm] ((a == (h a)) imp (" << f(n-1) << " == " << f(n) << ")))"
    <<" = alli ([a] impi ([u:pf (a == (g a))] congf (mp (alle a congf" << (n-1) << ") u)))." << std::endl;
}

void printProofImplicit(int n, ostream &of) {
  of << "pf" << n
    // << ": pf ((a == (g a)) imp (a == " << f(n) << ")) "
     << " = impi ([u:pf (a == (g a))] trans (mp pf" << (n-1) << " u) (mp (alle a congf" << n << ") u))." << std::endl;
}

void printCongfSCImplicit(int n, ostream &of) {
  of << "congf" << n 
    // << ": pf (all [a:trm] ((a == (h a)) imp (" << f(n-1) << " == " << f(n) << "))) "
     << " = alli _ ([a:trm] impi _ _ ([u:pf (a == (h a))] congf _ _ (mp _ _ (alle _ a congf" << (n-1) << ") u)))." << std::endl;
}

void printProofSCImplicit(int n, ostream &of) {
  of << "pf" << n 
    //<< ": pf ((a == (g a)) imp (a == " << f(n) << ")) "
    << " = impi _ _ ([u:pf (a == (g a))] trans _ _ _ (mp _ _ pf" << (n-1) << " u) (mp _ _ (alle _ a congf" << n << ") u))." << std::endl;
}

void print_help() {
  cout << "Arguments are optionally -i to generate implicit LF, \n";
  cout << "-s to generate implicit LF for sc (explicit holes `_'), \n";
  cout << "or alternatively -p to generate prefix (explicit) LF, \n";
  cout << "followed by the size n of the testcase.\n";
  exit(1);
}

int main(int argc, char **argv) {
  int n;
  int implicit = 0;
  int sc_implicit = 0;
  int prefix = 0;
  int i = 1;
  if ((argc == 1) || strcmp(argv[1],"-h") == 0 ||
      strcmp(argv[1],"--help") == 0)
    print_help();
  

  if (strcmp(argv[i],"-i") == 0) {
    implicit = 1;
    i++;
    if (i == argc)
      print_help();
  }
  else if (strcmp(argv[i],"-s") == 0) {
    sc_implicit = 1;
    i++;
    if (i == argc)
      print_help();
  }
  else if (strcmp(argv[i],"-p") == 0) {
    prefix = 1;
    i++;
    if (i == argc)
      print_help();
  }

  sscanf(argv[i], "%d", &n);

  if (prefix)
    // flea seems not to parse typed definitions quite the same way as Twelf.
    cout << "h = ([x:trm] g x) : trm -> trm." << std::endl;
  else
    cout << "h : trm -> trm = [x:trm] g x." << std::endl;

  if (implicit) {
   cout << "congf2"
     //	<< ": pf (all [a] (a == (f a)) imp ((f a) == (f (f a)))) "
	<< " = alli ([a] impi ([u:pf (a == (f a))] congf u))." << std::endl;
    
    cout << "pf2"
      // << ": pf ((a == (f a)) imp (a == (f (f a))))"
	 << " = impi ([u:pf (a == (g a))] trans u (mp (alle a congf2) u))." << std::endl;
   }
  else if (sc_implicit) {
    cout << "congf2"
      // << ": pf (all [a:trm] (a == (f a)) imp ((f a) == (f (f a))))"
	 << " = alli _ ([a:trm] impi _ _ ([u:pf(a == (f a))] congf _ _ u))." << std::endl;
    cout << "pf2"
      //<< ": pf ((a == (f a)) imp (a == (f (f a)))) "
	 << " = impi _ _ ([u: pf(a == (f a))] trans _ _ _ u (mp _ _ (alle _ a congf2) u))." << std::endl;
  }
  else if (prefix) {
    cout << "congf2 = (alli ([a:trm] imp (eq a (f a)) (eq (f a) (f (f a)))) ([a:trm] impi (eq a (f a)) (eq (f a) (f (f a))) ([u:pf (eq a (f a))] congf a (f a) u))) : pf (all [a:trm] imp (eq a (f a)) (eq (f a) (f (f a))))." << std::endl;
    
    cout << "pf2 = (impi (eq a (f a)) (eq a (f (f a))) ([u: pf(eq a (f a))] trans a (f a) (f (f a)) u (mp (eq a (f a)) (eq (f a) (f (f a))) (alle ([a:trm] imp (eq a (f a)) (eq (f a) (f (f a)))) a congf2) u))) : pf (imp (eq a (f a))  (eq a (f (f a))))." << std::endl;
  }
  else {
    cout << "congf2"
      // << ": pf (all [a:trm] (a == (f a)) imp ((f a) == (f (f a)))) "
	 << " = alli ([a:trm] (a == (f a)) imp ((f a) == (f (f a)))) ([a:trm] impi (a == (f a)) ((f a) == (f (f a))) ([u:pf (a == (f a))] congf a (f a) u))." << std::endl;
    
    cout << "pf2"
      // <<" : pf ((a == (f a)) imp (a == (f (f a)))) "
	 << " = impi (a == (f a)) (a == (f (f a))) ([u: pf(a == (f a))] trans a (f a) (f (f a)) u (mp (a == (f a)) ((f a) == (f (f a))) (alle ([a:trm] (a == (f a)) imp ((f a) == (f (f a)))) a congf2) u))." << std::endl;
  }

  for( int i = 3; i <= n; i++ ) {
    if (implicit) {
      printCongfImplicit(i,cout);
      printProofImplicit(i,cout);
    }
    else if (sc_implicit) {
      printCongfSCImplicit(i,cout);
      printProofSCImplicit(i,cout);
    }
    else if (prefix) {
      printCongfPrefix(i,cout);
      printProofPrefix(i,cout);
    }
    else {
      printCongf(i,cout);
      printProof(i,cout);
    }
  }

  return 0;
}
