module tpctxt where

open import lib
open import fore-types

data uterm : Set where
  Ulam : var → uterm → uterm
  Uapp : uterm → uterm → uterm
  Uvar : var → uterm

is-kind : term → 𝔹
is-kind Star = tt
is-kind (Arrow t1 t2) = is-kind t1 && is-kind t2
is-kind (Parens t) = is-kind t
is-kind _ = ff

size : uterm → ℕ
size (Uvar _) = 1
size (Uapp u1 u2) = suc ((size u1) + (size u2))
size (Ulam _ u) = suc (size u)

{- Our tpctxt belong will map variables x to one of these:

   -- Classifier t' p t u l.  In this case, t' is the classifier, which
      is a type (not a kind); t is the term x is defined to equal; 
      u is the uterm (untyped term) for the erasure of t; and l is tt iff
      this is a local variable.
   -- TpClassifier t p.  t is the kind of x.  Such ctxtElts are only added temporarily, during type checking.
   -- TypeDefinition b k p t.  k is the kind of type t.  b is tt if the definition is recursive, and ff otherwise.
-}

data ctxtElt : Set where
  Classifier : (t : term) → is-kind t ≡ ff → (t' : term) → (u : uterm) → (local : 𝔹) → ctxtElt 
  TpClassifier : (t : term) → is-kind t ≡ tt → ctxtElt 
  TypeDefinition : (b : 𝔹) → (t : term) → is-kind t ≡ tt → term → ctxtElt

-- typing context
tpctxt : Set
tpctxt = (trie ctxtElt) 

-- a helper function for later code
cmds-map : (f : cmd → string) → cmds → string
cmds-map f (CmdsNext Quit cs) = ""
cmds-map f (CmdsNext c cs) = (f c) ^ (cmds-map f cs)
cmds-map f (CmdsStart c) = f c

is-type : tpctxt → term → 𝔹
is-type g (Var x) with trie-lookup g x
... | just (Classifier _ _ _ _ _) = ff
... | just (TpClassifier _ _) = tt
... | just (TypeDefinition _ _ _ _) = tt
... | nothing = ff -- probably should not happen
is-type g (Abstract Lam x t1 t2) with keep (is-kind t1)
... | tt , p = is-type (trie-insert g x (TpClassifier t1 p)) t2
... | ff , p = is-type (trie-insert g x (Classifier t1 p (Var x) (Uvar x) tt)) t2
is-type g (Abstract Forall _ _ _) = tt
is-type g (App t1 _) = is-type g t1
is-type g (Arrow _ _) = tt
is-type g (Parens t) = is-type g t
is-type g _ = ff

