#lang racket

(define numReductions 0)
(provide numReductions)

(define (reset) (set! numReductions 0))
(provide reset)

(define triv (lambda (x) x))
(provide triv)
(define true (lambda (x) (lambda (y) (x triv))))
(provide true)
(define false (lambda (x) (lambda (y) (y triv))))
(provide false)
(define not (lambda (b) ((b (lambda (u) false)) (lambda (u) true))))
(provide not)
(define mkpair (lambda (a) (lambda (b) (lambda (c) ((c a) b)))))
(provide mkpair)
(define Bzero (lambda (z) (lambda (o) (lambda (e) e))))
(provide Bzero)
(define Bz (lambda (n) (lambda (z) (lambda (o) (lambda (e) (z (((n z) o) e)))))))
(provide Bz)
(define Bo (lambda (n) (lambda (z) (lambda (o) (lambda (e) (o (((n z) o) e)))))))
(provide Bo)
(define Boz (lambda (b) (lambda (x) ((b (lambda (u) (Bo x))) (lambda (u) (Bz x))))))
(provide Boz)
(define Bsuc (lambda (n) ((((n (lambda (p) (p (lambda (b) (lambda (x) ((mkpair false) ((Boz b) x))))))) (lambda (p) (p (lambda (b) (lambda (x) ((b (lambda (u) ((mkpair true) (Bz x)))) (lambda (u) ((mkpair false) (Bo x))))))))) ((mkpair true) Bzero)) (lambda (a) (lambda (x) ((a (lambda (u) (Bo x))) (lambda (u) x)))))))
(provide Bsuc)
(define Bone (Bsuc Bzero))
(provide Bone)
(define Czero (lambda (s) (lambda (z) z)))
(provide Czero)
(define Cone (lambda (s) (lambda (z) (s z))))
(provide Cone)
(define Csuc (lambda (n) (lambda (s) (lambda (z) (s ((n s) z))))))
(provide Csuc)
(define Cadd (lambda (n) (lambda (m) (lambda (s) (lambda (z) ((n s) ((m s) z)))))))
(provide Cadd)
(define Cdouble (lambda (n) (lambda (s) (lambda (z) ((n s) ((n s) z))))))
(provide Cdouble)
(define BtoCNath (lambda (f) (lambda (p) (p (lambda (e) (lambda (nn) ((mkpair (Cdouble e)) ((f nn) e))))))))
(provide BtoCNath)
(define BtoCNat (lambda (n) ((((n (BtoCNath (lambda (nn) (lambda (e) nn)))) (BtoCNath Cadd)) ((mkpair Cone) Czero)) (lambda (e) (lambda (nn) nn)))))
(provide BtoCNat)
(define SFzero (lambda (s) (lambda (z) z)))
(provide SFzero)
(define SFone (lambda (s) (lambda (z) ((s Bone) SFzero))))
(provide SFone)
(define SFsuc (lambda (n) ((n (lambda (c) (lambda (p) (lambda (s) (lambda (z) ((s (Bsuc c)) n)))))) SFone)))
(provide SFsuc)
(define SFpred (lambda (n) ((n (lambda (c) (lambda (s) s))) SFzero)))
(provide SFpred)
(define SFadd (lambda (n) (lambda (m) ((n (lambda (c) (lambda (s) (((BtoCNat c) SFsuc) m)))) m))))
(provide SFadd)
(define SFmult (lambda (n) (lambda (m) ((n (lambda (c) (lambda (s) (((BtoCNat c) (SFadd m)) SFzero)))) SFzero))))
(provide SFmult)
(define SFexp (lambda (n) (lambda (m) ((m (lambda (c) (lambda (s) (((BtoCNat c) (SFmult n)) SFone)))) SFone))))
(provide SFexp)
(define SFsubtract (lambda (n) (lambda (m) ((n (lambda (c) (lambda (s) (((BtoCNat c) SFpred) m)))) SFzero))))
(provide SFsubtract)
(define SFtoCNat (lambda (x) ((x (lambda (c) (lambda (s) (BtoCNat c)))) Czero)))
(provide SFtoCNat)
