#lang racket

(define numReductions 0)
(provide numReductions)

(define (reset) (set! numReductions 0))
(provide reset)

(define triv (lambda (x) x))
(provide triv)
(define mkpair (lambda (a) (lambda (b) (lambda (c) ((c a) b)))))
(provide mkpair)
(define true (lambda (x) (lambda (y) (x triv))))
(provide true)
(define false (lambda (x) (lambda (y) (y triv))))
(provide false)
(define not (lambda (b) ((b (lambda (u) false)) (lambda (u) true))))
(provide not)
(define just (lambda (a) (lambda (s) (lambda (n) (s a)))))
(provide just)
(define nothing (lambda (s) (lambda (n) (n triv))))
(provide nothing)
(define zero (lambda (s) (lambda (z) z)))
(provide zero)
(define one (lambda (s) (lambda (z) ((s zero) (lambda (u) z)))))
(provide one)
(define iszero (lambda (n) ((n (lambda (p) (lambda (f) false))) true)))
(provide iszero)
(define suc (lambda (n) (lambda (s) (lambda (z) ((s n) (lambda (u) ((n s) z)))))))
(provide suc)
(define pred (lambda (n) ((n (lambda (p) (lambda (f) p))) zero)))
(provide pred)
(define add (lambda (n) (lambda (m) ((n (lambda (P) (lambda (s) (suc (s triv))))) m))))
(provide add)
(define mult (lambda (n) (lambda (m) ((n (lambda (P) (lambda (s) ((add m) (s triv))))) zero))))
(provide mult)
(define exp (lambda (n) (lambda (m) ((m (lambda (P) (lambda (s) ((mult n) (s triv))))) one))))
(provide exp)
(define lt (lambda (n) ((n (lambda (pn) (lambda (r) (lambda (m) ((m (lambda (pm) (lambda (rr) ((r triv) pm)))) false))))) (lambda (m) (not (iszero m))))))
(provide lt)
(define Czero (lambda (s) (lambda (z) z)))
(provide Czero)
(define Cone (lambda (s) (lambda (z) (s (lambda (u) z)))))
(provide Cone)
(define Csuc (lambda (n) (lambda (s) (lambda (z) (s (lambda (u) ((n s) z)))))))
(provide Csuc)
(define Caddr (lambda (n) (lambda (m) (lambda (s) (lambda (z) ((n s) ((m s) z)))))))
(provide Caddr)
(define getBraunCNat (lambda (b) ((b (lambda (a) Czero)) (lambda (c) (lambda (l) (lambda (r) c))))))
(provide getBraunCNat)
(define braunLeaf (lambda (a) (lambda (l) (lambda (n) (l a)))))
(provide braunLeaf)
(define braunNode (lambda (L) (lambda (R) (lambda (l) (lambda (n) (((n (Csuc (getBraunCNat L))) L) R))))))
(provide braunNode)
(define braunPair (lambda (a) (lambda (aa) ((braunNode (braunLeaf a)) (braunLeaf aa)))))
(provide braunPair)
(define braunInsert (lambda (a) (lambda (b) ((((getBraunCNat b) (lambda (r) (lambda (b) ((b (lambda (aa) ((braunPair a) aa))) (lambda (q) (lambda (L) (lambda (R) ((braunNode ((r triv) R)) L)))))))) (lambda (b) ((b (lambda (aa) ((braunPair a) aa))) (lambda (q) (lambda (L) (lambda (R) L)))))) b))))
(provide braunInsert)
(define getLen (lambda (l) ((l (lambda (e) (lambda (a) (lambda (lp) e)))) Czero)))
(provide getLen)
(define Nil (lambda (c) (lambda (n) n)))
(provide Nil)
(define Cons (lambda (a) (lambda (l) (lambda (c) (lambda (n) (((c (Csuc (getLen l))) a) l))))))
(provide Cons)
(define singleton (lambda (a) (lambda (c) (lambda (n) (((c Cone) a) Nil)))))
(provide singleton)
(define listToBraunTree (lambda (a) (lambda (l) ((((getLen l) (lambda (u) (lambda (l) ((l (lambda (i) (lambda (a) (lambda (lp) ((braunInsert a) ((u triv) lp)))))) (braunLeaf a))))) (lambda (u) (braunLeaf a))) l))))
(provide listToBraunTree)
(define natsBelow (lambda (n) ((n (lambda (p) (lambda (l) ((Cons p) (l triv))))) Nil)))
(provide natsBelow)
(define append (lambda (la) (lambda (lb) ((((getLen la) (lambda (u) (lambda (l) ((l (lambda (i) (lambda (a) (lambda (lp) ((Cons a) ((u triv) lp)))))) Nil)))) (lambda (q) lb)) la))))
(provide append)
(define appendRepeat (lambda (n) (lambda (l) ((n (lambda (p) (lambda (ll) ((append l) (ll triv))))) Nil))))
(provide appendRepeat)
(define head (lambda (l) ((l (lambda (n) (lambda (a) (lambda (lp) (just a))))) nothing)))
(provide head)
(define tail (lambda (l) ((l (lambda (n) (lambda (a) (lambda (lp) lp)))) l)))
(provide tail)
(define nthTail (lambda (n) (lambda (l) ((n (lambda (p) (lambda (r) (tail (r triv))))) l))))
(provide nthTail)
(define nth (lambda (n) (lambda (l) (head ((nthTail n) l)))))
(provide nth)
(define PNil (lambda (c) (lambda (n) n)))
(provide PNil)
(define PCons (lambda (a) (lambda (l) (lambda (c) (lambda (n) (((c a) l) (lambda (u) ((l c) n))))))))
(provide PCons)
(define toPList (lambda (l) ((((getLen l) (lambda (u) (lambda (l) ((l (lambda (i) (lambda (a) (lambda (lp) ((PCons a) ((u triv) lp)))))) PNil)))) (lambda (u) PNil)) l)))
(provide toPList)
(define merge (lambda (cmp) (lambda (la) (lambda (lb) ((((((Caddr (getLen la)) (getLen lb)) (lambda (r) (lambda (la) (lambda (lb) ((la (lambda (ca) (lambda (a) (lambda (pa) ((lb (lambda (cb) (lambda (b) (lambda (pb) ((((cmp a) b) (lambda (u) ((Cons a) (((r triv) pa) lb)))) (lambda (u) ((Cons b) (((r triv) la) pb)))))))) la))))) lb))))) (lambda (la) (lambda (lb) Nil))) la) lb)))))
(provide merge)
(define mergeSort (lambda (cmp) (lambda (la) ((la (lambda (i) (lambda (a) (lambda (laa) ((lambda (b) ((((getBraunCNat b) (lambda (r) (lambda (x) ((x singleton) (lambda (q) (lambda (L) (lambda (R) (((merge cmp) ((r triv) L)) ((r triv) R))))))))) (lambda (b) ((b singleton) (lambda (q) (lambda (L) (lambda (R) Nil)))))) b)) ((listToBraunTree a) laa)))))) Nil))))
(provide mergeSort)
