{-# OPTIONS_GHC -XFlexibleInstances #-}
module ObserveLists where

import Lists

cnatToInt :: CNat -> Int
cnatToInt n = unfoldCNat n (\ x -> 1 + x) 0

natToInt :: Nat -> Int
natToInt n = unfoldNat n (\ x y -> 1 + y) 0

plistToList :: PList Nat -> [Int]
plistToList n = unfoldPList n (\ h s t -> natToInt h : t) []

toList :: List Nat -> [Int]
toList n = plistToList (toPList n)

instance Show (PList Nat) where
  show n = show (plistToList n)

instance Show CNat where
  show n = show (cnatToInt n)
 
instance Show Nat where
  show n = show (natToInt n)
 
instance Show (List Nat) where
  show n = show (toList n)

instance Show (Maybee Nat) where
  show n = unfoldMaybee n (\ x -> "just " ++ (show x)) "nothing"

