{-# OPTIONS_GHC -XFlexibleInstances #-}
module Observe where

import Nats
import Lists

toInt :: PNat -> Int
toInt n = unfoldPNat n (\ x y -> 1 + y) 0

toIntb :: Nat -> Int
toIntb n = unfoldNat n (\ x y -> 1 + y) 0

toList :: List Nat -> [Int]
toList n = unfoldList n (\ h s t -> toIntb h : t) []

instance Show PNat where
  show n = show (toInt n)

instance Show Nat where
  show n = show (toIntb n)

instance Show (List Nat) where
  show n = show (toList n)

instance Show (Maybee Nat) where
  show n = unfoldMaybee n (\ x -> "just " ++ (show x)) "nothing"