{-# OPTIONS_GHC -XRankNTypes -XKindSignatures #-}

import Control.Monad.State

type S = State Int

incr :: S ()
incr = do
  c <- get
  put (c+1)

newtype CNat = FoldCNat { unfoldCNat :: forall x. (x -> S x) -> S (x -> S x) }

zero :: CNat
zero = FoldCNat (\ s -> return (\ z -> return z))

suc :: CNat -> S CNat
suc x = return $ FoldCNat (\ s -> return (\ z -> 
                                  do
                                    incr
                                    f <- (unfoldCNat x s)
                                    incr
                                    r <- f z
                                    incr
                                    s r)) 
add :: CNat -> S (CNat -> S CNat)
add x = return (\ y -> 
                 do 
                   f <- unfoldCNat x suc 
                   incr
                   f y)

test :: S CNat
test = do
         n <- (suc zero) 
         incr
         f <- add n
         incr
         f n

toInt :: CNat -> Int
toInt n = evalState
            (do
                f <- unfoldCNat n (\ x -> return (1 + x))
                f 0)
            0

instance Show CNat where
  show n = show (toInt n)
  
showWithReductions :: S CNat -> (Int , Int)
showWithReductions x = let (v,s) = runState x 0 in
                           (s , toInt v)
                             