open import automaton
open import parse-tree

module parse-wf ( ptr : ParseTreeRec )(state : Set)( aut : automaton state) where

open import lib
open import run ptr state aut public
open ParseTreeRec ptr
open automaton.automaton aut

module parse (rrs : rewriteRules) where

  open rewriteRules rrs

  ----------------------------------------------------------------------
  -- code to run the automaton on a list of characters
  ----------------------------------------------------------------------
  
  runState : {lc : 𝕃 char} → Set
  runState{lc} = (state × 𝕃 char) ⊎ Run lc
  
  
  mutual 
  
    computeRun : state → (lc : 𝕃 char) → runState{lc}
    computeRun s cs = epsilonStep (node s (eps s)) cs
  
    epsilonStep : 𝕋 state → (lc : 𝕃 char) → runState{lc}
    epsilonStep (node s []) cs = labeledStep s cs
    epsilonStep (node s ts) cs = (epsilonSteps s ts cs) ≫=⊎ (λ r → return⊎ ((State s) ::' r))
  
    epsilonSteps : state → 𝕃 (𝕋 state) → (lc : 𝕃 char) → runState{lc}
    epsilonSteps s [] cs = inj₁ (s , cs)
    epsilonSteps s (t :: ts) cs with epsilonStep t cs
    epsilonSteps s (t :: ts) cs | inj₂ r = inj₂ r
    epsilonSteps s (t :: ts) cs | inj₁ ( s' , cs') with epsilonSteps s ts cs
    epsilonSteps s (t :: ts) cs | inj₁ ( s' , cs') | inj₂ r = inj₂ r
    epsilonSteps s (t :: ts) cs | inj₁ ( s' , cs') | inj₁ (s'' , cs'') = inj₁ (s' , cs') 

    labeledStep : state → (lc : 𝕃 char) → runState{lc}
    labeledStep s [] = if is-final s then return⊎ (State s ::' []') else inj₁ (s , [])
    labeledStep s (c :: cs) with next s c 
    ... | just s' = (computeRun s' cs) ≫=⊎ (λ r → return⊎ ((State s) ::' (InputChar c) ::' r))
    ... | nothing = inj₁ (s , (c :: cs))

  runAut : (lc : 𝕃 char) → runState{lc}
  runAut lc = computeRun start lc

  runState-to-string : {lc : 𝕃 char} → runState{lc} → string
  runState-to-string (inj₁ (s , cs)) = 
    "Failing run ends in state " ^ (state-to-string s) ^ ", with the following remaining string:\n" ^ (𝕃char-to-string cs)
  runState-to-string (inj₂ r) = Run-to-string r

  ----------------------------------------------------------------------
  -- code to apply run-rewriting rules to a run
  ----------------------------------------------------------------------

  apply-unit-rules : {lc : 𝕃 char} → (r : Run lc) → (n : ℕ) → Σ (Run lc) (λ r' → length-run r' =ℕ length-run r ≡ tt)
  apply-unit-rules r 0 = (r , =ℕ-from-≡{length-run r} refl)
  apply-unit-rules{s} r (suc n) with unit-rewrite r
  ... | nothing = (r , =ℕ-from-≡{length-run r} refl)
  ... | just (r' , p) with apply-unit-rules{s} r' n 
  ... | (r'' , p') rewrite =ℕ-to-≡{length-run r'} p = ( r'' , p')

  -- apply the length-decreasing rewrite rules exhaustively to a run, also applying the unit rules
  apply-len-dec-rules : {lc : 𝕃 char} → (r : Run lc) → WfStructBool _<_ (length-run r) → Σ (Run lc) (λ r' → length-run r' ≤ length-run r ≡ tt)
  apply-len-dec-rules []' _ = ([]' , refl)
  apply-len-dec-rules (e ::' r') (WfStep wfr)
    with apply-len-dec-rules r' (wfr (<-suc (length-run r'))) 
  ... | (r'' , p) with (apply-unit-rules (e ::' r'') unit-rewrite-iters)
  ... | ( r1a , p1a) with (len-dec-rewrite r1a) | =ℕ-to-≡ {length-run r1a} p1a
  ... | nothing | u = (r1a , lem) 
                       where lem : length-run r1a ≤ suc (length-run r') ≡ tt
                             lem rewrite u = p
  ... | (just (r2a , p'')) | u = 
        let p3 : length-run r2a < suc (length-run r') ≡ tt
            p3 = (<≤-trans {length-run r2a} p'' lem) in
            proc3 (apply-len-dec-rules r2a (wfr p3)) p3
                where lem : length-run r1a ≤ suc (length-run r') ≡ tt
                      lem rewrite u = p
                      proc3 : {lc : 𝕃 char} → Σ (Run lc) (λ r2 → length-run r2 ≤ length-run r2a ≡ tt) → 
                              length-run r2a < suc (length-run r') ≡ tt → 
                              Σ (Run lc) (λ r3 → length-run r3 ≤ suc (length-run r') ≡ tt)
                      proc3 (r2 , p2) p3 = (r2 , ||-cong₁ (≤<-trans {length-run r2} p2 p3))

  rewriteRun : {lc : 𝕃 char} → (Run lc) → (Run lc)
  rewriteRun r with apply-len-dec-rules r (wf-< (length-run r)) 
  ... | (r' , _) = r'

  parse : (lc : 𝕃 char) → runState{lc}
  parse s = (runAut s) ≫=⊎ (λ r → return⊎ (rewriteRun r))
