;;; fore-mode.el --- Major mode for Fore

;;; Commentary:

;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Dependency


;;; Code:

(defvar fore-version "0.1"
  "The version of the fore mode.")

(require 'quail)

(setq auto-mode-alist (cons (cons "\\.fore\\'" 'fore-mode) auto-mode-alist))

(modify-coding-system-alist 'file "\\.fore\\'" 'utf-8)

(with-temp-buffer
    (quail-define-package "Fore" "UTF-8" "δ" t ; guidance
     "Fore input method."
     nil nil nil nil nil nil t ; maximum-shortest
     ))

(eval `(define-derived-mode fore-mode
  ,(if (fboundp 'prog-mode) 'prog-mode)
  "Fore"
  "Major mode for Fore files."

 (set-input-method "Fore")
 (mapc (lambda (pair) (quail-defrule (car pair) (cadr pair) "Fore"))
	'(("\\Gl" "λ") ("\\r" "→") ("\\all" "∀") ))
))

;("\\s" "↢")

(provide 'fore-mode)
;;; fore-mode.el ends here
