#lang racket

(define numReductions 0)
(provide numReductions)

(define (reset) (set! numReductions 0))
(provide reset)

(define triv (lambda (x) x))
(provide triv)
(define mkpair (lambda (a) (lambda (b) (lambda (c) ((c a) b)))))
(provide mkpair)
(define true (lambda (x) (lambda (y) (x triv))))
(provide true)
(define false (lambda (x) (lambda (y) (y triv))))
(provide false)
(define not (lambda (b) ((b (lambda (u) false)) (lambda (u) true))))
(provide not)
(define just (lambda (a) (lambda (s) (lambda (n) (s a)))))
(provide just)
(define nothing (lambda (s) (lambda (n) (n triv))))
(provide nothing)
(define zero (lambda (s) (lambda (z) z)))
(provide zero)
(define one (lambda (s) (lambda (z) ((s zero) (lambda (u) z)))))
(provide one)
(define iszero (lambda (n) ((n (lambda (p) (lambda (f) false))) true)))
(provide iszero)
(define suc (lambda (n) (lambda (s) (lambda (z) ((s n) (lambda (u) ((n s) z)))))))
(provide suc)
(define pred (lambda (n) ((n (lambda (p) (lambda (f) p))) zero)))
(provide pred)
(define add (lambda (n) (lambda (m) ((n (lambda (P) (lambda (s) (suc (s triv))))) m))))
(provide add)
(define mult (lambda (n) (lambda (m) ((n (lambda (P) (lambda (s) ((add m) (s triv))))) zero))))
(provide mult)
(define exp (lambda (n) (lambda (m) ((m (lambda (P) (lambda (s) ((mult n) (s triv))))) one))))
(provide exp)
(define lt (lambda (n) ((n (lambda (pn) (lambda (r) (lambda (m) ((m (lambda (pm) (lambda (rr) ((r triv) pm)))) false))))) (lambda (m) (not (iszero m))))))
(provide lt)
(define braunLeaf (lambda (a) (lambda (l) (lambda (n) (l a)))))
(provide braunLeaf)
(define braunNode (lambda (L) (lambda (R) (lambda (l) (lambda (n) ((n ((L l) n)) ((R l) n)))))))
(provide braunNode)
(define braunInsert (lambda (a) (lambda (b) (((b (lambda (aa) ((mkpair (braunLeaf aa)) ((braunNode (braunLeaf a)) (braunLeaf aa))))) (lambda (pL) (lambda (pR) (pL (lambda (L) (lambda (iL) (pR (lambda (R) (lambda (iR) ((mkpair ((braunNode L) R)) ((braunNode iR) L))))))))))) (lambda (b) (lambda (ib) ib))))))
(provide braunInsert)
(define Nil (lambda (c) (lambda (n) n)))
(provide Nil)
(define Cons (lambda (a) (lambda (l) (lambda (c) (lambda (n) ((c a) (lambda (u) ((l c) n))))))))
(provide Cons)
(define singleton (lambda (a) (lambda (c) (lambda (n) ((c a) (lambda (u) n))))))
(provide singleton)
(define listToBraunTree (lambda (a) (lambda (l) ((l (lambda (a) (lambda (r) ((braunInsert a) (r triv))))) (braunLeaf a)))))
(provide listToBraunTree)
(define natsBelow (lambda (n) ((n (lambda (p) (lambda (l) ((Cons p) (l triv))))) Nil)))
(provide natsBelow)
(define append (lambda (la) (lambda (lb) ((la (lambda (a) (lambda (r) ((Cons a) (r triv))))) lb))))
(provide append)
(define appendRepeat (lambda (n) (lambda (l) ((n (lambda (p) (lambda (ll) ((append l) (ll triv))))) Nil))))
(provide appendRepeat)
(define tail (lambda (l) (((l (lambda (a) (lambda (p) ((p triv) (lambda (x) (lambda (y) ((mkpair y) ((Cons a) y)))))))) ((mkpair Nil) Nil)) (lambda (x) (lambda (y) x)))))
(provide tail)
(define head (lambda (l) ((l (lambda (a) (lambda (t) (just a)))) nothing)))
(provide head)
(define nthTail (lambda (n) (lambda (l) ((n (lambda (p) (lambda (r) (tail (r triv))))) l))))
(provide nthTail)
(define nth (lambda (n) (lambda (l) (head ((nthTail n) l)))))
(provide nth)
(define merge (lambda (cmp) (lambda (la) (((la (lambda (a) (lambda (outer) (lambda (la) (lambda (lb) (((head la) (lambda (ha) (((lb (lambda (b) (lambda (inner) (lambda (lb) (((head lb) (lambda (hb) ((((cmp ha) hb) (lambda (u) ((Cons ha) (((outer triv) (tail la)) lb)))) (lambda (u) ((Cons hb) ((inner triv) (tail lb))))))) (lambda (u) la)))))) (lambda (lb) la)) lb))) (lambda (u) lb))))))) (lambda (la) (lambda (lb) lb))) la))))
(provide merge)
(define mergeSort (lambda (cmp) (lambda (la) (((head la) (lambda (a) ((((listToBraunTree a) (tail la)) singleton) (lambda (la) (lambda (lb) (((merge cmp) la) lb)))))) (lambda (u) Nil)))))
(provide mergeSort)
