module test-fore where

open import lib
open import my-fore-main
open import tpctxt
open import untyped-lam
open import fore-types
open import term-to-string

g1 = trie-insert empty-trie "X" (TpClassifier Star refl)
t1 = classify g1 (Abstract Lam "x" (Var "X") (Var "x"))

t3 = (Abstract Lam "x" Star (Var "y"))
g3 = trie-insert empty-trie "x" (TpClassifier Star refl)
r3 = empty-renamectxt
re3 = rename-away-from "y" (trie-contains g3) r3
s3 = subst g3 r3 (Var "x") "y" t3

lam : string → term → term 
lam x t = Abstract Lam x (Var "omitted") t

czero = lam "X" (lam "s" (lam "z" (Var "z")))

cone = lam "X" (lam "s" (lam "z" (App (Var "s") (Var "z"))))

csuc = lam "X" (lam "s" (lam "z" (App (Var "s") (Var "z"))))

mkpair = lam "A" (lam "B" (lam "a" (lam "b" (lam "X" (lam "c" (App (App (Var "c") (Var "a")) (Var "b")))))))

inl = lam "A" (lam "B" (lam "a" (lam "X" (lam "c" (lam "d" (App (Var "c") (Var "a")))))))

inr = lam "A" (lam "B" (lam "b" (lam "X" (lam "cc" (lam "dd" (App (Var "dd") (Var "b")))))))

st = (Var "sometype") 

trv = lam "X" (lam "x" (Var "x"))

sfzero = App (FoldUnfold "sfnata" Fold) (App (App (App inl st) st) trv)
sfone = App (FoldUnfold "sfnatb" Fold) (App (App (App inr st) st) (App (App (App (App mkpair st) st) cone) sfzero))

sfsuc = lam "a" (App (FoldUnfold "sfnatty" Fold) (App (App (App inr st) st)
                                                 (App (App (App (App (FoldUnfold "sfnat" Unfold) (Var "a")) st)
                                                       (lam "u" (App (App (App (App mkpair st) st) cone) sfzero)))
                                                       (lam "p" (App (App (Var "p") st) 
                                                                     (lam "c" (lam "s" (App (App (App (App mkpair st) st) (App csuc (Var "c"))) (Var "a")))))))))

sftesta = App sfsuc sfzero

n4a = term-to-string (norm empty-trie empty-renamectxt sftesta)


test5 = only-polarity "bad" (Arrow (Arrow (Var "unit") (Var "bad")) (Var "bad")) pos 

test6 = only-polarity "ok" (Arrow (Arrow (Var "ok") (Var "unit")) (Var "unit")) pos 

test7 = erase empty-trie (Abstract Lam "X" Star (Abstract Lam "s" (Arrow (Var "X") (Var "X")) (Abstract Lam "z" (Var "X") (App (Var "s") (Var "z")))))

c8 = (trie-insert
        (trie-insert empty-trie "Observer" 
          (TypeDefinition ff (Arrow Star (Arrow Star Star))
            refl (Abstract Lam "A" Star (Abstract All "X" Star (Arrow (Arrow (Arrow (Var "A") (Var "A")) (Var "X")) (Var "X"))))))
        "Obst"
        (TypeDefinition ff (Arrow Star (Arrow Star Star))
           refl (Abstract Lam "A" Star (Abstract Lam "X" Star (Arrow (Arrow (Var "A") (Var "A")) (Var "X"))))))

e8 = eq-type c8 empty-trie (App (Var "Observer") (Var "A"))
      (Abstract All "X" Star (Arrow (App (App (Var "Obst") (Var "A")) (Var "X")) (Var "X")))

c8b = (trie-insert
        (trie-insert empty-trie "Observer" 
          (TypeDefinition ff Star
            refl (Arrow (Arrow (Var "unit")(Var "unit"))(Var "unit"))))
        "Obst"
        (TypeDefinition ff Star
           refl (Arrow (Var "unit")(Var "unit"))))

e8b = eq-type c8b empty-trie (Var "Observer") (Arrow (Var "Obst") (Var "unit"))
e8ba = eq-type c8b empty-trie (Arrow (Arrow (Var "unit")(Var "unit"))(Var "unit")) (Arrow (Var "Obst") (Var "unit"))
