{-# OPTIONS_GHC -XRankNTypes -XKindSignatures #-}
module Lists where
import System.IO.Unsafe
import Data.IORef

numReductions :: IORef Int
{-# NOINLINE numReductions #-}
numReductions = unsafePerformIO (newIORef 0)

incr :: a -> a
incr r = unsafePerformIO
           (do
               x <- readIORef numReductions
               writeIORef numReductions (x + 1)
               return r)

reset :: a -> a
reset r = unsafePerformIO
           (do
               writeIORef numReductions 0
               return r)

getNumReds :: () -> Int
getNumReds () = (unsafePerformIO (readIORef numReductions))
newtype Boole  = FoldBoole { unfoldBoole :: forall (x :: *) . x -> x -> x}

true :: Boole
true = (FoldBoole (\ a -> (\ b -> a)))

false :: Boole
false = (FoldBoole (\ a -> (\ b -> b)))

nott :: Boole -> Boole
nott = (\ b -> (((unfoldBoole b) false) true))

newtype Maybee a = FoldMaybee { unfoldMaybee :: forall (x :: *) . (a -> x) -> x -> x}

just :: forall (a :: *) . a -> Maybee a
just = (\ u -> (FoldMaybee (\ s -> (\ n -> (s u)))))

nothing :: forall (a :: *) . Maybee a
nothing = (FoldMaybee (\ s -> (\ n -> n)))

newtype Nat  = FoldNat { unfoldNat :: forall (x :: *) . (Nat -> x -> x) -> x -> x}

zero :: Nat
zero = (FoldNat (\ s -> (\ z -> z)))

one :: Nat
one = (FoldNat (\ s -> (\ z -> ((s zero) z))))

iszero :: Nat -> Boole
iszero = (\ n -> ((((unfoldNat n) (\ p -> (\ f -> false)))) true))

suc :: Nat -> Nat
suc = (\ n -> (FoldNat (\ s -> (\ z -> ((s n) ((((unfoldNat n) s) z)))))))

add :: Nat -> Nat -> Nat
add = (\ n -> (\ m -> ((((unfoldNat n) (\ p -> suc))) m)))

mult :: Nat -> Nat -> Nat
mult = (\ n -> (\ m -> ((((unfoldNat n) (\ p -> (add m)))) zero)))

exp :: Nat -> Nat -> Nat
exp = (\ n -> (\ m -> ((((unfoldNat m) (\ p -> (mult n)))) one)))

prd :: Nat -> Nat
prd = (\ n -> ((((unfoldNat n) (\ p -> (\ d -> p)))) zero))

lt :: Nat -> Nat -> Boole
lt = (\ n -> ((((unfoldNat n) (\ pn -> (\ r -> (\ m -> ((((unfoldNat m) (\ pm -> (\ rr -> (r pm))))) false)))))) (\ m -> (nott ((iszero m))))))

newtype CNat  = FoldCNat { unfoldCNat :: forall (x :: *) . (x -> x) -> x -> x}

czero :: CNat
czero = (FoldCNat (\ s -> (\ z -> z)))

cone :: CNat
cone = (FoldCNat (\ s -> (\ z -> (s z))))

csuc :: CNat -> CNat
csuc = (\ n -> (FoldCNat (\ s -> (\ z -> (s ((((unfoldCNat n) s) z)))))))

caddR :: CNat -> CNat -> CNat
caddR = (\ n -> (\ m -> (FoldCNat (\ s -> (\ z -> (((unfoldCNat n) s) ((((unfoldCNat m) s) z))))))))

newtype Braun a = FoldBraun { unfoldBraun :: forall (x :: *) . (a -> x) -> (CNat -> Braun a -> Braun a -> x) -> x}

getBraunCNat :: forall (a :: *) . Braun a -> CNat
getBraunCNat = (\ b -> ((((unfoldBraun b) (\ a -> czero))) (\ c -> (\ l -> (\ r -> c)))))

braunLeaf :: forall (a :: *) . a -> Braun a
braunLeaf = (\ u -> (FoldBraun (\ l -> (\ n -> (l u)))))

braunNode :: forall (a :: *) . Braun a -> Braun a -> Braun a
braunNode = (\ l -> (\ r -> (FoldBraun (\ ll -> (\ n -> (((n ((csuc ((getBraunCNat l))))) l) r))))))

braunPair :: forall (a :: *) . a -> a -> Braun a
braunPair = (\ u -> (\ aa -> ((braunNode ((braunLeaf u))) ((braunLeaf aa)))))

braunInsert :: forall (a :: *) . a -> Braun a -> Braun a
braunInsert = (\ u -> (\ b -> ((((((unfoldCNat ((getBraunCNat b))) (\ r -> (\ b -> ((((unfoldBraun b) (\ aa -> ((braunPair u) aa)))) (\ q -> (\ ll -> (\ rr -> ((braunNode ((r rr))) ll))))))))) (\ b -> ((((unfoldBraun b) (\ aa -> ((braunPair u) aa)))) (\ q -> (\ ll -> (\ rr -> ll))))))) b)))

newtype List a = FoldList { unfoldList :: forall (x :: *) . (CNat -> a -> List a -> x) -> x -> x}

getLen :: forall (a :: *) . List a -> CNat
getLen = (\ l -> ((((unfoldList l) (\ e -> (\ u -> (\ lp -> e))))) czero))

nil :: forall (a :: *) . List a
nil = (FoldList (\ c -> (\ n -> n)))

cons :: forall (a :: *) . a -> List a -> List a
cons = (\ u -> (\ l -> (FoldList (\ c -> (\ n -> (((c ((csuc ((getLen l))))) u) l))))))

singleton :: forall (a :: *) . a -> List a
singleton = (\ u -> (FoldList (\ c -> (\ n -> (((c cone) u) (nil))))))

listToBraunTree :: forall (a :: *) . a -> List a -> Braun a
listToBraunTree = (\ v -> (\ l -> ((((((unfoldCNat ((getLen l))) (\ u -> (\ l -> ((((unfoldList l) (\ i -> (\ v -> (\ lp -> ((braunInsert v) ((u lp)))))))) ((braunLeaf v))))))) (\ x -> (braunLeaf v)))) l)))

natsBelow :: Nat -> List Nat
natsBelow = (\ n -> ((((unfoldNat n) (\ p -> (\ l -> ((cons p) l))))) (nil)))

append :: forall (a :: *) . List a -> List a -> List a
append = (\ la -> (\ lb -> ((((((unfoldCNat ((getLen la))) (\ u -> (\ l -> ((((unfoldList l) (\ i -> (\ v -> (\ lp -> ((cons v) ((u lp)))))))) (nil)))))) (\ q -> lb))) la)))

appendRepeat :: Nat -> forall (a :: *) . List a -> List a
appendRepeat = (\ n -> (\ l -> ((((unfoldNat n) (\ p -> (\ ll -> ((append l) ll))))) (nil))))

hd :: forall (a :: *) . List a -> Maybee a
hd = (\ l -> ((((unfoldList l) (\ n -> (\ u -> (\ lp -> (just u)))))) (nothing)))

tl :: forall (a :: *) . List a -> List a
tl = (\ l -> ((((unfoldList l) (\ n -> (\ u -> (\ lp -> lp))))) l))

nthTl :: Nat -> forall (a :: *) . List a -> List a
nthTl = (\ n -> (\ l -> ((((unfoldNat n) (\ p -> (\ r -> (tl r))))) l)))

nth :: Nat -> forall (a :: *) . List a -> Maybee a
nth = (\ n -> (\ l -> (hd (((nthTl n) l)))))

newtype PList a = FoldPList { unfoldPList :: forall (x :: *) . (a -> PList a -> x -> x) -> x -> x}

pnil :: forall (a :: *) . PList a
pnil = (FoldPList (\ c -> (\ n -> n)))

pcons :: forall (a :: *) . a -> PList a -> PList a
pcons = (\ u -> (\ l -> (FoldPList (\ c -> (\ n -> (((c u) l) ((((unfoldPList l) c) n))))))))

toPList :: forall (a :: *) . List a -> PList a
toPList = (\ l -> ((((((unfoldCNat ((getLen l))) (\ u -> (\ l -> ((((unfoldList l) (\ i -> (\ v -> (\ lp -> ((pcons v) ((u lp)))))))) (pnil)))))) (\ u -> pnil))) l))

merge :: forall (a :: *) . (a -> a -> Boole) -> List a -> List a -> List a
merge = (\ cmp -> (\ la -> (\ lb -> (((((((unfoldCNat (((caddR ((getLen la))) ((getLen lb))))) (\ r -> (\ la -> (\ lb -> ((((unfoldList la) (\ ca -> (\ u -> (\ pa -> ((((unfoldList lb) (\ cb -> (\ v -> (\ pb -> (((unfoldBoole (((cmp u) v))) (((cons u) (((r pa) lb))))) (((cons v) (((r la) pb)))))))))) la)))))) lb)))))) (\ la -> (\ lb -> nil)))) la) lb))))

mergeSort :: forall (a :: *) . (a -> a -> Boole) -> List a -> List a
mergeSort = (\ cmp -> (\ la -> ((((unfoldList la) (\ i -> (\ u -> (\ laa -> (((\ b -> ((((((unfoldCNat ((getBraunCNat b))) (\ r -> (\ x -> (((unfoldBraun x) (singleton)) (\ q -> (\ ll -> (\ rr -> (((merge cmp) ((r ll))) ((r rr))))))))))) (\ x -> (((unfoldBraun x) (singleton)) (\ q -> (\ ll -> (\ rr -> nil))))))) b))) (((listToBraunTree u) laa)))))))) (nil))))

