{-# OPTIONS_GHC -XRankNTypes -XKindSignatures #-}
module Nats where
import System.IO.Unsafe
import Data.IORef

numReductions :: IORef Int
{-# NOINLINE numReductions #-}
numReductions = unsafePerformIO (newIORef 0)

incr :: a -> a
incr r = unsafePerformIO
           (do
               x <- readIORef numReductions
               writeIORef numReductions (x + 1)
               return r)

reset :: a -> a
reset r = unsafePerformIO
           (do
               writeIORef numReductions 0
               return r)

getNumReds :: () -> Int
getNumReds () = (unsafePerformIO (readIORef numReductions))
newtype CNat  = FoldCNat { unfoldCNat :: forall (x :: *) . (x -> x) -> x -> x}

czero :: CNat
czero = (FoldCNat (\ s -> (\ z -> z)))

cone :: CNat
cone = (FoldCNat (\ s -> (\ z -> (s z))))

csuc :: CNat -> CNat
csuc = (\ n -> (FoldCNat (\ s -> (\ z -> (s ((((unfoldCNat n) s) z)))))))

newtype SFNat  = FoldSFNat { unfoldSFNat :: forall (x :: *) . (CNat -> SFNat -> x) -> x -> x}

sfzero :: SFNat
sfzero = (FoldSFNat (\ s -> (\ z -> z)))

sfone :: SFNat
sfone = (FoldSFNat (\ s -> (\ z -> ((s cone) sfzero))))

sfsuc :: SFNat -> SFNat
sfsuc = (\ n -> ((((unfoldSFNat n) (\ c -> (\ p -> (FoldSFNat (\ s -> (\ z -> ((s ((csuc c))) n)))))))) sfone))

sfpred :: SFNat -> SFNat
sfpred = (\ n -> ((((unfoldSFNat n) (\ c -> (\ s -> s)))) sfzero))

sfadd :: SFNat -> SFNat -> SFNat
sfadd = (\ n -> (\ m -> ((((unfoldSFNat n) (\ c -> (\ s -> (((unfoldCNat c) sfsuc) m))))) m)))

sfmult :: SFNat -> SFNat -> SFNat
sfmult = (\ n -> (\ m -> ((((unfoldSFNat n) (\ c -> (\ s -> (((unfoldCNat c) ((sfadd m))) sfzero))))) sfzero)))

sfexp :: SFNat -> SFNat -> SFNat
sfexp = (\ n -> (\ m -> ((((unfoldSFNat m) (\ c -> (\ s -> (((unfoldCNat c) ((sfmult n))) sfone))))) sfone)))

sfsubtract :: SFNat -> SFNat -> SFNat
sfsubtract = (\ n -> (\ m -> ((((unfoldSFNat n) (\ c -> (\ s -> (((unfoldCNat c) sfpred) m))))) sfzero)))

sftocnat :: SFNat -> CNat
sftocnat = (\ x -> ((((unfoldSFNat x) (\ c -> (\ s -> c)))) czero))

