{-# OPTIONS_GHC -XRankNTypes -XKindSignatures #-}
module Nats where
import System.IO.Unsafe
import Data.IORef

numReductions :: IORef Int
{-# NOINLINE numReductions #-}
numReductions = unsafePerformIO (newIORef 0)

incr :: a -> a
incr r = unsafePerformIO
           (do
               x <- readIORef numReductions
               writeIORef numReductions (x + 1)
               return r)

reset :: a -> a
reset r = unsafePerformIO
           (do
               writeIORef numReductions 0
               return r)

getNumReds :: () -> Int
getNumReds () = (unsafePerformIO (readIORef numReductions))
newtype PNat  = FoldPNat { unfoldPNat :: forall (x :: *) . (PNat -> x -> x) -> x -> x}

pzero :: PNat
pzero = (FoldPNat (\ s -> (\ z -> z)))

pone :: PNat
pone = (FoldPNat (\ s -> (\ z -> ((s pzero) z))))

psuc :: PNat -> PNat
psuc = (\ n -> (FoldPNat (\ s -> (\ z -> ((s n) ((((unfoldPNat n) s) z)))))))

padd :: PNat -> PNat -> PNat
padd = (\ n -> (\ m -> ((((unfoldPNat n) (\ p -> psuc))) m)))

pmult :: PNat -> PNat -> PNat
pmult = (\ n -> (\ m -> ((((unfoldPNat n) (\ p -> (padd m)))) pzero)))

pexp :: PNat -> PNat -> PNat
pexp = (\ n -> (\ m -> ((((unfoldPNat m) (\ p -> (pmult n)))) pone)))

ppred :: PNat -> PNat
ppred = (\ n -> ((((unfoldPNat n) (\ p -> (\ d -> p)))) pzero))

psubtract :: PNat -> PNat -> PNat
psubtract = (\ n -> (\ m -> ((((unfoldPNat m) (\ p -> ppred))) n)))

