open import lib

data Braun(A : Set) : Set where
  braunLeaf : A → Braun A
  braunNode : Braun A → Braun A → Braun A

braunInsert : {A : Set} → A → Braun A → Braun A
braunInsert a (braunLeaf a') = braunNode (braunLeaf a) (braunLeaf a') 
braunInsert a (braunNode l r) = braunNode (braunInsert a r) l

listToBraunTree : {A : Set} → A → 𝕃 A → Braun A
listToBraunTree a [] = braunLeaf a
listToBraunTree a (a' :: as) = braunInsert a (listToBraunTree a' as)

merge : {A : Set} → (A → A → 𝔹) → 𝕃 A → 𝕃 A → 𝕃 A
merge _ [] ys = ys
merge _ xs [] = xs
merge cmp (x :: xs) (y :: ys) = 
  if cmp x y then x :: (merge cmp xs (y :: ys)) 
             else y :: (merge cmp (x :: xs) ys)

mergeSorth : {A : Set} → (A → A → 𝔹) → Braun A → 𝕃 A
mergeSorth _ (braunLeaf a) = [ a ]
mergeSorth cmp (braunNode l r) = merge cmp (mergeSorth cmp l) (mergeSorth cmp r) 

mergeSort : {A : Set} → (A → A → 𝔹) → 𝕃 A → 𝕃 A
mergeSort _ [] = []
mergeSort cmp (a :: as) = mergeSorth cmp (listToBraunTree a as)