{-# OPTIONS_GHC -XRankNTypes #-}

{- Parigot-encoded Peano numerals.  They are just like Church numerals
   except that the predecessor numeral is an argument to s in applications
   n s z of numerals n. -}
   
newtype PNat = FoldPNat { unfoldPNat :: forall x. (PNat -> x -> x) -> x -> x }

zero :: PNat
zero = FoldPNat (\ s z -> z)

suc :: PNat -> PNat
suc x = FoldPNat (\ s z -> s x (unfoldPNat x s z)) 

add :: PNat -> PNat -> PNat
add x y = unfoldPNat x (\p -> suc) y

mult :: PNat -> PNat -> PNat
mult x y = unfoldPNat x (\p -> add x) y

-- predecessor
prd :: PNat -> PNat
prd x = unfoldPNat x (\p x -> p) zero

-- subtraction
subtr :: PNat -> PNat -> PNat
subtr x y = unfoldPNat y (\p -> prd) x

test = subtr (suc (suc (suc zero))) (suc zero)

-- convert a Parigot nat to an Int
toInt :: PNat -> Int
toInt n = unfoldPNat n (\ p x -> 1 + x) 0

instance Show PNat where
  show n = show (toInt n)
  
