{-# OPTIONS_GHC -XRankNTypes #-}
module CnatUnsafeIO where

import System.IO.Unsafe
import Data.IORef

numReductions :: IORef Int
{-# NOINLINE numReductions #-}
numReductions = unsafePerformIO (newIORef 0)

incr :: a -> a
incr r = unsafePerformIO
           (do
               x <- readIORef numReductions
               writeIORef numReductions (x + 1)
               return r)

reset :: a -> a
reset r = unsafePerformIO
           (do
               writeIORef numReductions 0
               return r)

showNumReds :: () -> Int
showNumReds () = (unsafePerformIO (readIORef numReductions))

newtype CNat = FoldCNat { unfoldCNat :: forall x. (x -> x) -> x -> x }

zero :: CNat
zero = FoldCNat (\ s z -> z)

suc :: CNat -> CNat
suc x = FoldCNat (\ s z -> incr (s (incr (incr (unfoldCNat x s) z))))

add :: CNat -> CNat -> CNat
add x y = incr (incr (unfoldCNat x suc) y)

test = incr (incr (add (incr (suc zero))) (incr (suc zero)))

toInt :: CNat -> Int
toInt n = unfoldCNat n (\ x -> 1 + x) 0

instance Show CNat where
  show n = show (toInt n)
  
