{-# OPTIONS_GHC -XRankNTypes -XKindSignatures #-}

newtype CNat = FoldCNat { unfoldCNat :: forall x. (x -> x) -> x -> x }

zero :: CNat
zero = FoldCNat (\ s z -> z)

suc :: CNat -> CNat
suc x = FoldCNat (\ s z -> s (unfoldCNat x s z)) 

add :: CNat -> CNat -> CNat
add x y = unfoldCNat x suc y

test = add (suc zero) (suc zero)

toInt :: CNat -> Int
toInt n = unfoldCNat n (\ x -> 1 + x) 0

instance Show CNat where
  show n = show (toInt n)
  
