{-# OPTIONS_GHC -XRankNTypes -XKindSignatures #-}

import Control.Monad.State

type S = State Int

newtype CBool = FoldCBool { unfoldCBool :: forall x. x -> S (x -> S x) }

true :: CBool
true = FoldCBool (\ x -> return (\ y -> return x))

false :: CBool
false = FoldCBool (\ x -> return (\ y -> return y))

not :: CBool -> S CBool
not = (\ b -> return (FoldCBool (\ x -> return (\ y -> do 
                                        c <- get
                                        put (c + 2)
                                        f <- unfoldCBool b y
                                        f x))))
      
toBool :: CBool -> Bool
toBool n = evalState
             (do 
               f <- (unfoldCBool n True) 
               f False)
             0

instance Show CBool where
  show n = show (toBool n)

