open import parse-tree
open import string

module run (ptr : ParseTreeRec)  where

open import lib
open import datatypes

open ParseTreeRec ptr

data RunElement : 𝕃 char → Set where
  Id : string → RunElement []
  InputChar : (c : char) → RunElement (c :: [])
  ParseTree : {l : 𝕃 char}{s : string}{pt : ParseTreeT} → isParseTree pt l s → RunElement l

infixr 6 _::'_

data Run : (ls : 𝕃 char) → Set where
  []' : Run []
  _::'_ : {lc elc : 𝕃 char} → RunElement elc → Run lc → Run (elc ++ lc)

length-run : {lc : 𝕃 char} → Run lc → ℕ
length-run []' = 0
length-run (x ::' xs) = suc (length-run xs)

RunElement-to-string : {lc : 𝕃 char} → RunElement lc → string
RunElement-to-string (Id s) = ("id:" ^ s)
RunElement-to-string (InputChar c) = "#" ^ (char-to-string c)
RunElement-to-string (ParseTree{pt = pt} ipt) = (ParseTreeToString pt)

Run-to-string : {lc : 𝕃 char} → Run lc → string
Run-to-string []' = "\n"
Run-to-string (e ::' r) =  (RunElement-to-string e) ^ " " ^ (Run-to-string r) 

empty-string : string
empty-string = ""

record rewriteRules : Set where
  field
    len-dec-rewrite : {lc : 𝕃 char} → (r : Run lc) → maybe (Run lc × ℕ) --(λ r' → length-run r' < length-run r ≡ tt))
    --unit-rewrite : {lc : 𝕃 char} → (r : Run lc) → maybe (Run lc) --(λ r' → length-run r' =ℕ length-run r ≡ tt))
