----------------------------------------------------------------------------------
-- Types for parse trees
----------------------------------------------------------------------------------

module fore-types where

open import lib
open import parse-tree
varone-range-1 = string
varone-bar-2 = string
varone = string
var-plus-3 = string
var = string

mutual

  data term : Set where 
    Abstract : binder → var → term → term → term
    App : term → term → term
    Arrow : term → term → term
    FoldUnfold : var → foldOrUnfold → term
    Parens : term → term
    Star : term
    Var : var → term

  data start : Set where 
    Cmds : cmds → start

  data opt_rec : Set where 
    Plain : opt_rec
    Rec : opt_rec

  data opt_class : Set where 
    NoClass : opt_class
    SomeClass : term → opt_class

  data foldOrUnfold : Set where 
    Fold : foldOrUnfold
    Unfold : foldOrUnfold

  data cmds : Set where 
    CmdsNext : cmd → cmds → cmds
    CmdsStart : cmd → cmds

  data cmd : Set where 
    Define : opt_rec → var → opt_class → term → cmd
    Norm : var → cmd
    Quit : cmd

  data binder : Set where 
    All : binder
    Lam : binder

data ParseTreeT : Set where
  parsed-term : term → ParseTreeT
  parsed-start : start → ParseTreeT
  parsed-opt_rec : opt_rec → ParseTreeT
  parsed-opt_class : opt_class → ParseTreeT
  parsed-foldOrUnfold : foldOrUnfold → ParseTreeT
  parsed-cmds : cmds → ParseTreeT
  parsed-cmd : cmd → ParseTreeT
  parsed-binder : binder → ParseTreeT
  parsed-varone-range-1 : varone-range-1 → ParseTreeT
  parsed-varone-bar-2 : varone-bar-2 → ParseTreeT
  parsed-varone : varone → ParseTreeT
  parsed-var-plus-3 : var-plus-3 → ParseTreeT
  parsed-var : var → ParseTreeT
  parsed-ws-plus-11 : ParseTreeT
  parsed-ws : ParseTreeT
  parsed-ows-star-12 : ParseTreeT
  parsed-ows : ParseTreeT
  parsed-aws-star-7 : ParseTreeT
  parsed-aws-range-4 : ParseTreeT
  parsed-aws-bar-9 : ParseTreeT
  parsed-aws-bar-8 : ParseTreeT
  parsed-aws-bar-6 : ParseTreeT
  parsed-aws-bar-5 : ParseTreeT
  parsed-aws-bar-10 : ParseTreeT
  parsed-aws : ParseTreeT

------------------------------------------
-- Parse tree printing functions
------------------------------------------

varone-range-1ToString : varone-range-1 → string
varone-range-1ToString x = "(varone-range-1 " ^ x ^ ")"
varone-bar-2ToString : varone-bar-2 → string
varone-bar-2ToString x = "(varone-bar-2 " ^ x ^ ")"
varoneToString : varone → string
varoneToString x = "(varone " ^ x ^ ")"
var-plus-3ToString : var-plus-3 → string
var-plus-3ToString x = "(var-plus-3 " ^ x ^ ")"
varToString : var → string
varToString x = "(var " ^ x ^ ")"

mutual
  termToString : term → string
  termToString (Abstract x0 x1 x2 x3) = "(Abstract" ^ " " ^ (binderToString x0) ^ " " ^ (varToString x1) ^ " " ^ (termToString x2) ^ " " ^ (termToString x3) ^ ")"
  termToString (App x0 x1) = "(App" ^ " " ^ (termToString x0) ^ " " ^ (termToString x1) ^ ")"
  termToString (Arrow x0 x1) = "(Arrow" ^ " " ^ (termToString x0) ^ " " ^ (termToString x1) ^ ")"
  termToString (FoldUnfold x0 x1) = "(FoldUnfold" ^ " " ^ (varToString x0) ^ " " ^ (foldOrUnfoldToString x1) ^ ")"
  termToString (Parens x0) = "(Parens" ^ " " ^ (termToString x0) ^ ")"
  termToString (Star) = "Star" ^ ""
  termToString (Var x0) = "(Var" ^ " " ^ (varToString x0) ^ ")"

  startToString : start → string
  startToString (Cmds x0) = "(Cmds" ^ " " ^ (cmdsToString x0) ^ ")"

  opt_recToString : opt_rec → string
  opt_recToString (Plain) = "Plain" ^ ""
  opt_recToString (Rec) = "Rec" ^ ""

  opt_classToString : opt_class → string
  opt_classToString (NoClass) = "NoClass" ^ ""
  opt_classToString (SomeClass x0) = "(SomeClass" ^ " " ^ (termToString x0) ^ ")"

  foldOrUnfoldToString : foldOrUnfold → string
  foldOrUnfoldToString (Fold) = "Fold" ^ ""
  foldOrUnfoldToString (Unfold) = "Unfold" ^ ""

  cmdsToString : cmds → string
  cmdsToString (CmdsNext x0 x1) = "(CmdsNext" ^ " " ^ (cmdToString x0) ^ " " ^ (cmdsToString x1) ^ ")"
  cmdsToString (CmdsStart x0) = "(CmdsStart" ^ " " ^ (cmdToString x0) ^ ")"

  cmdToString : cmd → string
  cmdToString (Define x0 x1 x2 x3) = "(Define" ^ " " ^ (opt_recToString x0) ^ " " ^ (varToString x1) ^ " " ^ (opt_classToString x2) ^ " " ^ (termToString x3) ^ ")"
  cmdToString (Norm x0) = "(Norm" ^ " " ^ (varToString x0) ^ ")"
  cmdToString (Quit) = "Quit" ^ ""

  binderToString : binder → string
  binderToString (All) = "All" ^ ""
  binderToString (Lam) = "Lam" ^ ""

ParseTreeToString : ParseTreeT → string
ParseTreeToString (parsed-term t) = termToString t
ParseTreeToString (parsed-start t) = startToString t
ParseTreeToString (parsed-opt_rec t) = opt_recToString t
ParseTreeToString (parsed-opt_class t) = opt_classToString t
ParseTreeToString (parsed-foldOrUnfold t) = foldOrUnfoldToString t
ParseTreeToString (parsed-cmds t) = cmdsToString t
ParseTreeToString (parsed-cmd t) = cmdToString t
ParseTreeToString (parsed-binder t) = binderToString t
ParseTreeToString (parsed-varone-range-1 t) = varone-range-1ToString t
ParseTreeToString (parsed-varone-bar-2 t) = varone-bar-2ToString t
ParseTreeToString (parsed-varone t) = varoneToString t
ParseTreeToString (parsed-var-plus-3 t) = var-plus-3ToString t
ParseTreeToString (parsed-var t) = varToString t
ParseTreeToString parsed-ws-plus-11 = "[ws-plus-11]"
ParseTreeToString parsed-ws = "[ws]"
ParseTreeToString parsed-ows-star-12 = "[ows-star-12]"
ParseTreeToString parsed-ows = "[ows]"
ParseTreeToString parsed-aws-star-7 = "[aws-star-7]"
ParseTreeToString parsed-aws-range-4 = "[aws-range-4]"
ParseTreeToString parsed-aws-bar-9 = "[aws-bar-9]"
ParseTreeToString parsed-aws-bar-8 = "[aws-bar-8]"
ParseTreeToString parsed-aws-bar-6 = "[aws-bar-6]"
ParseTreeToString parsed-aws-bar-5 = "[aws-bar-5]"
ParseTreeToString parsed-aws-bar-10 = "[aws-bar-10]"
ParseTreeToString parsed-aws = "[aws]"

------------------------------------------
-- Reorganizing rules
------------------------------------------

{-# NO_TERMINATION_CHECK #-}
norm-term : (x : term) → term
norm-term (Arrow (App x1 (Abstract x2 x3 x4 x5)) x6) = (norm-term (App  x1 (norm-term (Abstract  x2 x3 x4 (norm-term (Arrow  x5 x6) )) )) )
norm-term (Arrow (Abstract x1 x2 x3 x4) x5) = (norm-term (Abstract  x1 x2 x3 (norm-term (Arrow  x4 x5) )) )
norm-term (App (App x1 (Abstract x2 x3 x4 x5)) x6) = (norm-term (App  x1 (norm-term (Abstract  x2 x3 x4 (norm-term (App  x5 x6) )) )) )
norm-term (App (Abstract x1 x2 x3 x4) x5) = (norm-term (Abstract  x1 x2 x3 (norm-term (App  x4 x5) )) )
norm-term (App (Arrow x1 x2) x3) = (norm-term (Arrow  x1 (norm-term (App  x2 x3) )) )
norm-term (App x1 (Arrow x2 x3)) = (norm-term (Arrow  (norm-term (App  x1 x2) ) x3) )
norm-term (Arrow (Arrow x1 x2) x3) = (norm-term (Arrow  x1 (norm-term (Arrow  x2 x3) )) )
norm-term (App x1 (App x2 x3)) = (norm-term (App  (norm-term (App  x1 x2) ) x3) )
norm-term x = x

{-# NO_TERMINATION_CHECK #-}
norm-start : (x : start) → start
norm-start x = x

{-# NO_TERMINATION_CHECK #-}
norm-opt_rec : (x : opt_rec) → opt_rec
norm-opt_rec x = x

{-# NO_TERMINATION_CHECK #-}
norm-opt_class : (x : opt_class) → opt_class
norm-opt_class x = x

{-# NO_TERMINATION_CHECK #-}
norm-foldOrUnfold : (x : foldOrUnfold) → foldOrUnfold
norm-foldOrUnfold x = x

{-# NO_TERMINATION_CHECK #-}
norm-cmds : (x : cmds) → cmds
norm-cmds x = x

{-# NO_TERMINATION_CHECK #-}
norm-cmd : (x : cmd) → cmd
norm-cmd x = x

{-# NO_TERMINATION_CHECK #-}
norm-binder : (x : binder) → binder
norm-binder x = x

------------------------------------------
-- Detailed Parse Tree
------------------------------------------

data isParseTree : ParseTreeT → 𝕃 char → string → Set where
  parsed-term-Abstract : {l0 : 𝕃 char}{a0 : binder}{l1 : 𝕃 char}{l2 : 𝕃 char}{a2 : var}{l3 : 𝕃 char}{l4 : 𝕃 char}{l5 : 𝕃 char}{a5 : term}{l6 : 𝕃 char}{l7 : 𝕃 char}{l8 : 𝕃 char}{a8 : term} → isParseTree (parsed-binder a0) l0 "binder" → isParseTree parsed-ows l1 "ows" → isParseTree (parsed-var a2) l2 "var" → isParseTree parsed-ows l3 "ows" → isParseTree parsed-ows l4 "ows" → isParseTree (parsed-term a5) l5 "term" → isParseTree parsed-ows l6 "ows" → isParseTree parsed-ows l7 "ows" → isParseTree (parsed-term a8) l8 "term" → isParseTree (parsed-term (norm-term (Abstract a0 a2 a5 a8))) (l0 ++ l1 ++ l2 ++ l3 ++ [ ':' ] ++ l4 ++ l5 ++ l6 ++ [ ',' ] ++ l7 ++ l8) "term"
  parsed-binder-All : isParseTree (parsed-binder All) [ '∀' ] "binder"
  parsed-term-App : {l0 : 𝕃 char}{a0 : term}{l1 : 𝕃 char}{l2 : 𝕃 char}{a2 : term} → isParseTree (parsed-term a0) l0 "term" → isParseTree parsed-ws l1 "ws" → isParseTree (parsed-term a2) l2 "term" → isParseTree (parsed-term (norm-term (App a0 a2))) (l0 ++ l1 ++ l2) "term"
  parsed-term-Arrow : {l0 : 𝕃 char}{a0 : term}{l1 : 𝕃 char}{l2 : 𝕃 char}{l3 : 𝕃 char}{a3 : term} → isParseTree (parsed-term a0) l0 "term" → isParseTree parsed-ows l1 "ows" → isParseTree parsed-ows l2 "ows" → isParseTree (parsed-term a3) l3 "term" → isParseTree (parsed-term (norm-term (Arrow a0 a3))) (l0 ++ l1 ++ [ '→' ] ++ l2 ++ l3) "term"
  parsed-start-Cmds : {l0 : 𝕃 char}{l1 : 𝕃 char}{a1 : cmds}{l2 : 𝕃 char} → isParseTree parsed-ows l0 "ows" → isParseTree (parsed-cmds a1) l1 "cmds" → isParseTree parsed-ows l2 "ows" → isParseTree (parsed-start (norm-start (Cmds a1))) (l0 ++ l1 ++ l2) "start"
  parsed-cmds-CmdsNext : {l0 : 𝕃 char}{a0 : cmd}{l1 : 𝕃 char}{l2 : 𝕃 char}{a2 : cmds} → isParseTree (parsed-cmd a0) l0 "cmd" → isParseTree parsed-ws l1 "ws" → isParseTree (parsed-cmds a2) l2 "cmds" → isParseTree (parsed-cmds (norm-cmds (CmdsNext a0 a2))) (l0 ++ l1 ++ l2) "cmds"
  parsed-cmds-CmdsStart : {l0 : 𝕃 char}{a0 : cmd} → isParseTree (parsed-cmd a0) l0 "cmd" → isParseTree (parsed-cmds (norm-cmds (CmdsStart a0))) l0 "cmds"
  parsed-cmd-Define : {l0 : 𝕃 char}{a0 : opt_rec}{l1 : 𝕃 char}{a1 : var}{l2 : 𝕃 char}{l3 : 𝕃 char}{a3 : opt_class}{l4 : 𝕃 char}{l5 : 𝕃 char}{a5 : term}{l6 : 𝕃 char} → isParseTree (parsed-opt_rec a0) l0 "opt_rec" → isParseTree (parsed-var a1) l1 "var" → isParseTree parsed-ows l2 "ows" → isParseTree (parsed-opt_class a3) l3 "opt_class" → isParseTree parsed-ows l4 "ows" → isParseTree (parsed-term a5) l5 "term" → isParseTree parsed-ows l6 "ows" → isParseTree (parsed-cmd (norm-cmd (Define a0 a1 a3 a5))) (l0 ++ l1 ++ l2 ++ l3 ++ [ '=' ] ++ l4 ++ l5 ++ l6 ++ [ '.' ]) "cmd"
  parsed-term-FoldUnfold : {l0 : 𝕃 char}{l1 : 𝕃 char}{a1 : var}{l2 : 𝕃 char}{l3 : 𝕃 char}{a3 : foldOrUnfold} → isParseTree parsed-ows l0 "ows" → isParseTree (parsed-var a1) l1 "var" → isParseTree parsed-ows l2 "ows" → isParseTree (parsed-foldOrUnfold a3) l3 "foldOrUnfold" → isParseTree (parsed-term (norm-term (FoldUnfold a1 a3))) ([ '[' ] ++ l0 ++ l1 ++ l2 ++ l3 ++ [ ']' ]) "term"
  parsed-binder-Lam : isParseTree (parsed-binder Lam) [ 'λ' ] "binder"
  parsed-cmd-Norm : {l0 : 𝕃 char}{l1 : 𝕃 char}{a1 : var}{l2 : 𝕃 char} → isParseTree parsed-ws l0 "ws" → isParseTree (parsed-var a1) l1 "var" → isParseTree parsed-ows l2 "ows" → isParseTree (parsed-cmd (norm-cmd (Norm a1))) ([ 'n' ] ++ [ 'o' ] ++ [ 'r' ] ++ [ 'm' ] ++ l0 ++ l1 ++ l2 ++ [ '.' ]) "cmd"
  parsed-varone-range-1-P0 : isParseTree (parsed-varone-range-1 "A") [ 'A' ] "varone-range-1"
  parsed-varone-range-1-P1 : isParseTree (parsed-varone-range-1 "B") [ 'B' ] "varone-range-1"
  parsed-varone-range-1-P10 : isParseTree (parsed-varone-range-1 "K") [ 'K' ] "varone-range-1"
  parsed-aws-range-4-P100 : isParseTree parsed-aws-range-4 [ 'q' ] "aws-range-4"
  parsed-aws-range-4-P101 : isParseTree parsed-aws-range-4 [ 'r' ] "aws-range-4"
  parsed-aws-range-4-P102 : isParseTree parsed-aws-range-4 [ 's' ] "aws-range-4"
  parsed-aws-range-4-P103 : isParseTree parsed-aws-range-4 [ 't' ] "aws-range-4"
  parsed-aws-range-4-P104 : isParseTree parsed-aws-range-4 [ 'u' ] "aws-range-4"
  parsed-aws-range-4-P105 : isParseTree parsed-aws-range-4 [ 'v' ] "aws-range-4"
  parsed-aws-range-4-P106 : isParseTree parsed-aws-range-4 [ 'w' ] "aws-range-4"
  parsed-aws-range-4-P107 : isParseTree parsed-aws-range-4 [ 'x' ] "aws-range-4"
  parsed-aws-range-4-P108 : isParseTree parsed-aws-range-4 [ 'y' ] "aws-range-4"
  parsed-aws-range-4-P109 : isParseTree parsed-aws-range-4 [ 'z' ] "aws-range-4"
  parsed-varone-range-1-P11 : isParseTree (parsed-varone-range-1 "L") [ 'L' ] "varone-range-1"
  parsed-aws-bar-5-P110 : isParseTree parsed-aws-bar-5 [ ' ' ] "aws-bar-5"
  parsed-aws-bar-5-P111 : isParseTree parsed-aws-bar-5 [ '%' ] "aws-bar-5"
  parsed-aws-bar-6-P112 : {l0 : 𝕃 char} → isParseTree parsed-aws-range-4 l0 "aws-range-4" → isParseTree parsed-aws-bar-6 l0 "aws-bar-6"
  parsed-aws-bar-6-P113 : {l0 : 𝕃 char} → isParseTree parsed-aws-bar-5 l0 "aws-bar-5" → isParseTree parsed-aws-bar-6 l0 "aws-bar-6"
  parsed-aws-star-7-P115 : {l0 : 𝕃 char}{l1 : 𝕃 char} → isParseTree parsed-aws-bar-6 l0 "aws-bar-6" → isParseTree parsed-aws-star-7 l1 "aws-star-7" → isParseTree parsed-aws-star-7 (l0 ++ l1) "aws-star-7"
  parsed-aws-bar-8-P116 : isParseTree parsed-aws-bar-8 [ ' ' ] "aws-bar-8"
  parsed-aws-bar-8-P117 : {l0 : 𝕃 char} → isParseTree parsed-aws-star-7 l0 "aws-star-7" → isParseTree parsed-aws-bar-8 ([ '%' ] ++ l0 ++ [ '\n' ]) "aws-bar-8"
  parsed-aws-bar-9-P118 : isParseTree parsed-aws-bar-9 [ '\t' ] "aws-bar-9"
  parsed-aws-bar-9-P119 : {l0 : 𝕃 char} → isParseTree parsed-aws-bar-8 l0 "aws-bar-8" → isParseTree parsed-aws-bar-9 l0 "aws-bar-9"
  parsed-varone-range-1-P12 : isParseTree (parsed-varone-range-1 "M") [ 'M' ] "varone-range-1"
  parsed-aws-bar-10-P120 : isParseTree parsed-aws-bar-10 [ '\n' ] "aws-bar-10"
  parsed-aws-bar-10-P121 : {l0 : 𝕃 char} → isParseTree parsed-aws-bar-9 l0 "aws-bar-9" → isParseTree parsed-aws-bar-10 l0 "aws-bar-10"
  parsed-aws-P122 : {l0 : 𝕃 char} → isParseTree parsed-aws-bar-10 l0 "aws-bar-10" → isParseTree parsed-aws l0 "aws"
  parsed-ws-plus-11-P123 : {l0 : 𝕃 char} → isParseTree parsed-aws l0 "aws" → isParseTree parsed-ws-plus-11 l0 "ws-plus-11"
  parsed-ws-plus-11-P124 : {l0 : 𝕃 char}{l1 : 𝕃 char} → isParseTree parsed-aws l0 "aws" → isParseTree parsed-ws-plus-11 l1 "ws-plus-11" → isParseTree parsed-ws-plus-11 (l0 ++ l1) "ws-plus-11"
  parsed-ws-P125 : {l0 : 𝕃 char} → isParseTree parsed-ws-plus-11 l0 "ws-plus-11" → isParseTree parsed-ws l0 "ws"
  parsed-ows-star-12-P127 : {l0 : 𝕃 char}{l1 : 𝕃 char} → isParseTree parsed-aws l0 "aws" → isParseTree parsed-ows-star-12 l1 "ows-star-12" → isParseTree parsed-ows-star-12 (l0 ++ l1) "ows-star-12"
  parsed-ows-P128 : {l0 : 𝕃 char} → isParseTree parsed-ows-star-12 l0 "ows-star-12" → isParseTree parsed-ows l0 "ows"
  parsed-varone-range-1-P13 : isParseTree (parsed-varone-range-1 "N") [ 'N' ] "varone-range-1"
  parsed-varone-range-1-P14 : isParseTree (parsed-varone-range-1 "O") [ 'O' ] "varone-range-1"
  parsed-varone-range-1-P15 : isParseTree (parsed-varone-range-1 "P") [ 'P' ] "varone-range-1"
  parsed-varone-range-1-P16 : isParseTree (parsed-varone-range-1 "Q") [ 'Q' ] "varone-range-1"
  parsed-varone-range-1-P17 : isParseTree (parsed-varone-range-1 "R") [ 'R' ] "varone-range-1"
  parsed-varone-range-1-P18 : isParseTree (parsed-varone-range-1 "S") [ 'S' ] "varone-range-1"
  parsed-varone-range-1-P19 : isParseTree (parsed-varone-range-1 "T") [ 'T' ] "varone-range-1"
  parsed-varone-range-1-P2 : isParseTree (parsed-varone-range-1 "C") [ 'C' ] "varone-range-1"
  parsed-varone-range-1-P20 : isParseTree (parsed-varone-range-1 "U") [ 'U' ] "varone-range-1"
  parsed-varone-range-1-P21 : isParseTree (parsed-varone-range-1 "V") [ 'V' ] "varone-range-1"
  parsed-varone-range-1-P22 : isParseTree (parsed-varone-range-1 "W") [ 'W' ] "varone-range-1"
  parsed-varone-range-1-P23 : isParseTree (parsed-varone-range-1 "X") [ 'X' ] "varone-range-1"
  parsed-varone-range-1-P24 : isParseTree (parsed-varone-range-1 "Y") [ 'Y' ] "varone-range-1"
  parsed-varone-range-1-P25 : isParseTree (parsed-varone-range-1 "Z") [ 'Z' ] "varone-range-1"
  parsed-varone-range-1-P26 : isParseTree (parsed-varone-range-1 "a") [ 'a' ] "varone-range-1"
  parsed-varone-range-1-P27 : isParseTree (parsed-varone-range-1 "b") [ 'b' ] "varone-range-1"
  parsed-varone-range-1-P28 : isParseTree (parsed-varone-range-1 "c") [ 'c' ] "varone-range-1"
  parsed-varone-range-1-P29 : isParseTree (parsed-varone-range-1 "d") [ 'd' ] "varone-range-1"
  parsed-varone-range-1-P3 : isParseTree (parsed-varone-range-1 "D") [ 'D' ] "varone-range-1"
  parsed-varone-range-1-P30 : isParseTree (parsed-varone-range-1 "e") [ 'e' ] "varone-range-1"
  parsed-varone-range-1-P31 : isParseTree (parsed-varone-range-1 "f") [ 'f' ] "varone-range-1"
  parsed-varone-range-1-P32 : isParseTree (parsed-varone-range-1 "g") [ 'g' ] "varone-range-1"
  parsed-varone-range-1-P33 : isParseTree (parsed-varone-range-1 "h") [ 'h' ] "varone-range-1"
  parsed-varone-range-1-P34 : isParseTree (parsed-varone-range-1 "i") [ 'i' ] "varone-range-1"
  parsed-varone-range-1-P35 : isParseTree (parsed-varone-range-1 "j") [ 'j' ] "varone-range-1"
  parsed-varone-range-1-P36 : isParseTree (parsed-varone-range-1 "k") [ 'k' ] "varone-range-1"
  parsed-varone-range-1-P37 : isParseTree (parsed-varone-range-1 "l") [ 'l' ] "varone-range-1"
  parsed-varone-range-1-P38 : isParseTree (parsed-varone-range-1 "m") [ 'm' ] "varone-range-1"
  parsed-varone-range-1-P39 : isParseTree (parsed-varone-range-1 "n") [ 'n' ] "varone-range-1"
  parsed-varone-range-1-P4 : isParseTree (parsed-varone-range-1 "E") [ 'E' ] "varone-range-1"
  parsed-varone-range-1-P40 : isParseTree (parsed-varone-range-1 "o") [ 'o' ] "varone-range-1"
  parsed-varone-range-1-P41 : isParseTree (parsed-varone-range-1 "p") [ 'p' ] "varone-range-1"
  parsed-varone-range-1-P42 : isParseTree (parsed-varone-range-1 "q") [ 'q' ] "varone-range-1"
  parsed-varone-range-1-P43 : isParseTree (parsed-varone-range-1 "r") [ 'r' ] "varone-range-1"
  parsed-varone-range-1-P44 : isParseTree (parsed-varone-range-1 "s") [ 's' ] "varone-range-1"
  parsed-varone-range-1-P45 : isParseTree (parsed-varone-range-1 "t") [ 't' ] "varone-range-1"
  parsed-varone-range-1-P46 : isParseTree (parsed-varone-range-1 "u") [ 'u' ] "varone-range-1"
  parsed-varone-range-1-P47 : isParseTree (parsed-varone-range-1 "v") [ 'v' ] "varone-range-1"
  parsed-varone-range-1-P48 : isParseTree (parsed-varone-range-1 "w") [ 'w' ] "varone-range-1"
  parsed-varone-range-1-P49 : isParseTree (parsed-varone-range-1 "x") [ 'x' ] "varone-range-1"
  parsed-varone-range-1-P5 : isParseTree (parsed-varone-range-1 "F") [ 'F' ] "varone-range-1"
  parsed-varone-range-1-P50 : isParseTree (parsed-varone-range-1 "y") [ 'y' ] "varone-range-1"
  parsed-varone-range-1-P51 : isParseTree (parsed-varone-range-1 "z") [ 'z' ] "varone-range-1"
  parsed-varone-bar-2-P52 : {l0 : 𝕃 char}{a0 : varone-range-1} → isParseTree (parsed-varone-range-1 a0) l0 "varone-range-1" → isParseTree (parsed-varone-bar-2 a0) l0 "varone-bar-2"
  parsed-varone-bar-2-P53 : isParseTree (parsed-varone-bar-2 "\'") [ '\'' ] "varone-bar-2"
  parsed-varone-P54 : {l0 : 𝕃 char}{a0 : varone-bar-2} → isParseTree (parsed-varone-bar-2 a0) l0 "varone-bar-2" → isParseTree (parsed-varone a0) l0 "varone"
  parsed-var-plus-3-P55 : {l0 : 𝕃 char}{a0 : varone} → isParseTree (parsed-varone a0) l0 "varone" → isParseTree (parsed-var-plus-3 a0) l0 "var-plus-3"
  parsed-var-plus-3-P56 : {l0 : 𝕃 char}{a0 : varone}{l1 : 𝕃 char}{a1 : var-plus-3} → isParseTree (parsed-varone a0) l0 "varone" → isParseTree (parsed-var-plus-3 a1) l1 "var-plus-3" → isParseTree (parsed-var-plus-3 (a0 ^ a1)) (l0 ++ l1) "var-plus-3"
  parsed-var-P57 : {l0 : 𝕃 char}{a0 : var-plus-3} → isParseTree (parsed-var-plus-3 a0) l0 "var-plus-3" → isParseTree (parsed-var a0) l0 "var"
  parsed-aws-range-4-P58 : isParseTree parsed-aws-range-4 [ 'A' ] "aws-range-4"
  parsed-aws-range-4-P59 : isParseTree parsed-aws-range-4 [ 'B' ] "aws-range-4"
  parsed-varone-range-1-P6 : isParseTree (parsed-varone-range-1 "G") [ 'G' ] "varone-range-1"
  parsed-aws-range-4-P60 : isParseTree parsed-aws-range-4 [ 'C' ] "aws-range-4"
  parsed-aws-range-4-P61 : isParseTree parsed-aws-range-4 [ 'D' ] "aws-range-4"
  parsed-aws-range-4-P62 : isParseTree parsed-aws-range-4 [ 'E' ] "aws-range-4"
  parsed-aws-range-4-P63 : isParseTree parsed-aws-range-4 [ 'F' ] "aws-range-4"
  parsed-aws-range-4-P64 : isParseTree parsed-aws-range-4 [ 'G' ] "aws-range-4"
  parsed-aws-range-4-P65 : isParseTree parsed-aws-range-4 [ 'H' ] "aws-range-4"
  parsed-aws-range-4-P66 : isParseTree parsed-aws-range-4 [ 'I' ] "aws-range-4"
  parsed-aws-range-4-P67 : isParseTree parsed-aws-range-4 [ 'J' ] "aws-range-4"
  parsed-aws-range-4-P68 : isParseTree parsed-aws-range-4 [ 'K' ] "aws-range-4"
  parsed-aws-range-4-P69 : isParseTree parsed-aws-range-4 [ 'L' ] "aws-range-4"
  parsed-varone-range-1-P7 : isParseTree (parsed-varone-range-1 "H") [ 'H' ] "varone-range-1"
  parsed-aws-range-4-P70 : isParseTree parsed-aws-range-4 [ 'M' ] "aws-range-4"
  parsed-aws-range-4-P71 : isParseTree parsed-aws-range-4 [ 'N' ] "aws-range-4"
  parsed-aws-range-4-P72 : isParseTree parsed-aws-range-4 [ 'O' ] "aws-range-4"
  parsed-aws-range-4-P73 : isParseTree parsed-aws-range-4 [ 'P' ] "aws-range-4"
  parsed-aws-range-4-P74 : isParseTree parsed-aws-range-4 [ 'Q' ] "aws-range-4"
  parsed-aws-range-4-P75 : isParseTree parsed-aws-range-4 [ 'R' ] "aws-range-4"
  parsed-aws-range-4-P76 : isParseTree parsed-aws-range-4 [ 'S' ] "aws-range-4"
  parsed-aws-range-4-P77 : isParseTree parsed-aws-range-4 [ 'T' ] "aws-range-4"
  parsed-aws-range-4-P78 : isParseTree parsed-aws-range-4 [ 'U' ] "aws-range-4"
  parsed-aws-range-4-P79 : isParseTree parsed-aws-range-4 [ 'V' ] "aws-range-4"
  parsed-varone-range-1-P8 : isParseTree (parsed-varone-range-1 "I") [ 'I' ] "varone-range-1"
  parsed-aws-range-4-P80 : isParseTree parsed-aws-range-4 [ 'W' ] "aws-range-4"
  parsed-aws-range-4-P81 : isParseTree parsed-aws-range-4 [ 'X' ] "aws-range-4"
  parsed-aws-range-4-P82 : isParseTree parsed-aws-range-4 [ 'Y' ] "aws-range-4"
  parsed-aws-range-4-P83 : isParseTree parsed-aws-range-4 [ 'Z' ] "aws-range-4"
  parsed-aws-range-4-P84 : isParseTree parsed-aws-range-4 [ 'a' ] "aws-range-4"
  parsed-aws-range-4-P85 : isParseTree parsed-aws-range-4 [ 'b' ] "aws-range-4"
  parsed-aws-range-4-P86 : isParseTree parsed-aws-range-4 [ 'c' ] "aws-range-4"
  parsed-aws-range-4-P87 : isParseTree parsed-aws-range-4 [ 'd' ] "aws-range-4"
  parsed-aws-range-4-P88 : isParseTree parsed-aws-range-4 [ 'e' ] "aws-range-4"
  parsed-aws-range-4-P89 : isParseTree parsed-aws-range-4 [ 'f' ] "aws-range-4"
  parsed-varone-range-1-P9 : isParseTree (parsed-varone-range-1 "J") [ 'J' ] "varone-range-1"
  parsed-aws-range-4-P90 : isParseTree parsed-aws-range-4 [ 'g' ] "aws-range-4"
  parsed-aws-range-4-P91 : isParseTree parsed-aws-range-4 [ 'h' ] "aws-range-4"
  parsed-aws-range-4-P92 : isParseTree parsed-aws-range-4 [ 'i' ] "aws-range-4"
  parsed-aws-range-4-P93 : isParseTree parsed-aws-range-4 [ 'j' ] "aws-range-4"
  parsed-aws-range-4-P94 : isParseTree parsed-aws-range-4 [ 'k' ] "aws-range-4"
  parsed-aws-range-4-P95 : isParseTree parsed-aws-range-4 [ 'l' ] "aws-range-4"
  parsed-aws-range-4-P96 : isParseTree parsed-aws-range-4 [ 'm' ] "aws-range-4"
  parsed-aws-range-4-P97 : isParseTree parsed-aws-range-4 [ 'n' ] "aws-range-4"
  parsed-aws-range-4-P98 : isParseTree parsed-aws-range-4 [ 'o' ] "aws-range-4"
  parsed-aws-range-4-P99 : isParseTree parsed-aws-range-4 [ 'p' ] "aws-range-4"
  parsed-term-Parens : {l0 : 𝕃 char}{l1 : 𝕃 char}{a1 : term}{l2 : 𝕃 char} → isParseTree parsed-ows l0 "ows" → isParseTree (parsed-term a1) l1 "term" → isParseTree parsed-ows l2 "ows" → isParseTree (parsed-term (norm-term (Parens a1))) ([ '(' ] ++ l0 ++ l1 ++ l2 ++ [ ')' ]) "term"
  parsed-cmd-Quit : {l0 : 𝕃 char} → isParseTree parsed-ows l0 "ows" → isParseTree (parsed-cmd Quit) ([ 'q' ] ++ [ 'u' ] ++ [ 'i' ] ++ [ 't' ] ++ l0 ++ [ '.' ]) "cmd"
  parsed-opt_rec-Rec : {l0 : 𝕃 char} → isParseTree parsed-ws l0 "ws" → isParseTree (parsed-opt_rec Rec) ([ 'r' ] ++ [ 'e' ] ++ [ 'c' ] ++ l0) "opt_rec"
  parsed-opt_class-SomeClass : {l0 : 𝕃 char}{l1 : 𝕃 char}{a1 : term}{l2 : 𝕃 char} → isParseTree parsed-ows l0 "ows" → isParseTree (parsed-term a1) l1 "term" → isParseTree parsed-ows l2 "ows" → isParseTree (parsed-opt_class (norm-opt_class (SomeClass a1))) ([ ':' ] ++ l0 ++ l1 ++ l2) "opt_class"
  parsed-term-Star : isParseTree (parsed-term Star) [ '*' ] "term"
  parsed-foldOrUnfold-Unfold : {l0 : 𝕃 char} → isParseTree parsed-ows l0 "ows" → isParseTree (parsed-foldOrUnfold Unfold) ([ '!' ] ++ l0) "foldOrUnfold"
  parsed-term-Var : {l0 : 𝕃 char}{a0 : var} → isParseTree (parsed-var a0) l0 "var" → isParseTree (parsed-term (norm-term (Var a0))) l0 "term"
  parsed-foldOrUnfold-Fold : isParseTree (parsed-foldOrUnfold Fold) [] "foldOrUnfold"
  parsed-opt_class-NoClass : isParseTree (parsed-opt_class NoClass) [] "opt_class"
  parsed-aws-star-7-P114 : isParseTree parsed-aws-star-7 [] "aws-star-7"
  parsed-ows-star-12-P126 : isParseTree parsed-ows-star-12 [] "ows-star-12"
  parsed-opt_rec-Plain : isParseTree (parsed-opt_rec Plain) [] "opt_rec"



------------------------------------------
-- Grammar
------------------------------------------

open import grammar string _=string_ ≡string-to-= =string-to-≡



g : grammar{150}
g = ("start" ,
  "opt_rec" ⇒ [] ::
  "ows-star-12" ⇒ [] ::
  "aws-star-7" ⇒ [] ::
  "opt_class" ⇒ [] ::
  "foldOrUnfold" ⇒ [] ::
  "term" ⇒ (inj₁ "var" :: []) ::
  "foldOrUnfold" ⇒ (inj₂ '!' :: inj₁ "ows" :: []) ::
  "term" ⇒ (inj₂ '*' :: []) ::
  "opt_class" ⇒ (inj₂ ':' :: inj₁ "ows" :: inj₁ "term" :: inj₁ "ows" :: []) ::
  "opt_rec" ⇒ (inj₂ 'r' :: inj₂ 'e' :: inj₂ 'c' :: inj₁ "ws" :: []) ::
  "cmd" ⇒ (inj₂ 'q' :: inj₂ 'u' :: inj₂ 'i' :: inj₂ 't' :: inj₁ "ows" :: inj₂ '.' :: []) ::
  "term" ⇒ (inj₂ '(' :: inj₁ "ows" :: inj₁ "term" :: inj₁ "ows" :: inj₂ ')' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'p' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'o' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'n' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'm' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'l' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'k' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'j' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'i' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'h' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'g' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'J' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'f' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'e' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'd' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'c' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'b' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'a' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'Z' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'Y' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'X' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'W' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'I' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'V' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'U' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'T' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'S' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'R' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'Q' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'P' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'O' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'N' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'M' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'H' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'L' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'K' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'J' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'I' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'H' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'G' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'F' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'E' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'D' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'C' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'G' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'B' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'A' :: []) ::
  "var" ⇒ (inj₁ "var-plus-3" :: []) ::
  "var-plus-3" ⇒ (inj₁ "varone" :: inj₁ "var-plus-3" :: []) ::
  "var-plus-3" ⇒ (inj₁ "varone" :: []) ::
  "varone" ⇒ (inj₁ "varone-bar-2" :: []) ::
  "varone-bar-2" ⇒ (inj₂ '\'' :: []) ::
  "varone-bar-2" ⇒ (inj₁ "varone-range-1" :: []) ::
  "varone-range-1" ⇒ (inj₂ 'z' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'y' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'F' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'x' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'w' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'v' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'u' :: []) ::
  "varone-range-1" ⇒ (inj₂ 't' :: []) ::
  "varone-range-1" ⇒ (inj₂ 's' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'r' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'q' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'p' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'o' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'E' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'n' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'm' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'l' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'k' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'j' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'i' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'h' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'g' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'f' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'e' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'D' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'd' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'c' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'b' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'a' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'Z' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'Y' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'X' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'W' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'V' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'U' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'C' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'T' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'S' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'R' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'Q' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'P' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'O' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'N' :: []) ::
  "ows" ⇒ (inj₁ "ows-star-12" :: []) ::
  "ows-star-12" ⇒ (inj₁ "aws" :: inj₁ "ows-star-12" :: []) ::
  "ws" ⇒ (inj₁ "ws-plus-11" :: []) ::
  "ws-plus-11" ⇒ (inj₁ "aws" :: inj₁ "ws-plus-11" :: []) ::
  "ws-plus-11" ⇒ (inj₁ "aws" :: []) ::
  "aws" ⇒ (inj₁ "aws-bar-10" :: []) ::
  "aws-bar-10" ⇒ (inj₁ "aws-bar-9" :: []) ::
  "aws-bar-10" ⇒ (inj₂ '\n' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'M' :: []) ::
  "aws-bar-9" ⇒ (inj₁ "aws-bar-8" :: []) ::
  "aws-bar-9" ⇒ (inj₂ '\t' :: []) ::
  "aws-bar-8" ⇒ (inj₂ '%' :: inj₁ "aws-star-7" :: inj₂ '\n' :: []) ::
  "aws-bar-8" ⇒ (inj₂ ' ' :: []) ::
  "aws-star-7" ⇒ (inj₁ "aws-bar-6" :: inj₁ "aws-star-7" :: []) ::
  "aws-bar-6" ⇒ (inj₁ "aws-bar-5" :: []) ::
  "aws-bar-6" ⇒ (inj₁ "aws-range-4" :: []) ::
  "aws-bar-5" ⇒ (inj₂ '%' :: []) ::
  "aws-bar-5" ⇒ (inj₂ ' ' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'L' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'z' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'y' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'x' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'w' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'v' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'u' :: []) ::
  "aws-range-4" ⇒ (inj₂ 't' :: []) ::
  "aws-range-4" ⇒ (inj₂ 's' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'r' :: []) ::
  "aws-range-4" ⇒ (inj₂ 'q' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'K' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'B' :: []) ::
  "varone-range-1" ⇒ (inj₂ 'A' :: []) ::
  "cmd" ⇒ (inj₂ 'n' :: inj₂ 'o' :: inj₂ 'r' :: inj₂ 'm' :: inj₁ "ws" :: inj₁ "var" :: inj₁ "ows" :: inj₂ '.' :: []) ::
  "binder" ⇒ (inj₂ 'λ' :: []) ::
  "term" ⇒ (inj₂ '[' :: inj₁ "ows" :: inj₁ "var" :: inj₁ "ows" :: inj₁ "foldOrUnfold" :: inj₂ ']' :: []) ::
  "cmd" ⇒ (inj₁ "opt_rec" :: inj₁ "var" :: inj₁ "ows" :: inj₁ "opt_class" :: inj₂ '=' :: inj₁ "ows" :: inj₁ "term" :: inj₁ "ows" :: inj₂ '.' :: []) ::
  "cmds" ⇒ (inj₁ "cmd" :: []) ::
  "cmds" ⇒ (inj₁ "cmd" :: inj₁ "ws" :: inj₁ "cmds" :: []) ::
  "start" ⇒ (inj₁ "ows" :: inj₁ "cmds" :: inj₁ "ows" :: []) ::
  "term" ⇒ (inj₁ "term" :: inj₁ "ows" :: inj₂ '→' :: inj₁ "ows" :: inj₁ "term" :: []) ::
  "term" ⇒ (inj₁ "term" :: inj₁ "ws" :: inj₁ "term" :: []) ::
  "binder" ⇒ (inj₂ '∀' :: []) ::
  "term" ⇒ (inj₁ "binder" :: inj₁ "ows" :: inj₁ "var" :: inj₁ "ows" :: inj₂ ':' :: inj₁ "ows" :: inj₁ "term" :: inj₁ "ows" :: inj₂ ',' :: inj₁ "ows" :: inj₁ "term" :: []) ::
  [])



------------------------------------------
-- Derivations
------------------------------------------


self-deriv : (s : char) → derivation{g = g} [ inj₂ s ] [ s ]
self-deriv s = end

derives : ∀{nt : string}{s : 𝕃 char}{T : ParseTreeT} → isParseTree T s nt → derivation{g = g} [ inj₁ nt ] s
derives parsed-opt_rec-Plain = step 0 0 refl refl refl refl end
derives parsed-ows-star-12-P126 = step 0 1 refl refl refl refl end
derives parsed-aws-star-7-P114 = step 0 2 refl refl refl refl end
derives parsed-opt_class-NoClass = step 0 3 refl refl refl refl end
derives parsed-foldOrUnfold-Fold = step 0 4 refl refl refl refl end
derives (parsed-term-Var a1) = step 0 5 refl refl refl refl ((derives a1))
derives (parsed-foldOrUnfold-Unfold a1) = step 0 6 refl refl refl refl (self-deriv '!' deriv++ (derives a1))
derives parsed-term-Star = step 0 7 refl refl refl refl (self-deriv '*')
derives (parsed-opt_class-SomeClass a1 a2 a3) = step 0 8 refl refl refl refl (self-deriv ':' deriv++ (derives a1) deriv++ (derives a2) deriv++ (derives a3))
derives (parsed-opt_rec-Rec a1) = step 0 9 refl refl refl refl (self-deriv 'r' deriv++ self-deriv 'e' deriv++ self-deriv 'c' deriv++ (derives a1))
derives (parsed-cmd-Quit a1) = step 0 10 refl refl refl refl (self-deriv 'q' deriv++ self-deriv 'u' deriv++ self-deriv 'i' deriv++ self-deriv 't' deriv++ (derives a1) deriv++ self-deriv '.')
derives (parsed-term-Parens a1 a2 a3) = step 0 11 refl refl refl refl (self-deriv '(' deriv++ (derives a1) deriv++ (derives a2) deriv++ (derives a3) deriv++ self-deriv ')')
derives parsed-aws-range-4-P99 = step 0 12 refl refl refl refl (self-deriv 'p')
derives parsed-aws-range-4-P98 = step 0 13 refl refl refl refl (self-deriv 'o')
derives parsed-aws-range-4-P97 = step 0 14 refl refl refl refl (self-deriv 'n')
derives parsed-aws-range-4-P96 = step 0 15 refl refl refl refl (self-deriv 'm')
derives parsed-aws-range-4-P95 = step 0 16 refl refl refl refl (self-deriv 'l')
derives parsed-aws-range-4-P94 = step 0 17 refl refl refl refl (self-deriv 'k')
derives parsed-aws-range-4-P93 = step 0 18 refl refl refl refl (self-deriv 'j')
derives parsed-aws-range-4-P92 = step 0 19 refl refl refl refl (self-deriv 'i')
derives parsed-aws-range-4-P91 = step 0 20 refl refl refl refl (self-deriv 'h')
derives parsed-aws-range-4-P90 = step 0 21 refl refl refl refl (self-deriv 'g')
derives parsed-varone-range-1-P9 = step 0 22 refl refl refl refl (self-deriv 'J')
derives parsed-aws-range-4-P89 = step 0 23 refl refl refl refl (self-deriv 'f')
derives parsed-aws-range-4-P88 = step 0 24 refl refl refl refl (self-deriv 'e')
derives parsed-aws-range-4-P87 = step 0 25 refl refl refl refl (self-deriv 'd')
derives parsed-aws-range-4-P86 = step 0 26 refl refl refl refl (self-deriv 'c')
derives parsed-aws-range-4-P85 = step 0 27 refl refl refl refl (self-deriv 'b')
derives parsed-aws-range-4-P84 = step 0 28 refl refl refl refl (self-deriv 'a')
derives parsed-aws-range-4-P83 = step 0 29 refl refl refl refl (self-deriv 'Z')
derives parsed-aws-range-4-P82 = step 0 30 refl refl refl refl (self-deriv 'Y')
derives parsed-aws-range-4-P81 = step 0 31 refl refl refl refl (self-deriv 'X')
derives parsed-aws-range-4-P80 = step 0 32 refl refl refl refl (self-deriv 'W')
derives parsed-varone-range-1-P8 = step 0 33 refl refl refl refl (self-deriv 'I')
derives parsed-aws-range-4-P79 = step 0 34 refl refl refl refl (self-deriv 'V')
derives parsed-aws-range-4-P78 = step 0 35 refl refl refl refl (self-deriv 'U')
derives parsed-aws-range-4-P77 = step 0 36 refl refl refl refl (self-deriv 'T')
derives parsed-aws-range-4-P76 = step 0 37 refl refl refl refl (self-deriv 'S')
derives parsed-aws-range-4-P75 = step 0 38 refl refl refl refl (self-deriv 'R')
derives parsed-aws-range-4-P74 = step 0 39 refl refl refl refl (self-deriv 'Q')
derives parsed-aws-range-4-P73 = step 0 40 refl refl refl refl (self-deriv 'P')
derives parsed-aws-range-4-P72 = step 0 41 refl refl refl refl (self-deriv 'O')
derives parsed-aws-range-4-P71 = step 0 42 refl refl refl refl (self-deriv 'N')
derives parsed-aws-range-4-P70 = step 0 43 refl refl refl refl (self-deriv 'M')
derives parsed-varone-range-1-P7 = step 0 44 refl refl refl refl (self-deriv 'H')
derives parsed-aws-range-4-P69 = step 0 45 refl refl refl refl (self-deriv 'L')
derives parsed-aws-range-4-P68 = step 0 46 refl refl refl refl (self-deriv 'K')
derives parsed-aws-range-4-P67 = step 0 47 refl refl refl refl (self-deriv 'J')
derives parsed-aws-range-4-P66 = step 0 48 refl refl refl refl (self-deriv 'I')
derives parsed-aws-range-4-P65 = step 0 49 refl refl refl refl (self-deriv 'H')
derives parsed-aws-range-4-P64 = step 0 50 refl refl refl refl (self-deriv 'G')
derives parsed-aws-range-4-P63 = step 0 51 refl refl refl refl (self-deriv 'F')
derives parsed-aws-range-4-P62 = step 0 52 refl refl refl refl (self-deriv 'E')
derives parsed-aws-range-4-P61 = step 0 53 refl refl refl refl (self-deriv 'D')
derives parsed-aws-range-4-P60 = step 0 54 refl refl refl refl (self-deriv 'C')
derives parsed-varone-range-1-P6 = step 0 55 refl refl refl refl (self-deriv 'G')
derives parsed-aws-range-4-P59 = step 0 56 refl refl refl refl (self-deriv 'B')
derives parsed-aws-range-4-P58 = step 0 57 refl refl refl refl (self-deriv 'A')
derives (parsed-var-P57 a1) = step 0 58 refl refl refl refl ((derives a1))
derives (parsed-var-plus-3-P56 a1 a2) = step 0 59 refl refl refl refl ((derives a1) deriv++ (derives a2))
derives (parsed-var-plus-3-P55 a1) = step 0 60 refl refl refl refl ((derives a1))
derives (parsed-varone-P54 a1) = step 0 61 refl refl refl refl ((derives a1))
derives parsed-varone-bar-2-P53 = step 0 62 refl refl refl refl (self-deriv '\'')
derives (parsed-varone-bar-2-P52 a1) = step 0 63 refl refl refl refl ((derives a1))
derives parsed-varone-range-1-P51 = step 0 64 refl refl refl refl (self-deriv 'z')
derives parsed-varone-range-1-P50 = step 0 65 refl refl refl refl (self-deriv 'y')
derives parsed-varone-range-1-P5 = step 0 66 refl refl refl refl (self-deriv 'F')
derives parsed-varone-range-1-P49 = step 0 67 refl refl refl refl (self-deriv 'x')
derives parsed-varone-range-1-P48 = step 0 68 refl refl refl refl (self-deriv 'w')
derives parsed-varone-range-1-P47 = step 0 69 refl refl refl refl (self-deriv 'v')
derives parsed-varone-range-1-P46 = step 0 70 refl refl refl refl (self-deriv 'u')
derives parsed-varone-range-1-P45 = step 0 71 refl refl refl refl (self-deriv 't')
derives parsed-varone-range-1-P44 = step 0 72 refl refl refl refl (self-deriv 's')
derives parsed-varone-range-1-P43 = step 0 73 refl refl refl refl (self-deriv 'r')
derives parsed-varone-range-1-P42 = step 0 74 refl refl refl refl (self-deriv 'q')
derives parsed-varone-range-1-P41 = step 0 75 refl refl refl refl (self-deriv 'p')
derives parsed-varone-range-1-P40 = step 0 76 refl refl refl refl (self-deriv 'o')
derives parsed-varone-range-1-P4 = step 0 77 refl refl refl refl (self-deriv 'E')
derives parsed-varone-range-1-P39 = step 0 78 refl refl refl refl (self-deriv 'n')
derives parsed-varone-range-1-P38 = step 0 79 refl refl refl refl (self-deriv 'm')
derives parsed-varone-range-1-P37 = step 0 80 refl refl refl refl (self-deriv 'l')
derives parsed-varone-range-1-P36 = step 0 81 refl refl refl refl (self-deriv 'k')
derives parsed-varone-range-1-P35 = step 0 82 refl refl refl refl (self-deriv 'j')
derives parsed-varone-range-1-P34 = step 0 83 refl refl refl refl (self-deriv 'i')
derives parsed-varone-range-1-P33 = step 0 84 refl refl refl refl (self-deriv 'h')
derives parsed-varone-range-1-P32 = step 0 85 refl refl refl refl (self-deriv 'g')
derives parsed-varone-range-1-P31 = step 0 86 refl refl refl refl (self-deriv 'f')
derives parsed-varone-range-1-P30 = step 0 87 refl refl refl refl (self-deriv 'e')
derives parsed-varone-range-1-P3 = step 0 88 refl refl refl refl (self-deriv 'D')
derives parsed-varone-range-1-P29 = step 0 89 refl refl refl refl (self-deriv 'd')
derives parsed-varone-range-1-P28 = step 0 90 refl refl refl refl (self-deriv 'c')
derives parsed-varone-range-1-P27 = step 0 91 refl refl refl refl (self-deriv 'b')
derives parsed-varone-range-1-P26 = step 0 92 refl refl refl refl (self-deriv 'a')
derives parsed-varone-range-1-P25 = step 0 93 refl refl refl refl (self-deriv 'Z')
derives parsed-varone-range-1-P24 = step 0 94 refl refl refl refl (self-deriv 'Y')
derives parsed-varone-range-1-P23 = step 0 95 refl refl refl refl (self-deriv 'X')
derives parsed-varone-range-1-P22 = step 0 96 refl refl refl refl (self-deriv 'W')
derives parsed-varone-range-1-P21 = step 0 97 refl refl refl refl (self-deriv 'V')
derives parsed-varone-range-1-P20 = step 0 98 refl refl refl refl (self-deriv 'U')
derives parsed-varone-range-1-P2 = step 0 99 refl refl refl refl (self-deriv 'C')
derives parsed-varone-range-1-P19 = step 0 100 refl refl refl refl (self-deriv 'T')
derives parsed-varone-range-1-P18 = step 0 101 refl refl refl refl (self-deriv 'S')
derives parsed-varone-range-1-P17 = step 0 102 refl refl refl refl (self-deriv 'R')
derives parsed-varone-range-1-P16 = step 0 103 refl refl refl refl (self-deriv 'Q')
derives parsed-varone-range-1-P15 = step 0 104 refl refl refl refl (self-deriv 'P')
derives parsed-varone-range-1-P14 = step 0 105 refl refl refl refl (self-deriv 'O')
derives parsed-varone-range-1-P13 = step 0 106 refl refl refl refl (self-deriv 'N')
derives (parsed-ows-P128 a1) = step 0 107 refl refl refl refl ((derives a1))
derives (parsed-ows-star-12-P127 a1 a2) = step 0 108 refl refl refl refl ((derives a1) deriv++ (derives a2))
derives (parsed-ws-P125 a1) = step 0 109 refl refl refl refl ((derives a1))
derives (parsed-ws-plus-11-P124 a1 a2) = step 0 110 refl refl refl refl ((derives a1) deriv++ (derives a2))
derives (parsed-ws-plus-11-P123 a1) = step 0 111 refl refl refl refl ((derives a1))
derives (parsed-aws-P122 a1) = step 0 112 refl refl refl refl ((derives a1))
derives (parsed-aws-bar-10-P121 a1) = step 0 113 refl refl refl refl ((derives a1))
derives parsed-aws-bar-10-P120 = step 0 114 refl refl refl refl (self-deriv '\n')
derives parsed-varone-range-1-P12 = step 0 115 refl refl refl refl (self-deriv 'M')
derives (parsed-aws-bar-9-P119 a1) = step 0 116 refl refl refl refl ((derives a1))
derives parsed-aws-bar-9-P118 = step 0 117 refl refl refl refl (self-deriv '\t')
derives (parsed-aws-bar-8-P117 a1) = step 0 118 refl refl refl refl (self-deriv '%' deriv++ (derives a1) deriv++ self-deriv '\n')
derives parsed-aws-bar-8-P116 = step 0 119 refl refl refl refl (self-deriv ' ')
derives (parsed-aws-star-7-P115 a1 a2) = step 0 120 refl refl refl refl ((derives a1) deriv++ (derives a2))
derives (parsed-aws-bar-6-P113 a1) = step 0 121 refl refl refl refl ((derives a1))
derives (parsed-aws-bar-6-P112 a1) = step 0 122 refl refl refl refl ((derives a1))
derives parsed-aws-bar-5-P111 = step 0 123 refl refl refl refl (self-deriv '%')
derives parsed-aws-bar-5-P110 = step 0 124 refl refl refl refl (self-deriv ' ')
derives parsed-varone-range-1-P11 = step 0 125 refl refl refl refl (self-deriv 'L')
derives parsed-aws-range-4-P109 = step 0 126 refl refl refl refl (self-deriv 'z')
derives parsed-aws-range-4-P108 = step 0 127 refl refl refl refl (self-deriv 'y')
derives parsed-aws-range-4-P107 = step 0 128 refl refl refl refl (self-deriv 'x')
derives parsed-aws-range-4-P106 = step 0 129 refl refl refl refl (self-deriv 'w')
derives parsed-aws-range-4-P105 = step 0 130 refl refl refl refl (self-deriv 'v')
derives parsed-aws-range-4-P104 = step 0 131 refl refl refl refl (self-deriv 'u')
derives parsed-aws-range-4-P103 = step 0 132 refl refl refl refl (self-deriv 't')
derives parsed-aws-range-4-P102 = step 0 133 refl refl refl refl (self-deriv 's')
derives parsed-aws-range-4-P101 = step 0 134 refl refl refl refl (self-deriv 'r')
derives parsed-aws-range-4-P100 = step 0 135 refl refl refl refl (self-deriv 'q')
derives parsed-varone-range-1-P10 = step 0 136 refl refl refl refl (self-deriv 'K')
derives parsed-varone-range-1-P1 = step 0 137 refl refl refl refl (self-deriv 'B')
derives parsed-varone-range-1-P0 = step 0 138 refl refl refl refl (self-deriv 'A')
derives (parsed-cmd-Norm a1 a2 a3) = step 0 139 refl refl refl refl (self-deriv 'n' deriv++ self-deriv 'o' deriv++ self-deriv 'r' deriv++ self-deriv 'm' deriv++ (derives a1) deriv++ (derives a2) deriv++ (derives a3) deriv++ self-deriv '.')
derives parsed-binder-Lam = step 0 140 refl refl refl refl (self-deriv 'λ')
derives (parsed-term-FoldUnfold a1 a2 a3 a4) = step 0 141 refl refl refl refl (self-deriv '[' deriv++ (derives a1) deriv++ (derives a2) deriv++ (derives a3) deriv++ (derives a4) deriv++ self-deriv ']')
derives (parsed-cmd-Define a1 a2 a3 a4 a5 a6 a7) = step 0 142 refl refl refl refl ((derives a1) deriv++ (derives a2) deriv++ (derives a3) deriv++ (derives a4) deriv++ self-deriv '=' deriv++ (derives a5) deriv++ (derives a6) deriv++ (derives a7) deriv++ self-deriv '.')
derives (parsed-cmds-CmdsStart a1) = step 0 143 refl refl refl refl ((derives a1))
derives (parsed-cmds-CmdsNext a1 a2 a3) = step 0 144 refl refl refl refl ((derives a1) deriv++ (derives a2) deriv++ (derives a3))
derives (parsed-start-Cmds a1 a2 a3) = step 0 145 refl refl refl refl ((derives a1) deriv++ (derives a2) deriv++ (derives a3))
derives (parsed-term-Arrow a1 a2 a3 a4) = step 0 146 refl refl refl refl ((derives a1) deriv++ (derives a2) deriv++ self-deriv '→' deriv++ (derives a3) deriv++ (derives a4))
derives (parsed-term-App a1 a2 a3) = step 0 147 refl refl refl refl ((derives a1) deriv++ (derives a2) deriv++ (derives a3))
derives parsed-binder-All = step 0 148 refl refl refl refl (self-deriv '∀')
derives (parsed-term-Abstract a1 a2 a3 a4 a5 a6 a7 a8 a9) = step 0 149 refl refl refl refl ((derives a1) deriv++ (derives a2) deriv++ (derives a3) deriv++ (derives a4) deriv++ self-deriv ':' deriv++ (derives a5) deriv++ (derives a6) deriv++ (derives a7) deriv++ self-deriv ',' deriv++ (derives a8) deriv++ (derives a9))

ptr : ParseTreeRec
ptr = record { ParseTreeT = ParseTreeT ; isParseTree = isParseTree ; ParseTreeToString = ParseTreeToString }

