#lang racket

(define numReductions 0)
(provide numReductions)

(define (reset) (set! numReductions 0))
(provide reset)

(define Czero (lambda (s) (lambda (z) z)))
(provide Czero)
(define Cone (lambda (s) (lambda (z) (s z))))
(provide Cone)
(define Ctwo (lambda (s) (lambda (z) (s (s z)))))
(provide Ctwo)
(define Cthree (lambda (s) (lambda (z) (s (s (s z))))))
(provide Cthree)
(define Cfour (lambda (s) (lambda (z) (s (s (s (s z)))))))
(provide Cfour)
(define Cfive (lambda (s) (lambda (z) (s (s (s (s (s z))))))))
(provide Cfive)
(define Csix (lambda (s) (lambda (z) (s (s (s (s (s (s z)))))))))
(provide Csix)
(define Cseven (lambda (s) (lambda (z) (s (s (s (s (s (s (s z))))))))))
(provide Cseven)
(define Ceight (lambda (s) (lambda (z) (s (s (s (s (s (s (s (s z)))))))))))
(provide Ceight)
(define Cnine (lambda (s) (lambda (z) (s (s (s (s (s (s (s (s (s z))))))))))))
(provide Cnine)
(define Cten (lambda (s) (lambda (z) (s (s (s (s (s (s (s (s (s (s z)))))))))))))
(provide Cten)
(define Celeven (lambda (s) (lambda (z) (s (s (s (s (s (s (s (s (s (s (s z))))))))))))))
(provide Celeven)
(define Csuc (lambda (n) (lambda (s) (lambda (z) (s ((n s) z))))))
(provide Csuc)
(define Cadd (lambda (n) (lambda (m) ((n Csuc) m))))
(provide Cadd)
(define Cmult (lambda (n) (lambda (m) ((n (Cadd m)) Czero))))
(provide Cmult)
(define Cexp (lambda (n) (lambda (m) ((m (Cmult n)) Cone))))
(provide Cexp)
(define CaddR (lambda (n) (lambda (m) (lambda (s) (lambda (z) ((n s) ((m s) z)))))))
(provide CaddR)
(define CmultR (lambda (n) (lambda (m) (lambda (s) (lambda (z) ((n (m s)) z))))))
(provide CmultR)
(define CexpR (lambda (n) (lambda (m) (m n))))
(provide CexpR)
(define mkpair (lambda (a) (lambda (b) (lambda (c) ((c a) b)))))
(provide mkpair)
(define Cpred (lambda (n) (((n (lambda (s) (s (lambda (a) (lambda (b) ((mkpair b) (Csuc b))))))) ((mkpair Czero) Czero)) (lambda (a) (lambda (b) a)))))
(provide Cpred)
(define Csubtract (lambda (n) (lambda (m) ((m Cpred) n))))
(provide Csubtract)
