{-# OPTIONS_GHC -XFlexibleInstances #-}
module Observe where

import Nats
import Lists

toInt :: CNat -> Int
toInt n = unfoldCNat n (\ x -> 1 + x) 0

toIntb :: Nat -> Int
toIntb n = unfoldNat n (\ x y -> 1 + y) 0

toList :: List Nat -> [Int]
toList n = unfoldList n (\ h t -> toIntb h : t) []

instance Show CNat where
  show n = show (toInt n)

instance Show Nat where
  show n = show (toIntb n)

instance Show (List Nat) where
  show n = show (toList n)

instance Show (Maybee Nat) where
  show n = unfoldMaybee n (\ x -> "just " ++ (show x)) "nothing"