{-# OPTIONS_GHC -XRankNTypes -XKindSignatures #-}
module Nats where
import System.IO.Unsafe
import Data.IORef

numReductions :: IORef Int
{-# NOINLINE numReductions #-}
numReductions = unsafePerformIO (newIORef 0)

incr :: a -> a
incr r = unsafePerformIO
           (do
               x <- readIORef numReductions
               writeIORef numReductions (x + 1)
               return r)

reset :: a -> a
reset r = unsafePerformIO
           (do
               writeIORef numReductions 0
               return r)

getNumReds :: () -> Int
getNumReds () = (unsafePerformIO (readIORef numReductions))
newtype CNat  = FoldCNat { unfoldCNat :: forall (x :: *) . (x -> x) -> x -> x}

czero :: CNat
czero = (FoldCNat (\ s -> (\ z -> z)))

cone :: CNat
cone = (FoldCNat (\ s -> (\ z -> (s z))))

ctwo :: CNat
ctwo = (FoldCNat (\ s -> (\ z -> (s ((s z))))))

cfour :: CNat
cfour = (FoldCNat (\ s -> (\ z -> (s ((s ((s ((s z))))))))))

csuc :: CNat -> CNat
csuc = (\ n -> (FoldCNat (\ s -> (\ z -> (s ((((unfoldCNat n) s) z)))))))

cadd :: CNat -> CNat -> CNat
cadd = (\ n -> (\ m -> (((unfoldCNat n) csuc) m)))

cmult :: CNat -> CNat -> CNat
cmult = (\ n -> (\ m -> (((unfoldCNat n) ((cadd m))) czero)))

cexp :: CNat -> CNat -> CNat
cexp = (\ n -> (\ m -> (((unfoldCNat m) ((cmult n))) cone)))

caddR :: CNat -> CNat -> CNat
caddR = (\ n -> (\ m -> (FoldCNat (\ s -> (\ z -> (((unfoldCNat n) s) ((((unfoldCNat m) s) z))))))))

cmultR :: CNat -> CNat -> CNat
cmultR = (\ n -> (\ m -> (FoldCNat (\ s -> (\ z -> (((unfoldCNat n) (((unfoldCNat m) s))) z))))))

cexpR :: CNat -> CNat -> CNat
cexpR = (\ n -> (\ m -> (FoldCNat ((unfoldCNat m) ((unfoldCNat n))))))

newtype Pair a b = FoldPair { unfoldPair :: forall (x :: *) . (a -> b -> x) -> x}

mkpair :: forall (a :: *) . forall (b :: *) . a -> b -> Pair a b
mkpair = (\ aa -> (\ bb -> (FoldPair (\ c -> ((c aa) bb)))))

cpred :: CNat -> CNat
cpred = (\ n -> ((unfoldPair (((((unfoldCNat n) (\ s -> ((unfoldPair s) (\ a -> (\ b -> ((mkpair b) ((csuc b))))))))) (((mkpair czero) czero))))) (\ a -> (\ b -> a))))

csubtract :: CNat -> CNat -> CNat
csubtract = (\ n -> (\ m -> (((unfoldCNat m) cpred) n)))

