{-# OPTIONS_GHC -XRankNTypes -XKindSignatures #-}
module Lists where
import System.IO.Unsafe
import Data.IORef

numReductions :: IORef Int
{-# NOINLINE numReductions #-}
numReductions = unsafePerformIO (newIORef 0)

incr :: a -> a
incr r = unsafePerformIO
           (do
               x <- readIORef numReductions
               writeIORef numReductions (x + 1)
               return r)

reset :: a -> a
reset r = unsafePerformIO
           (do
               writeIORef numReductions 0
               return r)

getNumReds :: () -> Int
getNumReds () = (unsafePerformIO (readIORef numReductions))
newtype Pair a b = FoldPair { unfoldPair :: forall (x :: *) . (a -> b -> x) -> x}

mkpair :: forall (a :: *) . forall (b :: *) . a -> b -> Pair a b
mkpair = (\ aa -> (\ bb -> (FoldPair (\ c -> ((c aa) bb)))))

newtype Boole  = FoldBoole { unfoldBoole :: forall (x :: *) . x -> x -> x}

true :: Boole
true = (FoldBoole (\ a -> (\ b -> a)))

false :: Boole
false = (FoldBoole (\ a -> (\ b -> b)))

nott :: Boole -> Boole
nott = (\ b -> (((unfoldBoole b) false) true))

newtype Maybee a = FoldMaybee { unfoldMaybee :: forall (x :: *) . (a -> x) -> x -> x}

just :: forall (a :: *) . a -> Maybee a
just = (\ u -> (FoldMaybee (\ s -> (\ n -> (s u)))))

nothing :: forall (a :: *) . Maybee a
nothing = (FoldMaybee (\ s -> (\ n -> n)))

newtype Nat  = FoldNat { unfoldNat :: forall (x :: *) . (Nat -> x -> x) -> x -> x}

zero :: Nat
zero = (FoldNat (\ s -> (\ z -> z)))

one :: Nat
one = (FoldNat (\ s -> (\ z -> ((s zero) z))))

iszero :: Nat -> Boole
iszero = (\ n -> ((((unfoldNat n) (\ p -> (\ f -> false)))) true))

suc :: Nat -> Nat
suc = (\ n -> (FoldNat (\ s -> (\ z -> ((s n) ((((unfoldNat n) s) z)))))))

add :: Nat -> Nat -> Nat
add = (\ n -> (\ m -> ((((unfoldNat n) (\ p -> suc))) m)))

mult :: Nat -> Nat -> Nat
mult = (\ n -> (\ m -> ((((unfoldNat n) (\ p -> (add m)))) zero)))

exp :: Nat -> Nat -> Nat
exp = (\ n -> (\ m -> ((((unfoldNat m) (\ p -> (mult n)))) one)))

prd :: Nat -> Nat
prd = (\ n -> ((((unfoldNat n) (\ p -> (\ d -> p)))) zero))

lt :: Nat -> Nat -> Boole
lt = (\ n -> ((((unfoldNat n) (\ pn -> (\ r -> (\ m -> ((((unfoldNat m) (\ pm -> (\ rr -> (r pm))))) false)))))) (\ m -> (nott ((iszero m))))))

newtype Braun a = FoldBraun { unfoldBraun :: forall (x :: *) . (a -> x) -> (x -> x -> x) -> x}

braunLeaf :: forall (a :: *) . a -> Braun a
braunLeaf = (\ b -> (FoldBraun (\ l -> (\ n -> (l b)))))

braunNode :: forall (a :: *) . Braun a -> Braun a -> Braun a
braunNode = (\ l -> (\ r -> (FoldBraun (\ ll -> (\ n -> ((n ((((unfoldBraun l) ll) n))) ((((unfoldBraun r) ll) n))))))))

braunInsert :: forall (a :: *) . a -> Braun a -> Braun a
braunInsert = (\ u -> (\ b -> ((unfoldPair (((((unfoldBraun b) (\ aa -> ((mkpair ((braunLeaf aa))) (((braunNode ((braunLeaf u))) ((braunLeaf aa)))))))) (\ pL -> (\ pR -> ((unfoldPair pL) (\ l -> (\ iL -> ((unfoldPair pR) (\ r -> (\ iR -> ((mkpair (((braunNode l) r))) (((braunNode iR) l)))))))))))))) (\ b -> (\ ib -> ib)))))

newtype List a = FoldList { unfoldList :: forall (x :: *) . (a -> x -> x) -> x -> x}

nil :: forall (a :: *) . List a
nil = (FoldList (\ c -> (\ n -> n)))

cons :: forall (a :: *) . a -> List a -> List a
cons = (\ u -> (\ l -> (FoldList (\ c -> (\ n -> ((c u) ((((unfoldList l) c) n))))))))

singleton :: forall (a :: *) . a -> List a
singleton = (\ u -> (FoldList (\ c -> (\ n -> ((c u) n)))))

listToBraunTree :: forall (a :: *) . a -> List a -> Braun a
listToBraunTree = (\ u -> (\ l -> ((((unfoldList l) (\ u -> (\ r -> ((braunInsert u) r))))) ((braunLeaf u)))))

natsBelow :: Nat -> List Nat
natsBelow = (\ n -> ((((unfoldNat n) (\ p -> (\ l -> ((cons p) l))))) (nil)))

append :: forall (a :: *) . List a -> List a -> List a
append = (\ la -> (\ lb -> ((((unfoldList la) (\ u -> (\ r -> ((cons u) r))))) lb)))

appendRepeat :: Nat -> forall (a :: *) . List a -> List a
appendRepeat = (\ n -> (\ l -> ((((unfoldNat n) (\ p -> (\ ll -> ((append l) ll))))) (nil))))

tl :: forall (a :: *) . List a -> List a
tl = (\ l -> ((unfoldPair (((((unfoldList l) (\ u -> (\ p -> ((unfoldPair p) (\ x -> (\ y -> ((mkpair y) (((cons u) y)))))))))) (((mkpair (nil)) (nil)))))) (\ x -> (\ y -> x))))

hd :: forall (a :: *) . List a -> Maybee a
hd = (\ l -> ((((unfoldList l) (\ u -> (\ t -> (just u))))) (nothing)))

nthTl :: Nat -> forall (a :: *) . List a -> List a
nthTl = (\ n -> (\ l -> ((((unfoldNat n) (\ p -> (\ r -> (tl r))))) l)))

nth :: Nat -> forall (a :: *) . List a -> Maybee a
nth = (\ n -> (\ l -> (hd (((nthTl n) l)))))

merge :: forall (a :: *) . (a -> a -> Boole) -> List a -> List a -> List a
merge = (\ cmp -> (\ la -> ((((((unfoldList la) (\ u -> (\ outer -> (\ la -> (\ lb -> ((((unfoldMaybee ((hd la))) (\ ha -> ((((((unfoldList lb) (\ uu -> (\ inner -> (\ lb -> ((((unfoldMaybee ((hd lb))) (\ hb -> (((unfoldBoole (((cmp ha) hb))) (((cons ha) (((outer ((tl la))) lb))))) (((cons hb) ((inner ((tl lb)))))))))) la)))))) (\ lb -> la))) lb)))) lb))))))) (\ la -> (\ lb -> lb)))) la)))

mergeSort :: forall (a :: *) . (a -> a -> Boole) -> List a -> List a
mergeSort = (\ cmp -> (\ la -> ((((unfoldMaybee ((hd la))) (\ u -> (((unfoldBraun (((listToBraunTree u) ((tl la))))) (singleton)) (\ la -> (\ lb -> (((merge cmp) la) lb))))))) (nil))))

