#lang racket

(define numReductions 0)
(provide numReductions)

(define (reset) (set! numReductions 0))
(provide reset)

(define triv (lambda (x) x))
(provide triv)
(define Pzero (lambda (s) (lambda (z) z)))
(provide Pzero)
(define Pone (lambda (s) (lambda (z) ((s Pzero) (lambda (u) z)))))
(provide Pone)
(define Psuc (lambda (n) (lambda (s) (lambda (z) ((s n) (lambda (u) ((n s) z)))))))
(provide Psuc)
(define Padd (lambda (n) (lambda (m) ((n (lambda (P) (lambda (s) (Psuc (s triv))))) m))))
(provide Padd)
(define Pmult (lambda (n) (lambda (m) ((n (lambda (P) (lambda (s) ((Padd m) (s triv))))) Pzero))))
(provide Pmult)
(define Pexp (lambda (n) (lambda (m) ((m (lambda (P) (lambda (s) ((Pmult n) (s triv))))) Pone))))
(provide Pexp)
(define Ppred (lambda (n) ((n (lambda (P) (lambda (s) P))) Pzero)))
(provide Ppred)
(define Psubtract (lambda (n) (lambda (m) ((m (lambda (P) (lambda (s) (Ppred (s triv))))) n))))
(provide Psubtract)
