module domains where

open import Level hiding (suc ; _⊔_)
open import Relation.Binary.PropositionalEquality
open import Data.Nat
open import Data.Bool
open import Data.Sum
open import util

module top(ℓ : Level.Level) where

  ℓ' = Level.suc ℓ

  record poset : Set ℓ' where
    field X : Set ℓ
          _⊑_ : X → X → Set ℓ
          reflexivity : ∀ (x : X) → x ⊑ x 
          transitivity : ∀ (x y z : X) → x ⊑ y → y ⊑ z → x ⊑ z
          antisymmetry : ∀ (x y : X) → x ⊑ y → y ⊑ x → x ≡ y

  record ω-chain(p : poset) : Set ℓ' where
    X = poset.X p
    _⊑_ = poset._⊑_ p
    field f : ℕ → X
          increasing : Increasing f _⊑_ 

  upperbound : ∀ {p : poset} → poset.X p → ω-chain p → Set ℓ
  upperbound{p} x c = let open ω-chain c in 
                    ∀ (n : ℕ) → f n ⊑ x

  record predomain : Set ℓ' where
    field p : poset 
    open poset p
    field ⊔_ : ω-chain p → X 
          ⊔-upper : ∀ (c : ω-chain p) → upperbound (⊔ c) c 
          ⊔-least : ∀ (c : ω-chain p) (u : X) → upperbound u c → (⊔ c) ⊑ u

  record domain : Set ℓ' where
    field pd : predomain
    open predomain pd
    open poset p
    field ⊥ : X
          ⊥-least : ∀ (x : X) → ⊥ ⊑ x

  ω-chain-mono : ∀ (p : poset)(c : ω-chain p) (n n' : ℕ) → let open ω-chain c in
                 n ≤ℕ n' ≡ true →
                 f n ⊑ f n'
  ω-chain-mono p c n 0 u' rewrite ≤ℕ-zero n u' = let open ω-chain c in let open poset p in reflexivity (f 0)
  ω-chain-mono p c n (suc n') u' with Bool-dec (n =ℕ (suc n'))
  ω-chain-mono p c n (suc n') u' | inj₁ u rewrite =ℕ-to-equiv n (suc n') u = 
    let open ω-chain c in let open poset p in reflexivity (f (suc n'))
  ω-chain-mono p c n (suc n') u' | inj₂ u = 
    let open ω-chain c in let open poset p in 
        transitivity (f n) (f n') (f (suc n'))
            (ω-chain-mono p c n n' (≤ℕ-strict-decrease n n' (=ℕ-equiv-false n (suc n') u) u' ))
            (increasing n')

  poset-cycles-trivial : ∀ (p : poset) → let open poset p in
                         ∀ (a b c : X) → 
                           a ⊑ b → 
                           b ⊑ c → 
                           c ⊑ a → 
                           b ≡ c
  poset-cycles-trivial p a b c p1 p2 p3 = let open poset p in antisymmetry b c p2 (transitivity c a b p3 p1) 