module continuous where 

import Level
open import util
open import Data.Nat
open import Data.Bool
open import Relation.Binary.PropositionalEquality
import domains
open import domains-examples

module top(ℓ : Level.Level) where

  open domains.top ℓ

  record _→m_ (p₁ p₂ : poset) : Set ℓ' where
    open poset
    X₁ = X p₁ 
    X₂ = X p₂
    _⊑₁_ = _⊑_ p₁ 
    _⊑₂_ = _⊑_ p₂
    field
      f : X₁ → X₂
      monotonicity : ∀ (x x' : X₁) → x ⊑₁ x' → f x ⊑₂ f x'

  record Cont (pd₁ pd₂ : predomain) : Set ℓ' where
    open predomain 
    open poset
    p₁ = p pd₁
    p₂ = p pd₂
    X₁ = X p₁ 
    X₂ = X p₂
    _⊑₁_ = _⊑_ p₁ 
    _⊑₂_ = _⊑_ p₂
    ⊔₁_ = ⊔_ pd₁
    ⊔₂_ = ⊔_ pd₂
    field
      m : p₁ →m p₂
    open _→m_ m
    field
      continuity : ∀ (c : ω-chain p₁) → 
                   let c' : ω-chain p₂ 
                       c' = record { f = λ x → f (ω-chain.f c x) ; 
                                     increasing = λ (n : ℕ) → monotonicity (ω-chain.f c n) (ω-chain.f c (suc n)) 
                                                                           (ω-chain.increasing c n)}
                   in 
                     f (⊔₁ c) ≡ ⊔₂ c'
    
module examples where

  open top Level.zero

  double : ℕω → ℕω
  double (+ x) = + (2 * x)
  double ω = ω

  double-monotonicity : ∀ (x x' : ℕω) → x ≤ℕω x' ≡ true → double x ≤ℕω double x' ≡ true
  double-monotonicity ω ω p = refl
  double-monotonicity (+ x) ω p = refl
  double-monotonicity ω (+ x) ()
  double-monotonicity (+ x) (+ y) p rewrite +-right-id x | +-right-id y = 
    {- the chain of reasoning is to go from x + x to y + x, and then to y + y,
       using monotonicity lemmas about plus, proved now in util.agda -}
    ≤ℕ-trans (x + x) (y + x) (y + y) 
      (≤ℕ+-mono-left x y x p)
      (≤ℕ+-mono-right x y y p)

  double-mono : ℕω-poset →m ℕω-poset
  double-mono = record { f = double ;
                         monotonicity = double-monotonicity } 
