package untrusted;

import trusted.*;

public class MergeSort {

    public static class MergeInv1 {
	public final List l;
	public final Sorted p1; 
	public final Min p2;

	public MergeInv1(List _l, Sorted _p1, Min _p2) {
	    l = _l;
	    p1 = _p1;
	    p2 = _p2;
	}
    }

    // l2 is non-null, but l1 might be null.
    protected static Or<MergeInv1,Null>
	Merge2NonNull(final List l1, final List l2, 
		      final Sorted p1, 
		      final Sorted p2,
		      final NonNull p3) {
	SortedA.SortedOk(l1,p1);
	SortedA.SortedOk(l2,p2);
	NullA.NonNullOk(l2,p3);
	
	return NullA.isNull(l1).visit
	    (new OrVisitor<Null,NonNull,Or<MergeInv1,Null>>() {
		public Or<MergeInv1,Null> visitOr1(Null p) {
		    return new Or2<MergeInv1,Null>(p);
		}
		public Or<MergeInv1,Null> visitOr2(NonNull p) {
		    MergeInv1 r = MergeNonNull(l1,l2,p1,p2,p,p3);
		    return new Or1<MergeInv1,Null>(r);
		}
	    });
    }

    // this assumes l1 and l2 are non-null
    public static MergeInv1
	MergeNonNull(final List l1, final List l2, 
		     final Sorted p1, 
		     final Sorted p2,
		     final NonNull p3,
		     final NonNull p4) {
	SortedA.SortedOk(l1,p1);
	SortedA.SortedOk(l2,p2);
	NullA.NonNullOk(l1,p3);
	NullA.NonNullOk(l2,p4);
	return LeqA.compare(l1.data, l2.data).visit
	    (new OrVisitor<Leq,Leq,MergeInv1>() {
		
		// the case is for l1.data <= l2.data.
		public MergeInv1 visitOr1(final Leq c) {
		    
		    Or<MergeInv1,Null> r = 
			Merge2NonNull(l1.next, 
				      l2, SortedA.sublistSorted(l1,p1),
				      p2, p4);
		    
		    final SortedA.Helper n = r.visit
			(new OrVisitor<MergeInv1,Null, SortedA.Helper>() {
			    public SortedA.Helper visitOr1(MergeInv1 I) {
				Leq pp = 
				    LeqA.leqMin(l1.data, 
						I.l.data, l1.next.data,
						l2.data,
						SortedA.step(l1,p1),c,I.p2);

				return SortedA.buildSorted1
				    (l1.data, I.l, I.p1, pp);
			    }
	
			    // l1.next is null
			    public SortedA.Helper visitOr2(Null p) {
				return
				    SortedA.buildSorted1(l1.data, l2, p2, c);
			    }
			});
		    
		    return new MergeInv1
			(n.l, n.p1, 
			 MinA.minEquals(l1.data,
					l1.data,
					l2.data,
					n.l.data,
					MinA.min(l1.data, 
						 l2.data, c),
					n.p2));
		    
		    }
	    
		public MergeInv1 visitOr2(Leq c) {
		    MergeInv1 r = MergeNonNull(l2,l1,p2,p1,p4,p3);
		    return new MergeInv1(r.l, r.p1,
					 MinA.minSymm(r.l.data,
						      l2.data, l1.data,
						      r.p2));
		}
	    });
	}


    public static void main(String args[]) throws java.awt.AWTException {
	final SortedA.Helper h1 = 
	    SortedA.buildSorted2(15, null, NullA.nullIsNull());
	final SortedA.Helper h2 = 
	    SortedA.buildSorted1(8, h1.l, h1.p1, 
				 LeqA.leqEquals(8,15,h1.l.data,
						LeqA.assertLeq(8,15), h1.p2));
	final SortedA.Helper h3 = 
	    SortedA.buildSorted1(3, h2.l, h2.p1, 
				 LeqA.leqEquals(3,8,h2.l.data,
						LeqA.assertLeq(3,8), h2.p2));
	

	final SortedA.Helper k1 = 
	    SortedA.buildSorted2(15, null, NullA.nullIsNull());
	final SortedA.Helper k2 = 
	    SortedA.buildSorted1(9, k1.l, k1.p1, 
				 LeqA.leqEquals(9,15,k1.l.data,
						LeqA.assertLeq(9,15), k1.p2));
	final SortedA.Helper k3 = 
	    SortedA.buildSorted1(2, k2.l, k2.p1, 
				 LeqA.leqEquals(2,9,k2.l.data,
						LeqA.assertLeq(2,9), k2.p2));

	NonNull nh = NullA.assertNonNull(h3.l);
	NonNull nk = NullA.assertNonNull(k3.l);

	MergeInv1 m = MergeNonNull(h3.l, k3.l, h3.p1, k3.p1, nh, nk);

	SortedA.SortedOk(m.l,m.p1);
	MinA.MinOk(m.l.data, h3.l.data, k3.l.data, m.p2);

	List r = m.l;
	while (r != null) {
	    System.out.println(Integer.toString(r.data));
	    r=r.next;
	}
	System.out.println("null");
    }	
}
