package trusted;
import untrusted.List;

public class SortedA {
    public static Sorted nullSorted() {
	return new Sorted(null);
    }

    public static void SortedOk(List l, Sorted p) throws BadProof {
	if (p.l != l) 
	    throw new BadProof();
    }

    // precondition: l.next is non-null.
    public static Sorted sublistSorted(List l, Sorted p) throws BadProof {
	SortedOk(l,p);
	return new Sorted(l.next);
    }

    public static Leq step(List l, Sorted p1) {
	SortedOk(l,p1);
	return new Leq(l.data, l.next.data);
    }

    public static class Helper { // indexed by an int i
	public final List l;
	public final Sorted p1;
	public final IntEquals p2; // l.data = i
	public Helper(final List _l, Sorted _p1, IntEquals _p2) {
	    l = _l;
	    p1 = _p1;
	    p2 = _p2;
	}
    }

    public static Helper buildSorted1(int i, List l, Sorted p1, Leq p2) 
	throws BadProof
    {
	SortedOk(l,p1);
	LeqA.LeqOk(i,l.data,p2);

	final List n = new List(i, l);
	return new Helper(n, new Sorted(n),
			  new IntEquals(i,n.data));
    }

    public static Helper buildSorted2(int i, List l, Null p) throws BadProof
    {
	NullA.NullOk(l,p);
	final List n = new List(i,l);
	return new Helper(n, new Sorted(n),
			  new IntEquals(i,n.data));
    }
}
    
