package trusted;

public class MinA {

    public static void MinOk(int i, int j, int k, Min p) throws BadProof {
	if (p.i != i || p.j != j || p.k != k)
	    throw new BadProof();
    }

    // return a proof that i is the min of i and j if i <= j.
    public static Min min(int i, int j, Leq p) {
	LeqA.LeqOk(i,j,p);
	return new Min(i,i,j);
    }

    public static Min minSymm(final int i,
			      final int j,
			      final int k,
			      Min p1) {
	MinOk(i,j,k,p1);
	return new Min(i,k,j);
    }

    public static Min minEquals(final int i,
				final int j,
				final int k,
				final int ip,
				Min p1, IntEquals p2) throws BadProof {
	IntEqualsA.IntEqualsOk(i,ip,p2);
	MinOk(i,j,k,p1);
	if (p1.i != p2.i)
	    throw new BadProof();
	return new Min(ip,j,k);
    }
}
