package trusted;

public class LeqA {

    // Or1 is for when i <= j, Or2 for when j <= i.
    public static Or<Leq,Leq> compare(int i, int j) {
	if (i <= j)
	    return new Or1<Leq,Leq>(new Leq(i, j));
	return new Or2<Leq,Leq>(new Leq(j, i));
    }

    public static Leq assertLeq(int i, int j) throws BadProof {
	if (i > j)
	    throw new BadProof();
	return new Leq(i,j);
    }

    public static void LeqOk(int i, int j, Leq p) throws BadProof {
	if (p.i != i || p.j != j)
	    throw new BadProof();
    }

    // given proofs of pi<=q.j and pi<=q.k, where p1.i = p2.i = pi
    // return a proof of p1.i<=q.i.
    public static Leq leqMin(final int pi, 
			     final int qi, final int qj, final int qk,
			     Leq p1, Leq p2, Min q) throws BadProof {
	LeqOk(pi, qj, p1);
	LeqOk(pi, qk, p2);
	if (p1.i != p2.i || p1.i != pi) 
	    throw new BadProof();
	return new Leq(pi, q.i);
    }

    public static Leq leqTrans(final int x, final int y, final int z,
			       Leq p1, Leq p2) {
	LeqOk(x,y,p1);
	LeqOk(y,z,p2);
	return new Leq(x,z);
    }

    public static Leq leqZ(final int x) {
	return new Leq(x,x);
    }

    public static Leq leqEquals(int i, int j, int jp, Leq p1, IntEquals p2) {
	LeqOk(i,j,p1);
	IntEqualsA.IntEqualsOk(j,jp,p2);
	return new Leq(i,jp);
    }
}
