package primes;

import java.util.Iterator;
import java.util.Set;

import primes.trusted.SetManager;
import primes.trusted.FactorManager;

import static primes.trusted.SetManager.*;
import static primes.trusted.FactorManager.*;

public class Client {

    private static FactorBundle 
        square(long n, 
               Set factors, 
               HasFactors proof) {
        return multiply(n, factors, proof, 
                        n, factors, proof);
    }

    private static FactorBundle exp0(final long base0, 
                                     int power) {
        if (1 > power) {
            throw new IllegalArgumentException("non-positive exponent");
        } else {

            FactorBundle result = factor(base0);
            FactorBundle base = factor(base0);

            while (1 < power) {
                result = multiply(result.n, 
                                  result.factors, 
                                  result.proof, 
                                  base.n, 
                                  base.factors, 
                                  base.proof);
                if (1 == (power % 2)) { 
                    power--;
                } else {
                    power /= 2;
                    base = square(base.n, 
                                  base.factors, 
                                  base.proof);
                }
            }
            return result;
        }
    }

    public static class ExpBundle {
        // base, factors, and factor proof
        public final FactorBundle base;

        // result, factors and factor proof
        public final FactorBundle result;
        
        // :: pf (baseFactors == resultFactors)
        public final Eq proof;

        public ExpBundle(final FactorBundle base,
                         final FactorBundle result,
                         final Eq proof) {
            this.base = base;
            this.result = result;
            this.proof = proof;
        }
    }


    private static ExpBundle
        expHelper(final FactorBundle base0, // factors of base0
                  final FactorBundle base1, // factors of base1
                  final Eq eq01, // equality between factors
                  final FactorBundle prev, // prev result
                  final Eq eq1p, //  base1.factors = prev.factors
                  int power) {
        
        if (power > 1) {
            final FactorBundle current = 
                multiply(base1.n, 
                         base1.factors, 
                         base1.proof,
                         prev.n, 
                         prev.factors, 
                         prev.proof);
                            
            // pf (fb1.factors == curr.factors)
            final EqBundle eq1c = 
                unionEqualSets1(base1.factors, // a
                                prev.factors, // b
                                current.union.aub, // a U b
                                current.union.proof, // pf (a U b)
                                eq1p); // pf (a == b)
            if (1 == (power % 2)) { 
                return expHelper(base0, base1, eq01, 
                                 current, eq1c.proof, 
                                 --power);
            } else {
                final FactorBundle base2 = 
                    square(base1.n, 
                           base1.factors, 
                           base1.proof);
                // pf (base1.factors == base2.factors)
                final EqBundle eq12 = 
                    unionEqualSets2(base1.factors,
                                    base1.factors,
                                    base2.union.aub,
                                    base2.union.proof,
                                    refl(base1.factors).
                                    proof);
                
                // pf (base0.factors == base1.factors)
                final EqBundle eq02 = 
                    trans(base0.factors, 
                          base1.factors, 
                          base2.factors,
                          eq01, eq12.proof);

                // pf (base2.factors == current.factors)
                final EqBundle eq2c = 
                    trans(base2.factors, 
                          base1.factors, 
                          current.factors,
                          symm(base1.factors, 
                               base2.factors,
                               eq12.proof).
                          proof,
                          eq1c.proof);
                return expHelper(base0, base2, eq02.proof, 
                                 current, eq2c.proof, power/2);
            }
        } else {
            final EqBundle eq0p =
                trans(base0.factors,
                      base1.factors, 
                      prev.factors,
                      eq01, eq1p);
            
            return new ExpBundle(base0, prev, eq0p.proof);
        }
    }

    public static ExpBundle exp(final long base0, 
                                final int power) {
        if (1 > power) {
            throw new IllegalArgumentException("non-positive exponent");
        } else {
            final FactorBundle fb0 = 
                factor(base0);
            final EqBundle f0eqf1 = 
                refl(fb0.factors);
            return expHelper(fb0, fb0, f0eqf1.proof,
                             fb0, f0eqf1.proof, power);
        }
    }

    public static void main(String[] args) {
        ExpBundle e;
        for (int i = 1; i < Integer.parseInt(args[1]); i++) {
            e = exp(Long.parseLong(args[0]), i);
            System.out.println("a: " + exp0(Long.parseLong(args[0]), i));
            System.out.println("b: " + e.result  + 
                               ", "  + e.base + 
                               ", " + e.proof);
        }
    }
}