/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.dist;

import rvl.stat.dist.Beta;
import rvl.stat.dist.RsqAux;
import rvl.util.MoreMath;
import rvl.util.Solve;
import rvl.util.Utility;

public class Rsquare {
    static double errtol = 1.0E-10;
    static int maxiter = 1000;

    public static double cdf(double d, double d2, int n, double d3) {
        double d4;
        if (n < 1 || d2 < (double)n) {
            Utility.warning("Rsquare.cdf: illegal values of N or p");
            return Double.NaN;
        }
        if (d3 < 0.0) {
            Utility.warning("Rsquare.cdf: rho2 must be nonnegative");
            return Double.NaN;
        }
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return 1.0;
        }
        double d5 = d2 - 1.0;
        int n2 = (int)(d5 * d3 / (2.0 * (1.0 - d3)));
        double d6 = ((double)n - 1.0) / 2.0 + (double)n2;
        double d7 = (d5 - (double)n + 1.0) / 2.0;
        double d8 = Beta.cdf(d, d6, d7);
        if (d3 < 1.0E-12) {
            return d8;
        }
        double d9 = d8;
        double d10 = Math.exp((d6 - 1.0) * Math.log(d) + d7 * Math.log(1.0 - d) + MoreMath.logGamma(d6 + d7 - 1.0) - MoreMath.logGamma(d6) - MoreMath.logGamma(d7));
        double d11 = d10 * (d6 + d7 - 1.0) * d / d6;
        double d12 = d4 = Math.exp(MoreMath.logGamma(d5 / 2.0 + (double)n2) - MoreMath.logGamma(n2 + 1) - MoreMath.logGamma(d5 / 2.0) + (double)n2 * Math.log(d3) + d5 / 2.0 * Math.log(1.0 - d3));
        double d13 = 1.0 - d4;
        double d14 = d4 * d8;
        boolean bl = false;
        int n3 = 1;
        while (!bl) {
            d4 = d4 * (d5 / 2.0 + (double)n2 + (double)n3 - 1.0) * d3 / (double)(n2 + n3);
            d14 += d4 * (d8 -= (d10 *= (d6 + d7 + (double)n3 - 2.0) * d / (d6 + (double)n3 - 1.0)));
            double d15 = d13 * d8;
            d13 -= d4;
            if (n3 > n2) {
                if (d15 < errtol || n3 > maxiter) {
                    bl = true;
                }
            } else {
                d14 += (d12 *= (double)(n2 - n3 + 1) / (d3 * (d5 / 2.0 + (double)n2 - (double)n3))) * (d9 += (d11 *= (d6 - (double)n3 + 1.0) / (d * (d6 + d7 - (double)n3))));
                if ((d13 -= d12) < errtol || n3 > maxiter) {
                    bl = true;
                }
            }
            if (n3 > maxiter) {
                Utility.warning("Convergence failure in Rsquare.cdf");
            }
            ++n3;
        }
        return d14;
    }

    public static double cdf(double d, double d2, int n) {
        return Rsquare.cdf(d, d2, n, 0.0);
    }

    public static double quantile(double d, double d2, int n, double d3) {
        if (n < 1 || d2 < (double)n) {
            Utility.warning("Rsquare.quantile: illegal values of N or p");
            return Double.NaN;
        }
        if (d3 < 0.0) {
            Utility.warning("Rsquare.quantile: rho2 must be nonnegative");
            return Double.NaN;
        }
        double d4 = d < 0.0 ? 0.0 : (d = d > 1.0 ? 1.0 : d);
        if (d * (1.0 - d) == 0.0) {
            return n;
        }
        double d5 = d3 / (1.0 - d3);
        double d6 = Beta.quantile(d, n, d2 - (double)n - 1.0, d5 * (d2 - 1.0));
        RsqAux rsqAux = new RsqAux(d2, n, d3);
        return Solve.search(rsqAux, d, d6, 0.01);
    }

    public static double quantile(double d, double d2, int n) {
        return Rsquare.quantile(d, d2, n, 0.0);
    }
}

