/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.dist;

import rvl.stat.dist.Chi2Aux;
import rvl.stat.dist.Chi2Aux2;
import rvl.stat.dist.Normal;
import rvl.util.MoreMath;
import rvl.util.NumAnal;
import rvl.util.Solve;
import rvl.util.Utility;

public class Chi2 {
    private static double saveLambda = 0.0;
    private static double saveDf = 1.0;
    static /* synthetic */ Class class$rvl$stat$dist$Chi2;

    public static double cdf(double d, double d2) {
        return Chi2.cdf(d, d2, 0.0);
    }

    public static double cdf(double d, double d2, double d3) {
        double d4;
        double d5;
        double d6;
        double d7 = 1.0E-8;
        int n = 500;
        if (d <= 0.0) {
            return 0.0;
        }
        if (d2 < 0.01) {
            Utility.warning("Chi2.cdf: df must be positive");
            return Double.NaN;
        }
        if (d3 < 0.0) {
            Utility.warning("Chi2.cdf: lambda must be nonnegative");
            return Double.NaN;
        }
        double d8 = 0.0;
        double d9 = d / 2.0;
        double d10 = d2 / 2.0;
        double d11 = Math.exp(d10 * Math.log(d9) - d9 - MoreMath.logGamma(d10));
        int n2 = 1;
        if (d / d2 > 1.0) {
            d6 = 0.0;
            double d12 = d11 / d9;
            d5 = 1.0 / d9;
            do {
                double d13;
                double d14;
                if (2 * (++n2 / 2) < n2) {
                    d14 = ((double)n2 - 1.0) / 2.0;
                    d13 = d9;
                } else {
                    d14 = ((double)n2 - d2) / 2.0;
                    d13 = 1.0;
                }
                d5 = 1.0 / (d14 * d5 + d13);
                d4 = d12;
                d12 = d5 * (d14 * d6 + d13 * d12);
                d6 = d5 * d4;
            } while (Math.abs((d4 = d8) - (d8 = 1.0 - d12)) >= d7 && n2 <= n);
            if (n2 > n) {
                Utility.warning("Chi2.cdf: convergence failure");
            }
        } else {
            d8 = d4 = d11 / d10;
            do {
                d8 += (d4 *= d / (d2 + (double)(2 * n2)));
            } while (d4 >= d7 && ++n2 <= n);
            if (n2 > n) {
                Utility.warning("Chi2.cdf: convergence failure");
            }
        }
        if (d3 > 0.0) {
            double d15 = Math.exp(-d3 / 2.0);
            d5 = 1.0 - d15;
            d6 = d8 - d11 / d10;
            d11 = d11 * d9 / (d10 * (d10 + 1.0));
            d10 += 2.0;
            d8 *= d15;
            n2 = 0;
            do {
                d8 += d15 * d6;
                d10 += 1.0;
            } while ((d5 -= (d15 *= d3 / (double)(2 * ++n2))) * (d6 -= (d11 *= d9 / d10)) >= d7 && n2 <= n);
            if (n2 > n) {
                Utility.warning("Chi2.cdf: convergence failure");
            }
        }
        return d8;
    }

    public static double quantile(double d, double d2) {
        return Chi2.quantile(d, d2, 0.0);
    }

    public static double quantile(double d, double d2, double d3) {
        if (d < 0.0 || d >= 1.0) {
            Utility.warning("Chi2.quantile: p must be in [0,1)");
            return Double.NaN;
        }
        if (d3 < 0.0) {
            Utility.warning("Chi2.quantile: lambda must be nonnegative");
            return Double.NaN;
        }
        if (d2 < 0.01) {
            Utility.warning("Chi2.quantile: df must be positive");
            return Double.NaN;
        }
        double d4 = d2 + d3 + Normal.quantile(d) * Math.sqrt(2.0 * d2 + 4.0 * d3);
        Chi2Aux chi2Aux = new Chi2Aux(d2, d3);
        return Solve.search(chi2Aux, d, d4, 0.1);
    }

    public static double power(double d, double d2, double d3) {
        if (d3 <= 0.0 || d3 >= 1.0) {
            Utility.warning("Chi2.power: alpha must be in (0,1)");
            return Double.NaN;
        }
        if (d < 0.0) {
            Utility.warning("Chi2.power: lambda must be nonnegative");
            return Double.NaN;
        }
        if (d2 < 0.01) {
            Utility.warning("Chi2.power: df must be positive");
            return Double.NaN;
        }
        double d4 = Chi2.quantile(1.0 - d3, d2, 0.0);
        return 1.0 - Chi2.cdf(d4, d2, d);
    }

    public static double lambda(double d, double d2, double d3) {
        if (d3 <= 0.0 || d3 >= 1.0) {
            Utility.warning("Chi2.lambda: alpha must be in (0,1)");
            return Double.NaN;
        }
        if (d <= 0.0 || d >= 1.0) {
            Utility.warning("Chi2.lambda: power must be in (0,1)");
            return Double.NaN;
        }
        if (d2 < 0.01) {
            Utility.warning("Chi2.lambda: df must be positive");
            return Double.NaN;
        }
        double d4 = Math.pow(Normal.quantile(1.0 - d), 2.0);
        double d5 = Chi2.quantile(1.0 - d3, d2, 0.0);
        double d6 = 2.0 * (d5 - d2) + 4.0 * d4;
        double d7 = Math.pow(d5 - d2, 2.0) - 2.0 * d2 * d4;
        double d8 = Math.pow(d6, 2.0) - 4.0 * d7;
        double d9 = d > 0.5 ? 1.0 : -1.0;
        double d10 = d8 < 0.0 ? d5 : (d6 + d9 * Math.sqrt(d8)) / 2.0;
        d10 = Math.max(0.5, d10);
        Chi2Aux2 chi2Aux2 = new Chi2Aux2(d2, d3);
        return Solve.search(chi2Aux2, d, d10, 0.5);
    }

    public static double rocArea(double d, double d2, double d3) {
        saveLambda = d;
        saveDf = d2;
        return NumAnal.integral(class$rvl$stat$dist$Chi2 == null ? (class$rvl$stat$dist$Chi2 = Chi2.class$("rvl.stat.dist.Chi2")) : class$rvl$stat$dist$Chi2, "power", 0.0, 1.0, d3, false, 0.0, 1.0);
    }

    public static double rocArea(double d, double d2) {
        return Chi2.rocArea(d, d2, 1.0E-4);
    }

    public static double power(double d) {
        return Chi2.power(saveLambda, saveDf, d);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

