/*
 * Decompiled with CFR 0.152.
 */
package rvl.stat.anova;

import rvl.stat.anova.Factor;
import rvl.stat.anova.Model;
import rvl.stat.anova.Term;

public class WithinCells
extends Factor {
    private Model modl;

    public WithinCells(Model model, int n) {
        this.modl = model;
        if (this.df() <= 0) {
            this.setName("Within");
        } else {
            this.setName("Residual");
        }
        this.setLevels(n);
        this.setRandom(true);
    }

    public int df() {
        int n = this.span() - 1;
        for (int i = 0; i < this.modl.nTerm(); ++i) {
            Term term = this.modl.getTerm(i);
            if (term.equals(this)) continue;
            n -= term.df();
        }
        return n;
    }

    public int span() {
        return this.modl.getNobs();
    }

    public boolean containsFactor(Factor factor) {
        return true;
    }

    public boolean containsTerm(Term term) {
        return true;
    }

    public boolean overlaps(Factor factor) {
        return true;
    }

    public boolean isRandom() {
        return true;
    }

    public void setLevels(int n) {
        this.levels = n < 1 ? 1 : n;
    }

    public int order() {
        return 1;
    }

    public Factor factor(int n) {
        return null;
    }
}

