/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import rvl.piface.Piface;
import rvl.stat.dist.Normal;

public class OnePCIGUI
extends Piface {
    private static String title = "CI for a proportion";
    public double conf;
    public double N;
    public double n;
    public double pi;
    public double Sigma = 0.5;
    public double ME;
    public double zCrit = 1.96;
    public int isFinite;
    public int worstCase;
    static /* synthetic */ Class class$rvl$piface$apps$OnePCIGUI;

    public void gui() {
        this.beginSubpanel(2);
        this.checkbox("isFinite", "Finite population", 1);
        this.field("N", "N", 1000.0, 8, 6);
        this.checkbox("worstCase", "Worst case", 1);
        this.field("pi", 0.5);
        this.endSubpanel();
        this.choice("conf", "Confidence", new double[]{0.9, 0.95, 0.98, 0.99, 0.995}, 1);
        this.bar("ME", "Margin of Error", 0.09297);
        this.bar("n", 25.0);
        this.menuItem("localHelp", "This dialog", this.helpMenu);
        this.n = 100.0;
        this.conf = 0.95;
    }

    public void click() {
        this.zCrit = Normal.quantile(1.0 - (1.0 - this.conf) / 2.0);
        this.worstCase = OnePCIGUI.abs(this.pi - 0.5) < 1.0E-12 ? 1 : 0;
        this.Sigma = OnePCIGUI.sqrt(this.pi * (1.0 - this.pi));
        this.ME = OnePCIGUI.max(this.ME, 0.001 * this.Sigma);
        for (int i = 0; i < 3; ++i) {
            this.n = this.zCrit * this.Sigma / this.ME;
            this.n *= this.n;
            if (this.isFinite == 1) {
                this.n = 1.0 + this.n / (1.0 + this.n / this.N);
            }
            this.n = OnePCIGUI.max(2.0, this.n);
        }
    }

    public void worstCase_changed() {
        if (this.worstCase == 1) {
            this.pi = 0.5;
        }
        this.click();
    }

    public void n_changed() {
        this.N = OnePCIGUI.max(2.0, OnePCIGUI.round(this.N));
        this.n = OnePCIGUI.max(2.0, OnePCIGUI.round(this.n));
        this.zCrit = Normal.quantile(1.0 - (1.0 - this.conf) / 2.0);
        this.ME = this.zCrit * this.Sigma / OnePCIGUI.sqrt(this.n - 1.0);
        if (this.isFinite == 1) {
            this.ME *= OnePCIGUI.sqrt(1.0 - this.n / this.N);
        }
    }

    public void isFinite_changed() {
        this.setVisible("N", this.isFinite == 1);
        this.click();
    }

    public void localHelp() {
        this.showText(class$rvl$piface$apps$OnePCIGUI == null ? (class$rvl$piface$apps$OnePCIGUI = OnePCIGUI.class$("rvl.piface.apps.OnePCIGUI")) : class$rvl$piface$apps$OnePCIGUI, "OnePCIGUIHelp.txt", "Help: One-sample CI for a mean", 25, 60);
    }

    public OnePCIGUI() {
        super(title);
    }

    public static void main(String[] stringArray) {
        new OnePCIGUI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

