/*
 * Decompiled with CFR 0.152.
 */
package rvl.piface.apps;

import java.awt.Color;
import rvl.piface.PiListener;
import rvl.piface.Piface;
import rvl.piface.apps.AnovaCompGUI;
import rvl.piface.apps.AnovaHelper;
import rvl.stat.anova.Factor;
import rvl.stat.anova.Model;
import rvl.stat.anova.Residual;
import rvl.stat.anova.Term;
import rvl.stat.anova.WithinCells;
import rvl.stat.dist.F;
import rvl.util.Utility;

public class AnovaGUI
extends Piface
implements PiListener {
    public double[] n;
    public double[] effSD;
    public double[] power;
    public double alpha;
    public int[] random;
    private Model model;
    protected AnovaCompGUI acg;
    protected boolean ignoreActions = false;
    protected AnovaHelper helper = null;
    static /* synthetic */ Class class$rvl$piface$apps$AnovaGUI;

    public void gui() {
        int n;
        this.n = new double[this.model.nFac()];
        if (this.effSD == null) {
            this.effSD = new double[this.model.nTerm()];
            for (int i = 0; i < this.model.nTerm(); ++i) {
                this.effSD[i] = 1.0;
            }
        }
        this.power = new double[this.model.nTerm()];
        this.random = new int[this.model.nFac()];
        String[] stringArray = new String[]{"Fixed", "Random"};
        this.beginSubpanel(1, false);
        for (n = 0; n < this.model.nFac(); ++n) {
            String string;
            this.beginSubpanel(1, true);
            Factor factor = this.model.getFac(n);
            String string2 = string = factor.isRandom() ? "n[" + factor.getName() + "]" : "levels[" + factor.getName() + "]";
            if (string.equals("n[Residual]")) {
                string = "Replications";
            }
            this.hradio("random[" + n + "]", factor.getName(), stringArray, factor.isRandom() ? 1 : 0);
            this.bar("n[" + n + "]", string, (double)factor.getLevels());
            this.endSubpanel();
        }
        this.endSubpanel();
        this.newColumn();
        n = this.model.nTerm() > 10 ? 1 : 0;
        int n2 = this.model.nTerm() / 2;
        this.beginSubpanel(1, false);
        this.panel.setBackground(new Color(255, 255, 200));
        this.beginSubpanel(2, true);
        for (int i = 0; i < this.model.nTerm(); ++i) {
            if (n != 0 && i == n2) {
                this.endSubpanel();
                this.endSubpanel();
                this.newColumn();
                this.beginSubpanel(1, false);
                this.panel.setBackground(new Color(255, 255, 200));
                this.beginSubpanel(2, true);
            }
            Term term = this.model.getTerm(i);
            this.bar("effSD[" + i + "]", "SD[" + term.getName() + "]", this.effSD[i]);
            if (i < this.model.nTerm() - 1) {
                this.interval("power[" + i + "]", "Power[" + term.getName() + "]", 0.5, 0.0, 1.0);
                continue;
            }
            this.choice("alpha", "Significance level", new double[]{0.001, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2}, 4);
        }
        this.endSubpanel();
        this.endSubpanel();
        this.menuItem("linkHelper", "Effect SD helper");
        this.menuItem("linkComps", "Contrasts/Comparisons");
        this.menuItem("showEMS", "Show EMS");
        this.menuItem("report", "Report");
        this.menuItem("help", "ANOVA help", this.helpMenu);
    }

    public void click() {
        this.power = this.model.power(this.effSD, this.alpha);
        for (int i = 0; i < this.model.nTerm(); ++i) {
            if (!(this.power[i] < 0.0)) continue;
            this.power[i] = Double.NaN;
        }
    }

    public void random_changed() {
        if (this.acg != null) {
            this.errmsg("WARNING: Changing between fixed and random may invalidate");
            this.errmsg("results in the associated comparisons/contrasts dialog!");
        }
        Factor factor = this.model.getFac(this.sourceIndex);
        factor.setRandom(this.random[this.sourceIndex] == 1);
        this.random[this.sourceIndex] = factor.isRandom() ? 1 : 0;
        this.click();
    }

    public void n_changed() {
        this.n[this.sourceIndex] = AnovaGUI.max(1.0, AnovaGUI.round(this.n[this.sourceIndex]));
        this.model.getFac(this.sourceIndex).setLevels((int)this.n[this.sourceIndex]);
        for (int i = 0; i < this.model.nFac(); ++i) {
            this.n[i] = this.model.getFac(i).getLevels();
        }
        this.click();
    }

    public synchronized void restoreVars(double[] dArray) {
        super.restoreVars(dArray);
        for (int i = 0; i < this.model.nFac(); ++i) {
            this.model.getFac(i).setLevels((int)this.n[i]);
        }
    }

    public void power_changed() {
        double d;
        double[] dArray = this.model.getPowerInfo(this.sourceIndex);
        Term term = this.model.getTerm(this.sourceIndex);
        if (!term.isRandom()) {
            double d2 = F.lambda(this.power[this.sourceIndex], dArray[2], dArray[3], this.alpha);
            d = dArray[1] * d2 / dArray[2] / dArray[0];
        } else {
            d = dArray[1] / dArray[0] * (F.quantile(1.0 - this.alpha, dArray[2], dArray[3]) / F.quantile(1.0 - this.power[this.sourceIndex], dArray[2], dArray[3]) - 1.0);
        }
        if (d > 0.0) {
            this.effSD[this.sourceIndex] = AnovaGUI.sqrt(d);
        }
        this.click();
    }

    public void linkHelper() {
        if (this.helper == null) {
            this.helper = new AnovaHelper(this);
            this.helper.setMaster(this);
        } else {
            this.helper.show();
        }
    }

    public void linkComps() {
        this.acg = new AnovaCompGUI(this.getTitle(), this.model, this.effSD);
        this.addPiListener(this.acg);
        this.acg.addPiListener(this);
        this.acg.ag = this;
    }

    public void piAction(String string) {
        if (this.ignoreActions || this.acg == null) {
            return;
        }
        this.setVar(string, this.acg);
        this.callMethodFor(string);
        this.updateVars();
        this.acg.ignoreActions = true;
        this.notifyListeners(string);
        this.acg.ignoreActions = false;
    }

    public void close() {
        if (this.helper != null) {
            this.helper.close();
        }
        if (this.acg != null) {
            this.removePiListener(this.acg);
            this.acg.removePiListener(this);
            this.acg.ag = null;
        }
        this.dispose();
    }

    public void showEMS() {
        this.showText(this.model.EMSString(), "Expected mean squares", 25, 50);
    }

    public void report() {
        this.showText(this.reportString(), "Power-analysis report", 25, 60);
    }

    public void help() {
        this.showText(class$rvl$piface$apps$AnovaGUI == null ? (class$rvl$piface$apps$AnovaGUI = AnovaGUI.class$("rvl.piface.apps.AnovaGUI")) : class$rvl$piface$apps$AnovaGUI, "AnovaGUIHelp.txt", "Help for ANOVA power analysis", 25, 60);
    }

    public String reportString() {
        Term term;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Below is a summary of the factors and terms for the\n");
        stringBuffer.append("balanced ANOVA model under study.  Further explanation is\n");
        stringBuffer.append("given after the results.\n\n");
        stringBuffer.append(this.getTitle() + "\n\n");
        stringBuffer.append(Utility.format("Factor", 14) + "\tlevels\n");
        for (n = 0; n < this.model.nFac(); ++n) {
            term = this.model.getFac(n);
            stringBuffer.append(Utility.format(((Factor)term).getName(), 14) + "\t  " + ((Factor)term).getLevels());
            if (((Factor)term).isRandom()) {
                stringBuffer.append("\trandom\n");
                continue;
            }
            stringBuffer.append("\tfixed\n");
        }
        stringBuffer.append(Utility.format("\nTerm", 22) + "\tdf\tStdDev\tPower\n");
        for (n = 0; n < this.model.nTerm(); ++n) {
            term = this.model.getTerm(n);
            stringBuffer.append(Utility.format(term.getName(), 22) + "\t" + term.df() + "\t");
            stringBuffer.append(Utility.format(this.effSD[n], 4));
            if (this.power[n] >= 0.0) {
                stringBuffer.append("\t" + Utility.format(this.power[n], 4) + "\n");
                continue;
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nAlpha = " + this.alpha + "\n");
        stringBuffer.append("\n\nNOTES:\n\n");
        stringBuffer.append("Effect sizes for each term are expressed as a standard\n");
        stringBuffer.append("deviation.  In the case of a random effect, the standard\n");
        stringBuffer.append("deviation is the square root of its variance component.\n");
        stringBuffer.append("For a fixed effect, the standard deviation is the square\n");
        stringBuffer.append("root of the sum of squares of the model effects (in the\n");
        stringBuffer.append("constrained model), divided by the degrees of freedom for\n");
        stringBuffer.append("the term in question.\n\n");
        stringBuffer.append("In both cases, the expected mean square for a term is\n\n");
        stringBuffer.append("\tK*(StdDev)^2 + EMS(ET)\n\n");
        stringBuffer.append("where K is the number of observations at each distinct\n");
        stringBuffer.append("level of the term, and EMS(ET) is the expected mean square\n");
        stringBuffer.append("for the error term for testing the significance of the\n");
        stringBuffer.append("term.  Please note that the error term ET is based on the\n");
        stringBuffer.append("random (and mixed) effects in the model, and that the\n");
        stringBuffer.append("computed power depends on both the effect size shown for\n");
        stringBuffer.append("the term under test, but also the standard deviations shown\n");
        stringBuffer.append("for all random terms involved in the error term.\n\n");
        stringBuffer.append("This power analysis is based on the \"unrestricted\"\n");
        stringBuffer.append("parameterization of the balanced mixed ANOVA model.  Where\n");
        stringBuffer.append("necessary, error terms are constructed using linear\n");
        stringBuffer.append("combinations of mean squares, and the degrees of freedom\n");
        stringBuffer.append("for the denominator of the approximate F test are computed\n");
        stringBuffer.append("using the Satterthwaite method.\n");
        return stringBuffer.toString();
    }

    public Model getModel() {
        return this.model;
    }

    public AnovaGUI(String string, String string2, int n, String string3, String string4) {
        super(string, false);
        this.model = new Model(string2);
        if (n <= 1) {
            this.model.addTerm(new Residual(this.model));
        } else {
            this.model.addFactor(new WithinCells(this.model, n));
        }
        if (string3 != null) {
            this.model.setLevels(string3);
        }
        if (string4 != null) {
            this.model.setRandom(string4);
        }
        this.build();
    }

    public AnovaGUI(String string, Model model, double[] dArray) {
        super(string, false);
        this.model = model;
        this.effSD = dArray;
        this.build();
    }

    public static void main(String[] stringArray) {
        new AnovaGUI("Nested-factorial model", "grp + Subj(grp) + trt + grp*trt", 2, "grp 4   Subj 5   trt 3", "Subj");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

